/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.languageconfiguration.internal.preferences;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.tm4e.languageconfiguration.LanguageConfigurationPlugin;
import org.eclipse.tm4e.languageconfiguration.internal.registry.ILanguageConfigurationDefinition;
import org.eclipse.tm4e.languageconfiguration.internal.registry.LanguageConfigurationDefinition;
import org.eclipse.tm4e.ui.internal.utils.ContentTypeHelper;

public final class PreferenceHelper {
    @NonNullByDefault(value={})
    private static final Gson DEFAULT_GSON = new GsonBuilder().registerTypeAdapter(LanguageConfigurationDefinition.class, (json, typeOfT, context) -> {
        JsonObject object = json.getAsJsonObject();
        JsonElement pluginId = object.get("pluginId");
        String contentTypeId = object.get("contentTypeId").getAsString();
        IContentType contentType = ContentTypeHelper.getContentTypeById((String)contentTypeId);
        if (contentType == null) {
            LanguageConfigurationPlugin.logError("Cannot load language configuration with unknown content type ID " + contentTypeId, null);
            return null;
        }
        return new LanguageConfigurationDefinition(contentType, object.get("path").getAsString(), pluginId == null ? null : pluginId.getAsString(), object.get("onEnterEnabled").getAsBoolean(), object.get("bracketAutoClosingEnabled").getAsBoolean(), object.get("matchingPairsEnabled").getAsBoolean());
    }).registerTypeAdapter(LanguageConfigurationDefinition.class, (definition, typeOfT, context) -> {
        JsonObject object = new JsonObject();
        object.addProperty("path", definition.getPath());
        object.addProperty("pluginId", definition.getPluginId());
        object.addProperty("contentTypeId", definition.getContentType().getId());
        object.addProperty("onEnterEnabled", Boolean.valueOf(definition.isOnEnterEnabled()));
        object.addProperty("bracketAutoClosingEnabled", Boolean.valueOf(definition.isBracketAutoClosingEnabled()));
        object.addProperty("matchingPairsEnabled", Boolean.valueOf(definition.isMatchingPairsEnabled()));
        return object;
    }).create();

    public static ILanguageConfigurationDefinition[] loadLanguageConfigurationDefinitions(String json) {
        return (ILanguageConfigurationDefinition[])Arrays.stream((LanguageConfigurationDefinition[])DEFAULT_GSON.fromJson(json, LanguageConfigurationDefinition[].class)).filter(Objects::nonNull).toArray(ILanguageConfigurationDefinition[]::new);
    }

    public static String toJson(Collection<ILanguageConfigurationDefinition> definitions) {
        return DEFAULT_GSON.toJson(definitions);
    }

    private PreferenceHelper() {
    }
}

