/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.imports;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Collections;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.imports.IImportsConfiguration;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedFeatures;
import org.eclipse.xtext.xbase.typesystem.util.ContextualVisibilityHelper;
import org.eclipse.xtext.xbase.typesystem.util.IVisibilityHelper;
import org.eclipse.xtext.xtype.XImportDeclaration;

public class StaticallyImportedMemberProvider {
    @Inject
    private IImportsConfiguration importsConfiguration;
    @Inject
    private IResolvedFeatures.Provider resolvedFeaturesProvider;
    @Inject
    private IVisibilityHelper visibilityHelper;

    public Iterable<JvmFeature> findAllFeatures(XImportDeclaration it) {
        JvmDeclaredType importedType = it.getImportedType();
        if (!it.isStatic() || importedType == null) {
            return Collections.emptyList();
        }
        IVisibilityHelper visibilityHelper = this.getVisibilityHelper(it.eResource());
        IResolvedFeatures resolvedFeatures = this.resolvedFeaturesProvider.getResolvedFeatures((JvmType)importedType);
        return Iterables.filter(resolvedFeatures.getAllFeatures(), feature -> feature.isStatic() && visibilityHelper.isVisible((JvmMember)feature) && (it.getMemberName() == null || feature.getSimpleName().startsWith(it.getMemberName())));
    }

    public Iterable<JvmFeature> getAllFeatures(XImportDeclaration it) {
        return this.getAllFeatures(it.eResource(), it.getImportedType(), it.isStatic(), it.isExtension(), it.getMemberName());
    }

    public Iterable<JvmFeature> getAllFeatures(Resource resource, JvmDeclaredType importedType, boolean isStatic, boolean extension, String memberName) {
        if (!isStatic || importedType == null) {
            return Collections.emptyList();
        }
        IVisibilityHelper visibilityHelper = this.getVisibilityHelper(resource);
        IResolvedFeatures resolvedFeatures = this.resolvedFeaturesProvider.getResolvedFeatures((JvmType)importedType);
        return Iterables.filter(resolvedFeatures.getAllFeatures(memberName), feature -> feature.isStatic() && visibilityHelper.isVisible((JvmMember)feature));
    }

    public IVisibilityHelper getVisibilityHelper(Resource resource) {
        String packageName;
        if (resource instanceof XtextResource && (packageName = this.importsConfiguration.getPackageName((XtextResource)resource)) != null) {
            return new ContextualVisibilityHelper(this.visibilityHelper, packageName);
        }
        return this.visibilityHelper;
    }
}

