/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.ui.dialog;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.trace4cps.ui.dialog.ParameterDialog;

public final class CPAdialog
extends ParameterDialog {
    private static final String TITLE = "Critical path analysis";
    private static final String USE_DEFAULT_EPSILON_KEY = "USE_DEFAULT_EPS";
    private DependencyUse depUse = DependencyUse.FULL;

    public CPAdialog(Shell parentShell) {
        super(parentShell, CPAdialog.class.getName());
    }

    @Override
    protected String getTitle() {
        return TITLE;
    }

    @Override
    protected void checkOkButton() {
        Button button = this.getButton(0);
        if (button != null) {
            boolean ok = this.checkSelection() && (this.checkWindowWidth() || this.depUse == DependencyUse.FULL);
            button.setEnabled(ok && this.inputIsValid());
        }
    }

    public double getEpsilon() {
        if (this.get(USE_DEFAULT_EPSILON_KEY, Boolean.class).booleanValue()) {
            return 0.0;
        }
        return this.getPositiveDoubleValue();
    }

    public DependencyUse useDependencies() {
        return this.depUse;
    }

    @Override
    protected void draw(Composite composite) {
        Group useGroup = new Group(composite, 4);
        useGroup.setText("Use of specified dependencies");
        useGroup.setLayout((Layout)new GridLayout(3, true));
        useGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        final Group epsilonGroup = new Group(composite, 4);
        epsilonGroup.setText("Epsilon dependency heuristic");
        epsilonGroup.setLayout((Layout)new GridLayout(3, false));
        GridData data = new GridData(4, 4, true, false);
        epsilonGroup.setLayoutData((Object)data);
        epsilonGroup.setVisible(this.depUse != DependencyUse.FULL);
        final Button epsilonButton = this.addCheckbox((Composite)epsilonGroup, "Use default epsilon", USE_DEFAULT_EPSILON_KEY, true);
        final Composite epsilonInputGroup = this.addPositiveDoubleInput((Composite)epsilonGroup, null, true);
        epsilonInputGroup.setVisible(this.get(USE_DEFAULT_EPSILON_KEY, Boolean.class) == false);
        epsilonButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean useDefaultEpsilon = epsilonButton.getSelection();
                epsilonInputGroup.setVisible(!useDefaultEpsilon);
            }
        });
        Button b2 = new Button((Composite)useGroup, 16);
        b2.setText("Full");
        Button b1 = new Button((Composite)useGroup, 16);
        b1.setText("None");
        Button b3 = new Button((Composite)useGroup, 16);
        b3.setText("As application dependencies");
        if (this.depUse == DependencyUse.NONE) {
            b1.setSelection(true);
        } else if (this.depUse == DependencyUse.FULL) {
            b2.setSelection(true);
        } else if (this.depUse == DependencyUse.APP) {
            b3.setSelection(true);
        }
        b1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CPAdialog.this.depUse = DependencyUse.NONE;
                epsilonGroup.setVisible(true);
                CPAdialog.this.checkOkButton();
            }
        });
        b2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CPAdialog.this.depUse = DependencyUse.FULL;
                epsilonGroup.setVisible(false);
                CPAdialog.this.checkOkButton();
            }
        });
        b3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CPAdialog.this.depUse = DependencyUse.APP;
                epsilonGroup.setVisible(true);
                CPAdialog.this.checkOkButton();
            }
        });
        CPAdialog.applyDialogFont((Control)composite);
    }

    public static enum DependencyUse {
        NONE,
        FULL,
        APP;

    }
}

