/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.widgets.timegraph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.tmf.core.presentation.RGBAColor;
import org.eclipse.tracecompass.tmf.ui.colors.RGBAUtil;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.Utils;

@NonNullByDefault
public final class TimeGraphRender {
    private static final RGBAColor BLACK = new RGBAColor(0, 0, 0, 255);
    private static final ColorRegistry COLOR_REGISTRY = new ColorRegistry();
    private static final Map<Integer, Font> FONTS = new HashMap<Integer, Font>();
    private static final int DPI = Display.getDefault().getDPI().y;
    private static final int PPI = 72;

    public static Color getColor(int colorInt) {
        String hexRGB = Integer.toHexString(colorInt >> 8 & 0xFFFFFF);
        Color color = COLOR_REGISTRY.get(hexRGB);
        if (color == null) {
            COLOR_REGISTRY.put(hexRGB, RGBAUtil.fromInt((int)colorInt).rgb);
            color = Objects.requireNonNull(COLOR_REGISTRY.get(hexRGB));
        }
        return color;
    }

    public static void setFontForHeight(int pixels, GC gc) {
        gc.setFont(FONTS.computeIfAbsent(pixels, px -> {
            int pt = Math.max(px * 72 / DPI, 1);
            FontData fontData = gc.getFont().getFontData()[0];
            Font font = new Font(gc.getDevice(), fontData);
            int height = pt;
            while (height > 0) {
                fontData.setHeight(height);
                font.dispose();
                font = new Font(gc.getDevice(), fontData);
                gc.setFont(font);
                if (gC.textExtent((String)"").y <= px) break;
                --height;
            }
            return font;
        }));
    }

    public static int getMarginForHeight(int height) {
        return height <= 4 ? 0 : Math.max(Math.min(height - 13, 6), 1);
    }

    public static class DeferredEntry
    implements IDrawable {
        private Rectangle fBounds;
        private ITimeGraphEntry fEntry;
        private final List<DeferredItem> fItems = new ArrayList<DeferredItem>();

        public DeferredEntry(ITimeGraphEntry entry, Rectangle bounds) {
            this.fEntry = entry;
            this.fBounds = bounds;
        }

        @Override
        public void draw(@Nullable ITimeGraphPresentationProvider provider, GC gc) {
            int height = this.fBounds.height;
            TimeGraphRender.setFontForHeight(height - TimeGraphRender.getMarginForHeight(height) + 2, gc);
            for (DeferredItem item : this.getItems()) {
                item.draw(provider, gc);
            }
            if (provider != null) {
                provider.postDrawEntry(this.fEntry, this.fBounds, gc);
            }
        }

        public List<DeferredItem> getItems() {
            return this.fItems;
        }
    }

    public static abstract class DeferredItem
    implements IDrawable {
        public static final int NO_BORDER = Integer.MIN_VALUE;
        private final Collection<PostDrawEvent> fPDEs = new ArrayList<PostDrawEvent>();
        private final Rectangle fBounds;
        private RGBAColor fBgColor;
        private final RGBAColor fBorderColor;
        private final int fLineWidth;

        public DeferredItem(DeferredItem other) {
            Rectangle bounds = other.fBounds;
            this.fBounds = new Rectangle(bounds.x, bounds.y, bounds.width, bounds.height);
            this.fBgColor = other.getBackgroundColor();
            this.fPDEs.addAll(other.getPostDrawEvents());
            this.fBorderColor = other.fBorderColor;
            this.fLineWidth = other.fLineWidth;
        }

        public DeferredItem(Rectangle bounds, RGBAColor backgroundColor, RGBAColor borderColor, int lineWidth) {
            this.fBounds = bounds;
            this.fLineWidth = lineWidth;
            this.fBgColor = backgroundColor;
            this.fBorderColor = borderColor;
        }

        public void add(PostDrawEvent pde) {
            this.fPDEs.add(pde);
        }

        @Override
        public final void draw(@Nullable ITimeGraphPresentationProvider provider, GC gc) {
            Rectangle bounds = this.getBounds();
            if (bounds.width <= 0 || bounds.height <= 0) {
                return;
            }
            int prevAlpha = gc.getAlpha();
            Color prevBgColor = gc.getBackground();
            Color prevFgColor = gc.getForeground();
            int prevLineWidth = gc.getLineWidth();
            this.setContext(gc);
            this.innerDraw(gc);
            if (this.fLineWidth != Integer.MIN_VALUE) {
                this.setContext(gc);
                gc.setAlpha((int)this.fBorderColor.getAlpha());
                this.drawBorder(gc);
            }
            this.setContext(gc);
            this.drawLabel(gc);
            if (provider != null) {
                gc.setLineWidth(prevLineWidth);
                gc.setBackground(prevBgColor);
                gc.setForeground(prevFgColor);
                gc.setAlpha(prevAlpha);
                this.postDraw(provider, gc);
            }
            gc.setLineWidth(prevLineWidth);
            gc.setBackground(prevBgColor);
            gc.setForeground(prevFgColor);
            gc.setAlpha(prevAlpha);
        }

        protected void drawBorder(GC gc) {
            gc.drawRectangle(this.getBounds());
        }

        protected void drawLabel(GC gc) {
        }

        public RGBAColor getBackgroundColor() {
            return this.fBgColor;
        }

        public @Nullable RGBAColor getBorderColor() {
            return this.fBorderColor;
        }

        public Rectangle getBounds() {
            return this.fBounds;
        }

        private Collection<PostDrawEvent> getPostDrawEvents() {
            return this.fPDEs;
        }

        protected abstract void innerDraw(GC var1);

        private final void postDraw(ITimeGraphPresentationProvider provider, GC gc) {
            for (PostDrawEvent pde : this.fPDEs) {
                pde.draw(provider, gc);
            }
        }

        protected void setBackgroundColor(RGBAColor color) {
            this.fBgColor = color;
        }

        private void setContext(GC gc) {
            RGBAColor backgroundRgba = this.getBackgroundColor();
            Color bgColor = TimeGraphRender.getColor(backgroundRgba.toInt());
            gc.setAlpha((int)backgroundRgba.getAlpha());
            gc.setBackground(bgColor);
            RGBAColor foregroundRgba = this.getBorderColor();
            if (foregroundRgba == null) {
                foregroundRgba = BLACK;
            }
            Color fgColor = TimeGraphRender.getColor(foregroundRgba.toInt());
            gc.setForeground(fgColor);
            if (this.fLineWidth >= 0) {
                gc.setLineWidth(this.fLineWidth);
            }
        }
    }

    public static class DeferredLine
    implements IDrawable {
        private Rectangle fBounds;
        private long fMin;
        private List<List<LongPoint>> fSeriesPoints;
        private RGBAColor fColorRGBA;
        private double fScale;

        public DeferredLine(Rectangle bounds, long min, List<List<LongPoint>> seriesPoints, RGBAColor colorRGBA, double scale) {
            this.fBounds = bounds;
            this.fMin = min;
            this.fSeriesPoints = seriesPoints;
            this.fColorRGBA = colorRGBA;
            this.fScale = scale;
        }

        @Override
        public void draw(@Nullable ITimeGraphPresentationProvider provider, GC gc) {
            RGBAColor rgba = this.fColorRGBA;
            int colorInt = rgba.toInt();
            Color color = TimeGraphRender.getColor(colorInt);
            int i = 0;
            while (i < this.fSeriesPoints.size()) {
                Color prev = gc.getForeground();
                int prevAlpha = gc.getAlpha();
                gc.setAlpha((int)rgba.getAlpha());
                gc.setForeground(color);
                List<LongPoint> series = this.fSeriesPoints.get(i);
                int[] points = new int[series.size() * 2];
                int point = 0;
                while (point < series.size()) {
                    LongPoint longPoint = series.get(point);
                    points[point * 2] = longPoint.x;
                    points[point * 2 + 1] = this.fBounds.height - (int)((double)(longPoint.y - this.fMin) * this.fScale) + this.fBounds.y;
                    ++point;
                }
                gc.drawPolyline(points);
                gc.setForeground(prev);
                gc.setAlpha(prevAlpha);
                ++i;
            }
        }
    }

    public static class DeferredSegment
    implements IDrawable {
        private final int fX;
        private final int fY;
        private int fLength;

        public DeferredSegment(int x, int y) {
            this.fX = x;
            this.fY = y;
            this.fLength = 1;
        }

        public boolean contains(int x, int y) {
            return y == this.fY && x >= this.fX && x <= this.fX + this.fLength;
        }

        @Override
        public void draw(@Nullable ITimeGraphPresentationProvider provider, GC gc) {
            if (this.fLength == 1) {
                gc.drawPoint(this.fX, this.fY);
            } else {
                gc.drawLine(this.fX, this.fY, this.fX + this.fLength - 1, this.fY);
            }
        }

        public void extend(int x) {
            if (x == this.fX + this.fLength) {
                ++this.fLength;
            }
        }
    }

    public static class DeferredState
    extends DeferredItem {
        private final int fArc;
        private final @Nullable String fLabel;

        public DeferredState(Rectangle bounds, RGBAColor bgColor, RGBAColor borderColor, int arc, int lineWidth, @Nullable String label) {
            super(bounds, bgColor, borderColor, lineWidth);
            this.fArc = arc;
            this.fLabel = label;
        }

        @Override
        protected void drawBorder(GC gc) {
            Rectangle bounds = this.getBounds();
            gc.drawRoundRectangle(bounds.x, bounds.y, bounds.width, bounds.height, this.fArc, this.fArc);
        }

        @Override
        protected void drawLabel(GC gc) {
            Rectangle bounds = this.getBounds();
            RGBAColor backgroundColor = this.getBackgroundColor();
            if (this.fLabel != null && !this.fLabel.isEmpty() && bounds.width > bounds.height) {
                gc.setForeground(Utils.getDistinctColor(RGBAUtil.fromRGBAColor((RGBAColor)backgroundColor).rgb));
                Utils.drawText(gc, this.fLabel, bounds.x, bounds.y, bounds.width, bounds.height, true, true);
            }
        }

        @Override
        protected void innerDraw(GC gc) {
            Rectangle bounds = this.getBounds();
            gc.fillRoundRectangle(bounds.x, bounds.y, bounds.width, bounds.height, this.fArc, this.fArc);
        }
    }

    public static class DeferredTinyState
    extends DeferredItem {
        private static int alphaBlend(int alpha, short c0, short c1) {
            return (int)((double)c0 * ((double)(255 - alpha) / 255.0) + (double)c1 * ((double)alpha / 255.0));
        }

        public static boolean areMergeable(DeferredItem left, DeferredItem right) {
            Rectangle rightBounds = right.getBounds();
            Rectangle largerBounds = new Rectangle(rightBounds.x - 1, rightBounds.y, rightBounds.width + 1, rightBounds.height);
            return Objects.equals(left.getBackgroundColor(), right.getBackgroundColor()) && Objects.equals(left.getBorderColor(), right.getBorderColor()) && largerBounds.intersects(left.getBounds()) && largerBounds.height == right.getBounds().height;
        }

        public DeferredTinyState(DeferredTinyState other) {
            super(other);
        }

        public DeferredTinyState(Rectangle bounds, RGBAColor backgroundColor, RGBAColor borderColor, int lineWidth) {
            super(bounds, backgroundColor, borderColor, lineWidth);
        }

        public boolean extend(DeferredTinyState other) {
            Rectangle bounds = this.getBounds();
            if (DeferredTinyState.areMergeable(this, other)) {
                bounds.add(other.getBounds());
                return true;
            }
            return false;
        }

        @Override
        protected void innerDraw(GC gc) {
            gc.fillRectangle(this.getBounds());
        }

        public boolean squash(DeferredTinyState other) {
            Rectangle bounds = this.getBounds();
            Rectangle otherBounds = other.getBounds();
            if (bounds.x != otherBounds.x || bounds.width != otherBounds.width) {
                return false;
            }
            RGBAColor prevColor = this.getBackgroundColor();
            RGBAColor newColor = other.getBackgroundColor();
            bounds.y = Math.min(bounds.y, otherBounds.y);
            bounds.height = Math.max(bounds.height, otherBounds.height);
            int alpha = newColor.getAlpha() / 2;
            this.setBackgroundColor(new RGBAColor(DeferredTinyState.alphaBlend(alpha, prevColor.getRed(), newColor.getRed()), DeferredTinyState.alphaBlend(alpha, prevColor.getGreen(), newColor.getGreen()), DeferredTinyState.alphaBlend(alpha, prevColor.getBlue(), newColor.getBlue()), DeferredTinyState.alphaBlend(alpha, prevColor.getAlpha(), newColor.getAlpha())));
            return true;
        }
    }

    public static class DeferredTransparentState
    extends DeferredItem {
        public DeferredTransparentState(Rectangle bounds, RGBAColor bgColor) {
            super(bounds, bgColor, BLACK, Integer.MIN_VALUE);
        }

        @Override
        protected void innerDraw(GC gc) {
            Rectangle drawRect = this.getBounds();
            if (drawRect.width >= 2) {
                gc.fillRectangle(drawRect);
                if (drawRect.width > 2) {
                    RGBAColor foregroundRGB = BLACK;
                    gc.setAlpha((int)foregroundRGB.getAlpha());
                    gc.setForeground(TimeGraphRender.getColor(foregroundRGB.toInt()));
                    gc.drawLine(drawRect.x, drawRect.y, drawRect.x + drawRect.width - 1, drawRect.y);
                    gc.drawLine(drawRect.x, drawRect.y + drawRect.height - 1, drawRect.x + drawRect.width - 1, drawRect.y + drawRect.height - 1);
                }
            } else {
                gc.setForeground(gc.getBackground());
                gc.drawLine(drawRect.x, drawRect.y, drawRect.x, drawRect.y + drawRect.height - 1);
            }
        }
    }

    private static interface IDrawable {
        public void draw(@Nullable ITimeGraphPresentationProvider var1, GC var2);
    }

    public static class LongPoint {
        final int x;
        final long y;

        public LongPoint(int x, long y) {
            this.x = x;
            this.y = y;
        }

        public boolean equals(@Nullable Object obj) {
            if (obj instanceof LongPoint) {
                LongPoint longPoint = (LongPoint)obj;
                return longPoint.x == this.x && longPoint.y == this.y;
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.x, this.y);
        }
    }

    public static class PostDrawEvent
    implements IDrawable {
        private Rectangle fBounds;
        private ITimeEvent fEvent;

        public PostDrawEvent(ITimeEvent event, Rectangle bounds) {
            this.fEvent = event;
            this.fBounds = bounds;
        }

        @Override
        public void draw(@Nullable ITimeGraphPresentationProvider provider, GC gc) {
            if (provider != null) {
                provider.postDrawEvent(this.fEvent, this.fBounds, gc);
            }
        }
    }
}

