/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.mapping;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.mapping.ISynchronizationScope;
import org.eclipse.team.core.mapping.ISynchronizationScopeManager;
import org.eclipse.team.core.mapping.provider.SynchronizationScopeManager;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.synchronize.GlobalRefreshElementSelectionPage;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.mapping.ITeamContentProviderDescriptor;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;
import org.eclipse.ui.navigator.INavigatorContentExtension;
import org.eclipse.ui.navigator.INavigatorContentService;
import org.eclipse.ui.navigator.INavigatorContentServiceListener;
import org.eclipse.ui.navigator.NavigatorContentServiceFactory;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class ModelElementSelectionPage
extends GlobalRefreshElementSelectionPage
implements INavigatorContentServiceListener {
    private INavigatorContentService service;
    private ISynchronizationScopeManager manager;
    private ContainerCheckedTreeViewer fViewer;
    private boolean initialized;

    public ModelElementSelectionPage(IResource[] roots) {
        super("elementSelection");
        this.setDescription(TeamUIMessages.GlobalRefreshResourceSelectionPage_2);
        this.setTitle(TeamUIMessages.GlobalRefreshResourceSelectionPage_3);
        ArrayList<ResourceMapping> result = new ArrayList<ResourceMapping>();
        IResource[] iResourceArray = roots;
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            result.add(Utils.getResourceMapping(resource));
            ++n2;
        }
        this.manager = new SynchronizationScopeManager(TeamUIMessages.ModelElementSelectionPage_0, result.toArray(new ResourceMapping[result.size()]), ResourceMappingContext.LOCAL_CONTEXT, true);
    }

    @Override
    protected ContainerCheckedTreeViewer createViewer(Composite top) {
        this.fViewer = new ContainerCheckedTreeViewer(top, 2048);
        this.service = NavigatorContentServiceFactory.INSTANCE.createContentService("org.eclipse.team.ui.navigatorViewer", (StructuredViewer)this.fViewer);
        this.service.bindExtensions(TeamUI.getTeamContentProviderManager().getContentProviderIds(this.manager.getScope()), true);
        this.service.getActivationService().activateExtensions(TeamUI.getTeamContentProviderManager().getContentProviderIds(this.manager.getScope()), true);
        this.service.addListener((INavigatorContentServiceListener)this);
        GridData data = new GridData(1808);
        data.heightHint = 100;
        this.fViewer.getControl().setLayoutData((Object)data);
        this.fViewer.setContentProvider((IContentProvider)this.service.createCommonContentProvider());
        this.fViewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider(this.service.createCommonLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator()));
        this.fViewer.addCheckStateListener(event -> {
            Object element = event.getElement();
            if (event.getChecked() && element instanceof ModelProvider && ((ModelProvider)element).getId().equals("org.eclipse.core.resources.modelProvider")) {
                this.setWorkspaceSelected(true);
            } else {
                ResourceMapping mapping = Utils.getResourceMapping(element);
                if (mapping != null) {
                    if (!(element instanceof ModelProvider)) {
                        this.uncheckOtherModels(mapping.getModelProviderId());
                        event.getCheckable().setChecked(event.getElement(), event.getChecked());
                    }
                    this.updateOKStatus();
                } else {
                    this.updateOKStatus();
                }
            }
        });
        this.fViewer.getTree().addTreeListener(new TreeListener(){

            public void treeCollapsed(TreeEvent e) {
            }

            public void treeExpanded(TreeEvent e) {
                if (ModelElementSelectionPage.this.isWorkingSetSelected()) {
                    ModelElementSelectionPage.this.checkWorkingSetElements();
                }
            }
        });
        this.fViewer.setComparator((ViewerComparator)new ResourceComparator(1));
        return this.fViewer;
    }

    public ResourceMapping[] getSelectedMappings() {
        Object[] objects;
        if (this.isWorkingSetSelected()) {
            IWorkingSet[] sets;
            ArrayList<ResourceMapping> result = new ArrayList<ResourceMapping>();
            IWorkingSet[] iWorkingSetArray = sets = this.getWorkingSets();
            int n = sets.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkingSet set = iWorkingSetArray[n2];
                result.add(Utils.getResourceMapping(set));
                ++n2;
            }
            return result.toArray(new ResourceMapping[result.size()]);
        }
        if (this.isWorkspaceSelected()) {
            try {
                ModelProvider provider = ModelProvider.getModelProviderDescriptor((String)"org.eclipse.core.resources.modelProvider").getModelProvider();
                ResourceMapping mapping = Utils.getResourceMapping(provider);
                if (mapping != null) {
                    return new ResourceMapping[]{mapping};
                }
            }
            catch (CoreException e) {
                TeamUIPlugin.log(e);
            }
            ResourceMapping[] mappings = this.manager.getScope().getMappings("org.eclipse.core.resources.modelProvider");
            return mappings;
        }
        ArrayList<ResourceMapping> result = new ArrayList<ResourceMapping>();
        Object[] objectArray = objects = this.getRootElement();
        int n = objects.length;
        int n3 = 0;
        while (n3 < n) {
            Object object = objectArray[n3];
            ResourceMapping mapping = Utils.getResourceMapping(object);
            if (mapping != null) {
                result.add(mapping);
            }
            ++n3;
        }
        return result.toArray(new ResourceMapping[result.size()]);
    }

    @Override
    public void dispose() {
        this.service.dispose();
        super.dispose();
    }

    @Override
    protected void checkAll() {
        this.getViewer().setCheckedElements((Object[])this.manager.getScope().getModelProviders());
    }

    @Override
    protected boolean checkWorkingSetElements() {
        IWorkingSet[] workingSets;
        ArrayList<Object> allWorkingSetElements = new ArrayList<Object>();
        IWorkingSet[] iWorkingSetArray = workingSets = this.getWorkingSets();
        int n = workingSets.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkingSet set = iWorkingSetArray[n2];
            allWorkingSetElements.addAll(this.computeSelectedResources(new StructuredSelection((Object[])set.getElements())));
            ++n2;
        }
        this.getViewer().setCheckedElements(allWorkingSetElements.toArray());
        return !allWorkingSetElements.isEmpty();
    }

    private Collection<Object> computeSelectedResources(StructuredSelection selection) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object element : selection) {
            ResourceMapping mapping = Utils.getResourceMapping(element);
            if (mapping == null || !this.scopeContainsMapping(mapping)) continue;
            result.add(element);
        }
        return result;
    }

    private boolean scopeContainsMapping(ResourceMapping mapping) {
        ResourceMapping[] mappings;
        ResourceMapping[] resourceMappingArray = mappings = this.manager.getScope().getMappings();
        int n = mappings.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceMapping m = resourceMappingArray[n2];
            if (m.contains(mapping)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void onLoad(INavigatorContentExtension anExtension) {
        anExtension.getStateModel().setProperty("org.eclipse.team.ui.synchronizationScope", (Object)this.manager.getScope());
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && !this.initialized) {
            this.initialize();
            if (this.initialized) {
                ISynchronizationScope syncScope = this.manager.getScope();
                ModelProvider[] providers = syncScope.getModelProviders();
                boolean foundEnabledModelProvider = false;
                ModelProvider[] modelProviderArray = providers;
                int n = providers.length;
                int n2 = 0;
                while (n2 < n) {
                    ModelProvider provider = modelProviderArray[n2];
                    if (this.isEnabled(provider)) {
                        foundEnabledModelProvider = true;
                        break;
                    }
                    ++n2;
                }
                if (!foundEnabledModelProvider && MessageDialog.openConfirm((Shell)this.getShell(), (String)TeamUIMessages.ModelElementSelectionPage_AllModelsDisabledTitle, (String)TeamUIMessages.ModelElementSelectionPage_AllModelsDisabledMessage)) {
                    ArrayList<ITeamContentProviderDescriptor> teamProviderDescriptors = new ArrayList<ITeamContentProviderDescriptor>();
                    ModelProvider[] modelProviderArray2 = providers;
                    int n3 = providers.length;
                    n = 0;
                    while (n < n3) {
                        ModelProvider provider = modelProviderArray2[n];
                        teamProviderDescriptors.add(TeamUI.getTeamContentProviderManager().getDescriptor(provider.getId()));
                        ++n;
                    }
                    ITeamContentProviderDescriptor[] desc = teamProviderDescriptors.toArray(new ITeamContentProviderDescriptor[teamProviderDescriptors.size()]);
                    TeamUI.getTeamContentProviderManager().setEnabledDescriptors(desc);
                }
                this.service.bindExtensions(TeamUI.getTeamContentProviderManager().getContentProviderIds(syncScope), true);
                this.service.getActivationService().activateExtensions(TeamUI.getTeamContentProviderManager().getContentProviderIds(syncScope), true);
                this.fViewer.setInput((Object)syncScope);
                this.initializeScopingHint();
            }
        }
    }

    private void initialize() {
        try {
            this.getContainer().run(true, true, monitor -> {
                try {
                    this.manager.initialize(monitor);
                    this.initialized = true;
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            });
        }
        catch (InvocationTargetException e) {
            Utils.handleError(this.getShell(), e, null, null);
        }
        catch (InterruptedException interruptedException) {}
    }

    private boolean isEnabled(ModelProvider provider) {
        ITeamContentProviderDescriptor desc = TeamUI.getTeamContentProviderManager().getDescriptor(provider.getId());
        return desc != null && desc.isEnabled();
    }

    private void uncheckOtherModels(String modelProviderId) {
        if (!this.isSelectedResourcesSelected()) {
            ModelProvider[] providers = this.manager.getScope().getModelProviders();
            ArrayList<ModelProvider> disabledProviders = new ArrayList<ModelProvider>();
            ModelProvider[] modelProviderArray = providers;
            int n = providers.length;
            int n2 = 0;
            while (n2 < n) {
                ModelProvider provider = modelProviderArray[n2];
                if (!provider.getId().equals(modelProviderId)) {
                    disabledProviders.add(provider);
                }
                ++n2;
            }
            for (ModelProvider disable : disabledProviders) {
                this.fViewer.setChecked((Object)disable, false);
            }
        }
    }
}

