/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.common.core.log;

import java.lang.management.ManagementFactory;
import java.util.LongSummaryStatistics;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.tracecompass.common.core.log.TraceCompassLog;
import org.eclipse.tracecompass.internal.common.core.log.ITraceCompassMonitor;

@NonNullByDefault
public final class TraceCompassMonitor
extends NotificationBroadcasterSupport
implements ITraceCompassMonitor {
    private final LongSummaryStatistics fStats = new LongSummaryStatistics();
    private final String fLabel;

    public TraceCompassMonitor(String label) {
        this.fLabel = label;
        Logger.getLogger("javax.management").setLevel(Level.FINE);
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        String beanName = "org.eclipse.tracecompass.common.core.log:type=TraceCompassMonitoring,name=" + label.replace(':', '-');
        try {
            ObjectName name = new ObjectName(beanName);
            mbs.registerMBean(this, name);
        }
        catch (JMException e) {
            TraceCompassLog.getLogger(this.getClass()).log(Level.WARNING, "Cannot create bean", e);
        }
    }

    @Override
    public @NonNull String getObservedElementName() {
        return this.fLabel;
    }

    @Override
    public double getMeanTime() {
        return this.fStats.getAverage();
    }

    @Override
    public long getMinTime() {
        return this.fStats.getMin();
    }

    @Override
    public long getMaxTime() {
        return this.fStats.getMax();
    }

    @Override
    public long getTotalTime() {
        return this.fStats.getSum();
    }

    @Override
    public long getCount() {
        return this.fStats.getCount();
    }

    public void accept(long value) {
        this.fStats.accept(value);
    }
}

