/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers;

import java.util.ArrayList;
import org.eclipse.debug.internal.ui.viewers.AsynchronousModel;
import org.eclipse.debug.internal.ui.viewers.AsynchronousViewer;
import org.eclipse.debug.internal.ui.viewers.ModelNode;
import org.eclipse.debug.internal.ui.viewers.TableAddRequestMonitor;
import org.eclipse.debug.internal.ui.viewers.TableInsertRequestMonitor;
import org.eclipse.debug.internal.ui.viewers.TableRemoveRequestMonitor;
import org.eclipse.debug.internal.ui.viewers.TableReplaceRequestMonitor;

public class AsynchronousTableModel
extends AsynchronousModel {
    public AsynchronousTableModel(AsynchronousViewer viewer) {
        super(viewer);
    }

    @Override
    protected void add(ModelNode parent, Object element) {
    }

    public void add(Object[] elements) {
        TableAddRequestMonitor update = new TableAddRequestMonitor(this.getRootNode(), elements, this);
        this.requestScheduled(update);
        update.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void added(Object[] elements) {
        ArrayList<Object> kids = null;
        boolean changed = false;
        AsynchronousTableModel asynchronousTableModel = this;
        synchronized (asynchronousTableModel) {
            int n;
            int n2;
            Object[] objectArray;
            ModelNode[] childrenNodes = this.getRootNode().getChildrenNodes();
            if (childrenNodes == null) {
                kids = new ArrayList<Object>(elements.length);
            } else {
                kids = new ArrayList(elements.length + childrenNodes.length);
                objectArray = childrenNodes;
                n2 = childrenNodes.length;
                n = 0;
                while (n < n2) {
                    Object childNode = objectArray[n];
                    kids.add(((ModelNode)childNode).getElement());
                    ++n;
                }
            }
            objectArray = elements;
            n2 = elements.length;
            n = 0;
            while (n < n2) {
                Object element = objectArray[n];
                if (!kids.contains(element)) {
                    kids.add(element);
                    changed = true;
                }
                ++n;
            }
        }
        if (changed) {
            this.setChildren(this.getRootNode(), kids);
        }
    }

    public void insert(Object[] elements, int index) {
        TableInsertRequestMonitor update = new TableInsertRequestMonitor(this.getRootNode(), elements, index, this);
        this.requestScheduled(update);
        update.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void inserted(Object[] elements, int index) {
        ArrayList<Object> kids = null;
        boolean changed = false;
        AsynchronousTableModel asynchronousTableModel = this;
        synchronized (asynchronousTableModel) {
            int n;
            int n2;
            Object[] objectArray;
            ModelNode[] childrenNodes = this.getRootNode().getChildrenNodes();
            if (childrenNodes == null) {
                kids = new ArrayList<Object>(elements.length);
            } else {
                kids = new ArrayList(elements.length + childrenNodes.length);
                objectArray = childrenNodes;
                n2 = childrenNodes.length;
                n = 0;
                while (n < n2) {
                    Object childNode = objectArray[n];
                    kids.add(((ModelNode)childNode).getElement());
                    ++n;
                }
            }
            objectArray = elements;
            n2 = elements.length;
            n = 0;
            while (n < n2) {
                Object element = objectArray[n];
                if (!kids.contains(element)) {
                    kids.add(index, element);
                    ++index;
                    changed = true;
                }
                ++n;
            }
        }
        if (changed) {
            this.setChildren(this.getRootNode(), kids);
        }
    }

    public void remove(Object[] elements) {
        TableRemoveRequestMonitor update = new TableRemoveRequestMonitor(this.getRootNode(), elements, this);
        this.requestScheduled(update);
        update.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removed(Object[] elements) {
        ArrayList<Object> kids = null;
        boolean changed = false;
        AsynchronousTableModel asynchronousTableModel = this;
        synchronized (asynchronousTableModel) {
            ModelNode[] childrenNodes = this.getRootNode().getChildrenNodes();
            if (childrenNodes != null) {
                kids = new ArrayList<Object>(childrenNodes.length);
                Object[] objectArray = childrenNodes;
                int n = childrenNodes.length;
                int n2 = 0;
                while (n2 < n) {
                    ModelNode childrenNode = objectArray[n2];
                    kids.add(childrenNode.getElement());
                    ++n2;
                }
                objectArray = elements;
                n = elements.length;
                n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    if (kids.remove(element)) {
                        changed = true;
                    }
                    ++n2;
                }
            }
        }
        if (changed) {
            this.setChildren(this.getRootNode(), kids);
        }
    }

    public void replace(Object element, Object replacement) {
        TableReplaceRequestMonitor update = new TableReplaceRequestMonitor(this.getRootNode(), element, replacement, this);
        this.requestScheduled(update);
        update.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void replaced(Object element, Object replacement) {
        Object[] filtered = this.filter(this.getRootNode().getElement(), new Object[]{replacement});
        if (filtered.length == 0) {
            this.remove(new Object[]{element});
            return;
        }
        ArrayList<ModelNode> list = new ArrayList<ModelNode>();
        AsynchronousTableModel asynchronousTableModel = this;
        synchronized (asynchronousTableModel) {
            ModelNode[] modelNodeArray = this.getNodes(element);
            int n = modelNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ModelNode node = modelNodeArray[n2];
                node.remap(replacement);
                list.add(node);
                ++n2;
            }
        }
        if (!list.isEmpty()) {
            for (ModelNode node : list) {
                this.getViewer().nodeChanged(node);
            }
        }
    }
}

