/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.control.core.model.impl;

public enum BufferType {
    BUFFER_PER_UID("per UID", "PER_UID"),
    BUFFER_PER_PID("per PID", "PER_PID"),
    BUFFER_SHARED("shared"),
    BUFFER_TYPE_UNKNOWN("information not unavailable");

    private final String fInName;
    private final String fInMiName;

    private BufferType(String name, String miName) {
        this.fInName = name;
        this.fInMiName = miName;
    }

    private BufferType(String name) {
        this.fInName = name;
        this.fInMiName = "";
    }

    public String getInName() {
        return this.fInName;
    }

    public String getInMiName() {
        return this.fInMiName;
    }

    public static BufferType valueOfString(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        BufferType[] bufferTypeArray = BufferType.values();
        int n = bufferTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            boolean isEqual;
            BufferType bufferType = bufferTypeArray[n2];
            boolean bl = isEqual = bufferType.getInName().equalsIgnoreCase(name) || bufferType.getInMiName().equalsIgnoreCase(name);
            if (isEqual) {
                return bufferType;
            }
            ++n2;
        }
        return BUFFER_TYPE_UNKNOWN;
    }
}

