/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTASMDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFieldDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeLocation;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorFunctionStyleMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIncludeStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorPragmaStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorStatement;
import org.eclipse.cdt.core.dom.ast.IASTProblem;
import org.eclipse.cdt.core.dom.ast.IASTProblemDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStandardFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTAliasDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTExplicitTemplateInstantiation;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTLinkageSpecification;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNameSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceAlias;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTStaticAssertDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTypeTransformationSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUsingDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUsingDirective;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTVisibilityLabel;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexManager;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IContributedModelBuilder;
import org.eclipse.cdt.core.model.INamespace;
import org.eclipse.cdt.core.model.IProblemRequestor;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.IStructure;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.ParseError;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.internal.core.dom.parser.ASTQueries;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.model.ASTHolderTUInfo;
import org.eclipse.cdt.internal.core.model.ASTStringUtil;
import org.eclipse.cdt.internal.core.model.CElement;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.cdt.internal.core.model.DebugLogConstants;
import org.eclipse.cdt.internal.core.model.Enumeration;
import org.eclipse.cdt.internal.core.model.EnumerationInfo;
import org.eclipse.cdt.internal.core.model.Enumerator;
import org.eclipse.cdt.internal.core.model.Field;
import org.eclipse.cdt.internal.core.model.FieldInfo;
import org.eclipse.cdt.internal.core.model.Function;
import org.eclipse.cdt.internal.core.model.FunctionDeclaration;
import org.eclipse.cdt.internal.core.model.FunctionInfo;
import org.eclipse.cdt.internal.core.model.FunctionTemplate;
import org.eclipse.cdt.internal.core.model.FunctionTemplateDeclaration;
import org.eclipse.cdt.internal.core.model.Include;
import org.eclipse.cdt.internal.core.model.Macro;
import org.eclipse.cdt.internal.core.model.Method;
import org.eclipse.cdt.internal.core.model.MethodDeclaration;
import org.eclipse.cdt.internal.core.model.MethodInfo;
import org.eclipse.cdt.internal.core.model.MethodTemplate;
import org.eclipse.cdt.internal.core.model.MethodTemplateDeclaration;
import org.eclipse.cdt.internal.core.model.Namespace;
import org.eclipse.cdt.internal.core.model.Parent;
import org.eclipse.cdt.internal.core.model.Pragma;
import org.eclipse.cdt.internal.core.model.SourceManipulation;
import org.eclipse.cdt.internal.core.model.SourceManipulationInfo;
import org.eclipse.cdt.internal.core.model.Structure;
import org.eclipse.cdt.internal.core.model.StructureDeclaration;
import org.eclipse.cdt.internal.core.model.StructureInfo;
import org.eclipse.cdt.internal.core.model.StructureTemplate;
import org.eclipse.cdt.internal.core.model.StructureTemplateDeclaration;
import org.eclipse.cdt.internal.core.model.TranslationUnit;
import org.eclipse.cdt.internal.core.model.TypeDef;
import org.eclipse.cdt.internal.core.model.Using;
import org.eclipse.cdt.internal.core.model.Util;
import org.eclipse.cdt.internal.core.model.Variable;
import org.eclipse.cdt.internal.core.model.VariableDeclaration;
import org.eclipse.cdt.internal.core.model.VariableInfo;
import org.eclipse.cdt.internal.core.model.VariableTemplate;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public class CModelBuilder2
implements IContributedModelBuilder {
    private static final boolean DEBUG = Util.isActive(DebugLogConstants.MODEL);
    private final TranslationUnit fTranslationUnit;
    private final Map<ICElement, CElementInfo> fNewElements;
    private final IProgressMonitor fProgressMonitor;
    private ASTAccessVisibility fCurrentVisibility;
    private Stack<ASTAccessVisibility> fVisibilityStack;
    private HashMap<ISourceReference, int[]> fEqualElements;
    private static final boolean INCLUDE_PRAGMAS_IN_MODEL = Boolean.parseBoolean(System.getProperty("org.eclipse.cdt.core.model_include_pragmas", "true"));

    public CModelBuilder2(ITranslationUnit tu, Map<ICElement, CElementInfo> newElements, IProgressMonitor monitor) {
        this.fTranslationUnit = (TranslationUnit)tu;
        this.fNewElements = newElements;
        this.fProgressMonitor = monitor;
    }

    @Override
    public void parse(boolean quickParseMode) throws Exception {
        IIndexManager indexManager = CCorePlugin.getIndexManager();
        IIndex index = indexManager.getIndex(this.fTranslationUnit.getCProject(), 1024);
        try {
            IASTTranslationUnit ast;
            int parseFlags;
            if (index != null) {
                try {
                    index.acquireReadLock();
                }
                catch (InterruptedException e) {
                    index = null;
                }
            }
            this.checkCanceled();
            long startTime = System.currentTimeMillis();
            CElementInfo elementInfo = this.getElementInfo(this.fTranslationUnit);
            int n = parseFlags = quickParseMode ? 6 : 2;
            parseFlags = !(elementInfo instanceof ASTHolderTUInfo) ? (parseFlags |= 1) : (parseFlags |= 0x20);
            parseFlags |= 0x40;
            parseFlags |= 0x80;
            try {
                ast = this.fTranslationUnit.getAST(index, parseFlags, this.fProgressMonitor);
                if (DEBUG) {
                    Util.debugLog("CModelBuilder2: parsing " + this.fTranslationUnit.getElementName() + " mode=" + (quickParseMode ? "skip all " : "skip indexed ") + " time=" + (System.currentTimeMillis() - startTime) + "ms", DebugLogConstants.MODEL, false);
                }
            }
            catch (ParseError e) {
                this.checkCanceled();
                throw e;
            }
            if (ast == null) {
                return;
            }
            this.checkCanceled();
            startTime = System.currentTimeMillis();
            this.buildModel(ast);
            elementInfo.setIsStructureKnown(true);
            if (DEBUG) {
                Util.debugLog("CModelBuilder2: building children=" + elementInfo.internalGetChildren().size() + " time=" + (System.currentTimeMillis() - startTime) + "ms", DebugLogConstants.MODEL, false);
            }
            if (elementInfo instanceof ASTHolderTUInfo) {
                ((ASTHolderTUInfo)elementInfo).fAST = ast;
                index = null;
            }
        }
        finally {
            if (index != null) {
                index.releaseReadLock();
            }
        }
    }

    private boolean isCanceled() {
        return this.fProgressMonitor != null && this.fProgressMonitor.isCanceled();
    }

    private void checkCanceled() {
        if (this.fProgressMonitor != null && this.fProgressMonitor.isCanceled()) {
            if (DEBUG) {
                Util.debugLog("CModelBuilder2: cancelled ", DebugLogConstants.MODEL, false);
            }
            throw new OperationCanceledException();
        }
    }

    private void buildModel(IASTTranslationUnit ast) throws CModelException, DOMException {
        IASTDeclaration[] declarations;
        this.fVisibilityStack = new Stack();
        this.fEqualElements = new HashMap();
        IASTPreprocessorStatement[] iASTPreprocessorStatementArray = ast.getAllPreprocessorStatements();
        int n = iASTPreprocessorStatementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTPreprocessorStatement statement = iASTPreprocessorStatementArray[n2];
            if (statement instanceof IASTPreprocessorIncludeStatement) {
                if (this.isLocalToFile(statement)) {
                    this.createInclusion(this.fTranslationUnit, (IASTPreprocessorIncludeStatement)statement);
                }
            } else if (statement instanceof IASTPreprocessorMacroDefinition) {
                if (this.isLocalToFile(statement)) {
                    this.createMacro(this.fTranslationUnit, (IASTPreprocessorMacroDefinition)statement);
                }
            } else if (statement instanceof IASTPreprocessorPragmaStatement && INCLUDE_PRAGMAS_IN_MODEL && this.isLocalToFile(statement)) {
                this.createPragma(this.fTranslationUnit, (IASTPreprocessorPragmaStatement)statement);
            }
            ++n2;
        }
        IASTDeclaration[] iASTDeclarationArray = declarations = ast.getDeclarations(true);
        int n3 = declarations.length;
        n = 0;
        while (n < n3) {
            IASTDeclaration declaration = iASTDeclarationArray[n];
            if (this.isLocalToFile(declaration)) {
                this.createDeclaration(this.fTranslationUnit, declaration);
            }
            ++n;
        }
        this.fEqualElements.clear();
        List<ICElement> children = this.getElementInfo(this.fTranslationUnit).internalGetChildren();
        Collections.sort(children, new Comparator<ICElement>(){

            @Override
            public int compare(ICElement o1, ICElement o2) {
                SourceManipulationInfo info1 = CModelBuilder2.this.getSourceManipulationInfo((SourceManipulation)o1);
                SourceManipulationInfo info2 = CModelBuilder2.this.getSourceManipulationInfo((SourceManipulation)o2);
                int delta = info1.getStartPos() - info2.getStartPos();
                if (delta == 0) {
                    delta = info1.getIdStartPos() - info2.getIdStartPos();
                }
                return delta;
            }
        });
        if (this.isCanceled()) {
            return;
        }
        IProblemRequestor problemRequestor = this.fTranslationUnit.getProblemRequestor();
        if (problemRequestor != null && problemRequestor.isActive()) {
            IASTProblem problem;
            IASTProblem[] ppProblems;
            IASTProblem[] problems;
            problemRequestor.beginReporting();
            IASTProblem[] iASTProblemArray = problems = (ppProblems = ast.getPreprocessorProblems());
            int n4 = problems.length;
            int n5 = 0;
            while (n5 < n4) {
                problem = iASTProblemArray[n5];
                if (this.isLocalToFile(problem)) {
                    problemRequestor.acceptProblem(problem);
                }
                ++n5;
            }
            iASTProblemArray = problems = CPPVisitor.getProblems(ast);
            n4 = problems.length;
            n5 = 0;
            while (n5 < n4) {
                problem = iASTProblemArray[n5];
                if (this.isLocalToFile(problem)) {
                    problemRequestor.acceptProblem(problem);
                }
                ++n5;
            }
            problemRequestor.endReporting();
        }
    }

    private boolean isLocalToFile(IASTNode node) {
        return node.isPartOfTranslationUnitFile();
    }

    private Include createInclusion(Parent parent, IASTPreprocessorIncludeStatement inclusion) throws CModelException {
        IASTName name = inclusion.getName();
        Include element = new Include((ICElement)parent, ASTStringUtil.getSimpleName(name), inclusion.isSystemInclude());
        element.setFullPathName(inclusion.getPath());
        this.setIndex(element);
        element.setActive(inclusion.isActive());
        element.setResolved(inclusion.isResolved());
        parent.addChild(element);
        this.setIdentifierPosition((SourceManipulation)element, name);
        this.setBodyPosition(element, (IASTNode)inclusion);
        return element;
    }

    private void setIndex(SourceManipulation element) {
        int[] idx = this.fEqualElements.get(element);
        if (idx == null) {
            idx = new int[1];
            this.fEqualElements.put(element, idx);
        } else {
            idx[0] = idx[0] + 1;
            element.setIndex(idx[0]);
        }
    }

    private Macro createMacro(Parent parent, IASTPreprocessorMacroDefinition macro) throws CModelException {
        IASTName name = macro.getName();
        Macro element = new Macro(parent, ASTStringUtil.getSimpleName(name));
        this.setIndex(element);
        element.setActive(macro.isActive());
        parent.addChild(element);
        this.setIdentifierPosition((SourceManipulation)element, name);
        this.setBodyPosition(element, (IASTNode)macro);
        if (macro instanceof IASTPreprocessorFunctionStyleMacroDefinition) {
            element.setFunctionStyle(true);
        }
        return element;
    }

    private Pragma createPragma(Parent parent, IASTPreprocessorPragmaStatement pragma) throws CModelException {
        String name;
        if (pragma.isPragmaOperator()) {
            name = pragma.getRawSignature();
        } else {
            char[] message = pragma.getMessage();
            name = new String(message);
        }
        Pragma element = new Pragma(parent, name);
        this.setIndex(element);
        element.setActive(pragma.isActive());
        parent.addChild(element);
        this.setIdentifierPosition((SourceManipulation)element, (IASTNode)pragma);
        this.setBodyPosition(element, (IASTNode)pragma);
        element.setPragmaOperator(pragma.isPragmaOperator());
        return element;
    }

    private void createDeclaration(Parent parent, IASTDeclaration declaration) throws CModelException, DOMException {
        if (declaration instanceof IASTFunctionDefinition) {
            this.createFunctionDefinition(parent, (IASTFunctionDefinition)declaration, false);
        } else if (declaration instanceof IASTSimpleDeclaration) {
            this.createSimpleDeclarations(parent, (IASTSimpleDeclaration)declaration, false);
        } else if (declaration instanceof ICPPASTVisibilityLabel) {
            this.handleVisibilityLabel((ICPPASTVisibilityLabel)declaration);
        } else if (declaration instanceof ICPPASTNamespaceDefinition) {
            this.createNamespace(parent, (ICPPASTNamespaceDefinition)declaration);
        } else if (!(declaration instanceof ICPPASTNamespaceAlias)) {
            if (declaration instanceof ICPPASTTemplateDeclaration) {
                this.createTemplateDeclaration(parent, (ICPPASTTemplateDeclaration)declaration);
            } else if (!(declaration instanceof ICPPASTTemplateSpecialization || declaration instanceof ICPPASTExplicitTemplateInstantiation || declaration instanceof ICPPASTAliasDeclaration)) {
                if (declaration instanceof ICPPASTUsingDeclaration) {
                    this.createUsingDeclaration(parent, (ICPPASTUsingDeclaration)declaration);
                } else if (declaration instanceof ICPPASTUsingDirective) {
                    this.createUsingDirective(parent, (ICPPASTUsingDirective)declaration);
                } else if (declaration instanceof ICPPASTLinkageSpecification) {
                    this.createLinkageSpecification(parent, (ICPPASTLinkageSpecification)declaration);
                } else if (!(declaration instanceof IASTASMDeclaration) && !(declaration instanceof IASTProblemDeclaration) && !(declaration instanceof ICPPASTStaticAssertDeclaration)) assert (false) : "TODO: " + declaration.getClass().getName();
            }
        }
    }

    private void createTemplateDeclaration(Parent parent, ICPPASTTemplateDeclaration templateDeclaration) throws CModelException, DOMException {
        IASTDeclaration declaration = templateDeclaration.getDeclaration();
        if (declaration instanceof IASTFunctionDefinition) {
            FunctionDeclaration element = this.createFunctionDefinition(parent, (IASTFunctionDefinition)declaration, true);
            String[] parameterTypes = ASTStringUtil.getTemplateParameterArray(templateDeclaration.getTemplateParameters());
            if (element instanceof FunctionTemplate) {
                FunctionTemplate functionTemplate = (FunctionTemplate)element;
                functionTemplate.setTemplateParameterTypes(parameterTypes);
            } else if (element instanceof MethodTemplate) {
                MethodTemplate methodTemplate = (MethodTemplate)element;
                methodTemplate.setTemplateParameterTypes(parameterTypes);
            }
            if (element instanceof SourceManipulation) {
                this.setBodyPosition(element, (IASTNode)templateDeclaration);
            }
        } else if (declaration instanceof IASTSimpleDeclaration) {
            CElement[] elements = this.createSimpleDeclarations(parent, (IASTSimpleDeclaration)declaration, true);
            String[] parameterTypes = ASTStringUtil.getTemplateParameterArray(templateDeclaration.getTemplateParameters());
            CElement[] cElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                MethodDeclaration methodTemplate;
                FunctionDeclaration functionTemplate;
                StructureDeclaration classTemplate;
                CElement element = cElementArray[n2];
                if (element instanceof StructureTemplate) {
                    classTemplate = (StructureTemplate)element;
                    ((StructureTemplate)classTemplate).setTemplateParameterTypes(parameterTypes);
                } else if (element instanceof StructureTemplateDeclaration) {
                    classTemplate = (StructureTemplateDeclaration)element;
                    ((StructureTemplateDeclaration)classTemplate).setTemplateParameterTypes(parameterTypes);
                } else if (element instanceof VariableTemplate) {
                    VariableTemplate varTemplate = (VariableTemplate)element;
                    varTemplate.setTemplateParameterTypes(parameterTypes);
                } else if (element instanceof FunctionTemplateDeclaration) {
                    functionTemplate = (FunctionTemplateDeclaration)element;
                    ((FunctionTemplateDeclaration)functionTemplate).setTemplateParameterTypes(parameterTypes);
                } else if (element instanceof MethodTemplateDeclaration) {
                    methodTemplate = (MethodTemplateDeclaration)element;
                    ((MethodTemplateDeclaration)methodTemplate).setTemplateParameterTypes(parameterTypes);
                } else if (element instanceof FunctionTemplate) {
                    functionTemplate = (FunctionTemplate)element;
                    ((FunctionTemplate)functionTemplate).setTemplateParameterTypes(parameterTypes);
                } else if (element instanceof MethodTemplate) {
                    methodTemplate = (MethodTemplate)element;
                    ((MethodTemplate)methodTemplate).setTemplateParameterTypes(parameterTypes);
                }
                if (element instanceof SourceManipulation) {
                    this.setBodyPosition((SourceManipulation)element, (IASTNode)templateDeclaration);
                }
                ++n2;
            }
        } else if (declaration instanceof ICPPASTAliasDeclaration) {
            this.createDeclaration(parent, declaration);
        } else if (declaration instanceof ICPPASTTemplateDeclaration) {
            this.createTemplateDeclaration(parent, (ICPPASTTemplateDeclaration)declaration);
        } else if (!(declaration instanceof IASTProblemDeclaration)) assert (false) : "TODO: " + declaration.getClass().getName();
    }

    private void createLinkageSpecification(Parent parent, ICPPASTLinkageSpecification linkageDeclaration) throws CModelException, DOMException {
        IASTDeclaration[] declarations;
        IASTDeclaration[] iASTDeclarationArray = declarations = linkageDeclaration.getDeclarations(true);
        int n = declarations.length;
        int n2 = 0;
        while (n2 < n) {
            IASTDeclaration declaration = iASTDeclarationArray[n2];
            if (linkageDeclaration.getFileLocation() != null || this.isLocalToFile(declaration)) {
                this.createDeclaration(parent, declaration);
            }
            ++n2;
        }
    }

    private CElement[] createSimpleDeclarations(Parent parent, IASTSimpleDeclaration declaration, boolean isTemplate) throws CModelException, DOMException {
        CElement[] elements;
        boolean isCompositeType;
        IASTDeclSpecifier declSpecifier = declaration.getDeclSpecifier();
        IASTDeclarator[] declarators = declaration.getDeclarators();
        boolean bl = isCompositeType = declSpecifier instanceof IASTCompositeTypeSpecifier || declSpecifier instanceof IASTEnumerationSpecifier;
        if (declarators.length == 0) {
            CElement element = this.createSimpleDeclaration(parent, declSpecifier, null, isTemplate);
            elements = new CElement[]{element};
        } else {
            if (isCompositeType) {
                this.createSimpleDeclaration(parent, declSpecifier, null, isTemplate);
            }
            elements = new CElement[declarators.length];
            int i = 0;
            while (i < declarators.length) {
                IASTDeclarator declarator = declarators[i];
                CElement element = this.createSimpleDeclaration(parent, declSpecifier, declarator, isTemplate);
                if (!isTemplate && element instanceof SourceManipulation && declarators.length > 1) {
                    this.setBodyPosition((SourceManipulation)element, (IASTNode)declarator);
                }
                elements[i] = element;
                ++i;
            }
        }
        return elements;
    }

    private CElement createSimpleDeclaration(Parent parent, IASTDeclSpecifier declSpecifier, IASTDeclarator declarator, boolean isTemplate) throws CModelException, DOMException {
        if (declSpecifier instanceof IASTCompositeTypeSpecifier) {
            if (declarator != null) {
                return this.createTypedefOrFunctionOrVariable(parent, declSpecifier, declarator, isTemplate);
            }
            return this.createCompositeType(parent, (IASTCompositeTypeSpecifier)declSpecifier, isTemplate);
        }
        if (declSpecifier instanceof IASTElaboratedTypeSpecifier) {
            if (declarator != null) {
                return this.createTypedefOrFunctionOrVariable(parent, declSpecifier, declarator, isTemplate);
            }
            return this.createElaboratedTypeDeclaration(parent, (IASTElaboratedTypeSpecifier)declSpecifier, isTemplate);
        }
        if (declSpecifier instanceof IASTEnumerationSpecifier) {
            if (declarator != null) {
                return this.createTypedefOrFunctionOrVariable(parent, declSpecifier, declarator, isTemplate);
            }
            return this.createEnumeration(parent, (IASTEnumerationSpecifier)declSpecifier);
        }
        if (declSpecifier instanceof IASTNamedTypeSpecifier) {
            if (declarator != null) {
                return this.createTypedefOrFunctionOrVariable(parent, declSpecifier, declarator, isTemplate);
            }
        } else if (declSpecifier instanceof IASTSimpleDeclSpecifier) {
            if (declarator != null) {
                return this.createTypedefOrFunctionOrVariable(parent, declSpecifier, declarator, isTemplate);
            }
        } else if (declSpecifier instanceof ICPPASTTypeTransformationSpecifier) {
            if (declarator != null) {
                return this.createTypedefOrFunctionOrVariable(parent, declSpecifier, declarator, isTemplate);
            }
        } else assert (false) : "TODO: " + declSpecifier.getClass().getName();
        return null;
    }

    private CElement createTypedefOrFunctionOrVariable(Parent parent, IASTDeclSpecifier declSpecifier, IASTDeclarator declarator, boolean isTemplate) throws CModelException {
        assert (declarator != null);
        if (declSpecifier.getStorageClass() == 1) {
            return this.createTypeDef(parent, declSpecifier, declarator);
        }
        IASTDeclarator typeRelevant = ASTQueries.findTypeRelevantDeclarator(declarator);
        if (typeRelevant instanceof IASTFunctionDeclarator) {
            return this.createFunctionDeclaration(parent, declSpecifier, (IASTFunctionDeclarator)typeRelevant, isTemplate);
        }
        return this.createVariable(parent, declSpecifier, declarator, isTemplate);
    }

    private void createNamespace(Parent parent, ICPPASTNamespaceDefinition declaration) throws CModelException, DOMException {
        IASTDeclaration[] nsDeclarations;
        String type = "namespace";
        IASTName name = declaration.getName();
        String nsName = ASTStringUtil.getQualifiedName(name);
        Namespace element = new Namespace(parent, nsName);
        this.setIndex(element);
        element.setActive(declaration.isActive());
        parent.addChild(element);
        if (name != null && nsName.length() > 0) {
            this.setIdentifierPosition((SourceManipulation)element, name);
        } else {
            IASTFileLocation nsLocation = declaration.getFileLocation();
            if (nsLocation != null) {
                this.getSourceManipulationInfo(element).setIdPos(nsLocation.getNodeOffset(), "namespace".length());
            }
        }
        this.setBodyPosition(element, (IASTNode)declaration);
        element.setTypeName("namespace");
        IASTDeclaration[] iASTDeclarationArray = nsDeclarations = declaration.getDeclarations(true);
        int n = nsDeclarations.length;
        int n2 = 0;
        while (n2 < n) {
            IASTDeclaration nsDeclaration = iASTDeclarationArray[n2];
            if (declaration.getFileLocation() != null || this.isLocalToFile(nsDeclaration)) {
                this.createDeclaration(element, nsDeclaration);
            }
            ++n2;
        }
    }

    private StructureDeclaration createElaboratedTypeDeclaration(Parent parent, IASTElaboratedTypeSpecifier elaboratedTypeSpecifier, boolean isTemplate) throws CModelException {
        String type;
        int kind;
        switch (elaboratedTypeSpecifier.getKind()) {
            case 1: {
                kind = isTemplate ? 84 : 66;
                type = "struct";
                break;
            }
            case 2: {
                kind = isTemplate ? 86 : 68;
                type = "union";
                break;
            }
            case 3: {
                kind = isTemplate ? 82 : 64;
                type = "class";
                break;
            }
            case 0: {
                kind = 64;
                type = "enum";
                break;
            }
            default: {
                kind = 64;
                type = "";
            }
        }
        IASTName astClassName = elaboratedTypeSpecifier.getName();
        String className = ASTStringUtil.getSimpleName(astClassName);
        StructureDeclaration element = isTemplate ? new StructureTemplateDeclaration((ICElement)parent, kind, className) : new StructureDeclaration(parent, className, kind);
        this.setIndex(element);
        element.setActive(elaboratedTypeSpecifier.isActive());
        StructureInfo info = (StructureInfo)this.getElementInfo(element);
        info.setTypeName(type);
        parent.addChild(element);
        if (className.length() > 0) {
            this.setIdentifierPosition(info, (IASTNode)astClassName);
        } else {
            IASTFileLocation classLocation = CModelBuilder2.getMinFileLocation(elaboratedTypeSpecifier.getNodeLocations());
            if (classLocation != null) {
                info.setIdPos(classLocation.getNodeOffset(), type.length());
            }
        }
        this.setBodyPosition(info, (IASTNode)elaboratedTypeSpecifier);
        return element;
    }

    private Enumeration createEnumeration(Parent parent, IASTEnumerationSpecifier enumSpecifier) throws CModelException {
        IASTEnumerationSpecifier.IASTEnumerator[] enumerators;
        String type = "enum";
        IASTName astEnumName = enumSpecifier.getName();
        String enumName = ASTStringUtil.getSimpleName(astEnumName);
        Enumeration element = new Enumeration(parent, enumName);
        this.setIndex(element);
        element.setActive(enumSpecifier.isActive());
        parent.addChild(element);
        EnumerationInfo info = (EnumerationInfo)this.getElementInfo(element);
        if (astEnumName != null && enumName.length() > 0) {
            this.setIdentifierPosition(info, (IASTNode)astEnumName);
        } else {
            IASTFileLocation enumLocation = enumSpecifier.getFileLocation();
            info.setIdPos(enumLocation.getNodeOffset(), "enum".length());
        }
        IASTEnumerationSpecifier.IASTEnumerator[] iASTEnumeratorArray = enumerators = enumSpecifier.getEnumerators();
        int n = enumerators.length;
        int n2 = 0;
        while (n2 < n) {
            IASTEnumerationSpecifier.IASTEnumerator enumerator = iASTEnumeratorArray[n2];
            this.createEnumerator(element, enumerator);
            ++n2;
        }
        this.setBodyPosition(info, (IASTNode)enumSpecifier);
        info.setTypeName("enum");
        return element;
    }

    private Enumerator createEnumerator(Parent enumarator, IASTEnumerationSpecifier.IASTEnumerator enumDef) throws CModelException {
        IASTName astEnumName = enumDef.getName();
        Enumerator element = new Enumerator(enumarator, ASTStringUtil.getSimpleName(astEnumName));
        this.setIndex(element);
        element.setActive(enumDef.isActive());
        IASTExpression initialValue = enumDef.getValue();
        if (initialValue != null) {
            element.setConstantExpression(ASTStringUtil.getExpressionString(initialValue));
        }
        enumarator.addChild(element);
        this.setIdentifierPosition((SourceManipulation)element, astEnumName);
        this.setBodyPosition(element, (IASTNode)enumDef);
        return element;
    }

    private Structure createCompositeType(Parent parent, IASTCompositeTypeSpecifier compositeTypeSpecifier, boolean isTemplate) throws CModelException, DOMException {
        int n;
        int n2;
        IASTNode[] iASTNodeArray;
        Structure element;
        ASTAccessVisibility defaultVisibility;
        String type;
        int kind;
        switch (compositeTypeSpecifier.getKey()) {
            case 1: {
                kind = isTemplate ? 85 : 67;
                type = "struct";
                defaultVisibility = ASTAccessVisibility.PUBLIC;
                break;
            }
            case 2: {
                kind = isTemplate ? 87 : 69;
                type = "union";
                defaultVisibility = ASTAccessVisibility.PUBLIC;
                break;
            }
            case 3: {
                kind = isTemplate ? 83 : 65;
                type = "class";
                defaultVisibility = ASTAccessVisibility.PRIVATE;
                break;
            }
            default: {
                kind = 65;
                type = "";
                defaultVisibility = ASTAccessVisibility.PUBLIC;
            }
        }
        IASTName astClassName = compositeTypeSpecifier.getName();
        String className = ASTStringUtil.getSimpleName(astClassName);
        if (!isTemplate) {
            Structure classElement;
            element = classElement = new Structure((ICElement)parent, kind, className);
        } else {
            StructureTemplate classTemplate = new StructureTemplate((ICElement)parent, kind, className);
            element = classTemplate;
        }
        this.setIndex(element);
        element.setActive(compositeTypeSpecifier.isActive());
        if (compositeTypeSpecifier instanceof ICPPASTCompositeTypeSpecifier) {
            ICPPASTCompositeTypeSpecifier cppCompositeTypeSpecifier = (ICPPASTCompositeTypeSpecifier)compositeTypeSpecifier;
            ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier[] baseSpecifiers = cppCompositeTypeSpecifier.getBaseSpecifiers();
            iASTNodeArray = baseSpecifiers;
            n2 = baseSpecifiers.length;
            n = 0;
            while (n < n2) {
                ASTAccessVisibility visibility;
                ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier baseSpecifier = iASTNodeArray[n];
                ICPPASTNameSpecifier nameSpec = baseSpecifier.getNameSpecifier();
                switch (baseSpecifier.getVisibility()) {
                    case 1: {
                        visibility = ASTAccessVisibility.PUBLIC;
                        break;
                    }
                    case 2: {
                        visibility = ASTAccessVisibility.PROTECTED;
                        break;
                    }
                    case 3: {
                        visibility = ASTAccessVisibility.PRIVATE;
                        break;
                    }
                    default: {
                        visibility = ASTAccessVisibility.PUBLIC;
                    }
                }
                if (nameSpec instanceof IASTName) {
                    element.addSuperClass(ASTStringUtil.getSimpleName((IASTName)((Object)nameSpec)), visibility);
                } else {
                    element.addSuperClass(new String(nameSpec.toCharArray()), visibility);
                }
                ++n;
            }
        }
        StructureInfo info = (StructureInfo)this.getElementInfo(element);
        info.setTypeName(type);
        parent.addChild(element);
        if (!isTemplate) {
            this.setBodyPosition(info, (IASTNode)compositeTypeSpecifier);
        }
        if (className.length() > 0) {
            this.setIdentifierPosition(info, (IASTNode)astClassName);
        } else {
            IASTFileLocation classLocation = CModelBuilder2.getMinFileLocation(compositeTypeSpecifier.getNodeLocations());
            if (classLocation != null) {
                info.setIdPos(classLocation.getNodeOffset(), type.length());
            }
        }
        this.pushDefaultVisibility(defaultVisibility);
        try {
            IASTDeclaration[] memberDeclarations = compositeTypeSpecifier.getDeclarations(true);
            iASTNodeArray = memberDeclarations;
            n2 = memberDeclarations.length;
            n = 0;
            while (n < n2) {
                IASTNode member = iASTNodeArray[n];
                if (compositeTypeSpecifier.getFileLocation() != null || this.isLocalToFile(member)) {
                    this.createDeclaration(element, (IASTDeclaration)member);
                }
                ++n;
            }
        }
        finally {
            this.popDefaultVisibility();
        }
        return element;
    }

    private TypeDef createTypeDef(Parent parent, IASTDeclSpecifier declSpecifier, IASTDeclarator declarator) throws CModelException {
        IASTDeclarator nestedDeclarator = declarator;
        while (nestedDeclarator.getNestedDeclarator() != null) {
            nestedDeclarator = nestedDeclarator.getNestedDeclarator();
        }
        IASTName astTypedefName = nestedDeclarator.getName();
        if (astTypedefName == null) {
            return null;
        }
        String name = ASTStringUtil.getSimpleName(astTypedefName);
        TypeDef element = new TypeDef(parent, name);
        this.setIndex(element);
        element.setActive(declarator.isActive());
        String typeName = ASTStringUtil.getSignatureString(declSpecifier, declarator);
        element.setTypeName(typeName);
        parent.addChild(element);
        SourceManipulationInfo info = this.getSourceManipulationInfo(element);
        if (name.length() > 0) {
            this.setIdentifierPosition(info, (IASTNode)astTypedefName);
        } else {
            this.setIdentifierPosition(info, (IASTNode)declSpecifier);
        }
        if (declSpecifier instanceof IASTCompositeTypeSpecifier) {
            this.setBodyPosition(info, (IASTNode)astTypedefName);
        } else {
            this.setBodyPosition(info, declSpecifier.getParent());
        }
        return element;
    }

    private VariableDeclaration createVariable(Parent parent, IASTDeclSpecifier specifier, IASTDeclarator declarator, boolean isTemplate) throws CModelException {
        SourceManipulationInfo info;
        VariableDeclaration element;
        IASTDeclarator nestedDeclarator = declarator;
        while (nestedDeclarator.getNestedDeclarator() != null) {
            nestedDeclarator = nestedDeclarator.getNestedDeclarator();
        }
        IASTName astVariableName = nestedDeclarator.getName();
        if (astVariableName == null) {
            return null;
        }
        String variableName = ASTStringUtil.getQualifiedName(astVariableName);
        if (declarator instanceof IASTFieldDeclarator || parent instanceof IStructure || CModelBuilder2.getScope(astVariableName) instanceof ICPPClassScope) {
            Field newElement = new Field(parent, variableName);
            this.setIndex(newElement);
            FieldInfo fieldInfo = (FieldInfo)this.getElementInfo(newElement);
            if (specifier instanceof ICPPASTDeclSpecifier) {
                ICPPASTDeclSpecifier cppSpecifier = (ICPPASTDeclSpecifier)specifier;
                fieldInfo.setMutable(cppSpecifier.getStorageClass() == 6);
            }
            fieldInfo.setTypeName(ASTStringUtil.getSignatureString(specifier, declarator));
            fieldInfo.setVisibility(this.getCurrentVisibility());
            fieldInfo.setConst(specifier.isConst());
            fieldInfo.setVolatile(specifier.isVolatile());
            element = newElement;
            info = fieldInfo;
        } else {
            VariableDeclaration newElement;
            if (isTemplate) {
                newElement = new VariableTemplate(parent, variableName);
                element = newElement;
            } else if (specifier.getStorageClass() == 2) {
                newElement = new VariableDeclaration(parent, variableName);
                element = newElement;
            } else {
                newElement = new Variable(parent, variableName);
                element = newElement;
            }
            this.setIndex(element);
            VariableInfo varInfo = (VariableInfo)this.getElementInfo(element);
            varInfo.setTypeName(ASTStringUtil.getSignatureString(specifier, declarator));
            varInfo.setConst(specifier.isConst());
            varInfo.setVolatile(specifier.isVolatile());
            info = varInfo;
        }
        element.setActive(declarator.isActive());
        element.setStatic(specifier.getStorageClass() == 3);
        parent.addChild(element);
        this.setIdentifierPosition(info, (IASTNode)astVariableName);
        if (!isTemplate) {
            if (specifier instanceof IASTCompositeTypeSpecifier) {
                this.setBodyPosition(info, (IASTNode)astVariableName);
            } else {
                this.setBodyPosition(info, specifier.getParent());
            }
        }
        return element;
    }

    private FunctionDeclaration createFunctionDefinition(Parent parent, IASTFunctionDefinition functionDeclaration, boolean isTemplate) throws CModelException, DOMException {
        FunctionInfo info;
        FunctionDeclaration element;
        IASTFunctionDeclarator declarator;
        IASTDeclarator nestedDeclarator = declarator = functionDeclaration.getDeclarator();
        while (nestedDeclarator.getNestedDeclarator() != null) {
            nestedDeclarator = nestedDeclarator.getNestedDeclarator();
        }
        IASTName name = nestedDeclarator.getName();
        if (name == null) {
            return null;
        }
        IASTDeclSpecifier declSpecifier = functionDeclaration.getDeclSpecifier();
        String simpleName = ASTStringUtil.getSimpleName(name);
        String[] parameterTypes = ASTStringUtil.getParameterSignatureArray(declarator);
        String returnType = ASTStringUtil.getReturnTypeString(declSpecifier, declarator);
        if (declarator instanceof ICPPASTFunctionDeclarator) {
            IASTName simpleAstName;
            ICPPASTFunctionDeclarator cppFunctionDeclarator = (ICPPASTFunctionDeclarator)declarator;
            if (name instanceof ICPPASTQualifiedName) {
                ICPPASTQualifiedName quName = (ICPPASTQualifiedName)name;
                simpleAstName = quName.getLastName();
            } else {
                simpleAstName = name;
            }
            IScope scope = null;
            boolean isMethod = parent instanceof IStructure;
            if (!isMethod && name instanceof ICPPASTQualifiedName) {
                if (isTemplate) {
                    ICPPASTNameSpecifier[] segments;
                    ICPPASTNameSpecifier[] iCPPASTNameSpecifierArray = segments = ((ICPPASTQualifiedName)name).getAllSegments();
                    int n = segments.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ICPPASTNameSpecifier segment = iCPPASTNameSpecifierArray[n2];
                        if (segment instanceof ICPPASTTemplateId) {
                            isMethod = true;
                            break;
                        }
                        ++n2;
                    }
                }
                if (!isMethod) {
                    scope = CPPVisitor.getContainingScope(simpleAstName);
                    boolean bl = isMethod = scope instanceof ICPPClassScope || simpleAstName.resolveBinding() instanceof ICPPMethod;
                }
            }
            if (isMethod) {
                IBinding binding;
                String methodName = parent instanceof IStructure ? ASTStringUtil.getSimpleName(name) : ASTStringUtil.getQualifiedName(name);
                Method methodElement = isTemplate ? new MethodTemplate(parent, methodName) : new Method(parent, methodName);
                element = methodElement;
                methodElement.setParameterTypes(parameterTypes);
                methodElement.setReturnType(returnType);
                methodElement.setConst(cppFunctionDeclarator.isConst());
                this.setIndex(element);
                MethodInfo methodInfo = (MethodInfo)this.getElementInfo(methodElement);
                info = methodInfo;
                ICPPMethod methodBinding = null;
                if (scope != null && (binding = simpleAstName.resolveBinding()) instanceof ICPPMethod) {
                    methodBinding = (ICPPMethod)binding;
                }
                if (methodBinding != null) {
                    methodInfo.setVirtual(methodBinding.isVirtual());
                    methodInfo.setInline(methodBinding.isInline());
                    methodInfo.setFriend(((ICPPASTDeclSpecifier)declSpecifier).isFriend());
                    methodInfo.setVolatile(cppFunctionDeclarator.isVolatile());
                    methodInfo.setVisibility(this.adaptVisibilityConstant(methodBinding.getVisibility()));
                    methodInfo.setPureVirtual(false);
                    methodElement.setConstructor(methodBinding instanceof ICPPConstructor);
                    methodElement.setDestructor(methodBinding.isDestructor());
                } else {
                    ICPPASTNameSpecifier nameSpec;
                    ICPPASTQualifiedName quName;
                    ICPPASTNameSpecifier[] qualifier;
                    if (declSpecifier instanceof ICPPASTDeclSpecifier) {
                        ICPPASTDeclSpecifier cppDeclSpecifier = (ICPPASTDeclSpecifier)declSpecifier;
                        methodInfo.setVirtual(cppDeclSpecifier.isVirtual());
                        methodInfo.setInline(cppDeclSpecifier.isInline());
                        methodInfo.setFriend(cppDeclSpecifier.isFriend());
                    }
                    methodInfo.setVolatile(cppFunctionDeclarator.isVolatile());
                    methodInfo.setVisibility(this.getCurrentVisibility());
                    methodInfo.setPureVirtual(false);
                    boolean isConstructor = scope != null ? CPPVisitor.isConstructor(scope, declarator) : (parent instanceof IStructure ? parent.getElementName().equals(simpleName) : (name instanceof ICPPASTQualifiedName ? ((qualifier = (quName = (ICPPASTQualifiedName)name).getQualifier()).length == 0 ? false : (nameSpec = qualifier[qualifier.length - 1]) instanceof IASTName && simpleName.equals(ASTStringUtil.getSimpleName((IASTName)((Object)nameSpec)))) : false));
                    methodElement.setConstructor(isConstructor);
                    methodElement.setDestructor(simpleName.charAt(0) == '~');
                }
            } else {
                ICPPASTNameSpecifier nameSpec;
                ICPPASTQualifiedName quName;
                ICPPASTNameSpecifier[] qualifier;
                String functionName = ASTStringUtil.getQualifiedName(name);
                if (name instanceof ICPPASTQualifiedName && parent instanceof INamespace && (qualifier = (quName = (ICPPASTQualifiedName)name).getQualifier()).length >= 1 && (nameSpec = qualifier[qualifier.length - 1]) instanceof IASTName && parent.getElementName().equals(ASTStringUtil.getSimpleName((IASTName)((Object)nameSpec)))) {
                    functionName = simpleName;
                }
                element = isTemplate ? new FunctionTemplate(parent, functionName) : new Function(parent, functionName);
                element.setParameterTypes(parameterTypes);
                element.setReturnType(returnType);
                this.setIndex(element);
                info = (FunctionInfo)this.getElementInfo(element);
                info.setConst(cppFunctionDeclarator.isConst());
            }
        } else {
            String functionName = ASTStringUtil.getQualifiedName(name);
            element = new Function(parent, functionName);
            element.setParameterTypes(parameterTypes);
            element.setReturnType(returnType);
            this.setIndex(element);
            info = (FunctionInfo)this.getElementInfo(element);
        }
        element.setActive(functionDeclaration.isActive());
        info.setStatic(declSpecifier.getStorageClass() == 3);
        parent.addChild(element);
        this.setIdentifierPosition(info, (IASTNode)name);
        if (!isTemplate) {
            this.setBodyPosition(info, (IASTNode)functionDeclaration);
        }
        return element;
    }

    private FunctionDeclaration createFunctionDeclaration(Parent parent, IASTDeclSpecifier declSpecifier, IASTFunctionDeclarator declarator, boolean isTemplate) throws CModelException {
        FunctionInfo info;
        FunctionDeclaration element;
        IASTDeclarator nestedDeclarator = declarator;
        while (nestedDeclarator.getNestedDeclarator() != null) {
            nestedDeclarator = nestedDeclarator.getNestedDeclarator();
        }
        IASTName name = nestedDeclarator.getName();
        if (name == null) {
            return null;
        }
        String functionName = ASTStringUtil.getSimpleName(name);
        String[] parameterTypes = ASTStringUtil.getParameterSignatureArray(declarator);
        String returnType = ASTStringUtil.getReturnTypeString(declSpecifier, declarator);
        if (declarator instanceof ICPPASTFunctionDeclarator) {
            ICPPASTFunctionDeclarator cppFunctionDeclarator = (ICPPASTFunctionDeclarator)declarator;
            if (parent instanceof IStructure) {
                MethodDeclaration methodElement = isTemplate ? new MethodTemplateDeclaration(parent, functionName) : new MethodDeclaration(parent, functionName);
                element = methodElement;
                methodElement.setParameterTypes(parameterTypes);
                methodElement.setReturnType(returnType);
                methodElement.setConst(cppFunctionDeclarator.isConst());
                this.setIndex(element);
                MethodInfo methodInfo = (MethodInfo)this.getElementInfo(methodElement);
                info = methodInfo;
                if (declSpecifier instanceof ICPPASTDeclSpecifier) {
                    ICPPASTDeclSpecifier cppDeclSpecifier = (ICPPASTDeclSpecifier)declSpecifier;
                    methodInfo.setVirtual(cppDeclSpecifier.isVirtual());
                    methodInfo.setInline(cppDeclSpecifier.isInline());
                    methodInfo.setFriend(cppDeclSpecifier.isFriend());
                }
                methodInfo.setVolatile(cppFunctionDeclarator.isVolatile());
                methodInfo.setVisibility(this.getCurrentVisibility());
                methodInfo.setPureVirtual(cppFunctionDeclarator.isPureVirtual());
                methodElement.setConstructor(functionName.equals(parent.getElementName()));
                methodElement.setDestructor(functionName.charAt(0) == '~');
            } else {
                element = isTemplate ? new FunctionTemplateDeclaration(parent, functionName) : new FunctionDeclaration(parent, functionName);
                element.setParameterTypes(parameterTypes);
                element.setReturnType(returnType);
                this.setIndex(element);
                info = (FunctionInfo)this.getElementInfo(element);
                info.setConst(cppFunctionDeclarator.isConst());
            }
        } else if (declarator instanceof IASTStandardFunctionDeclarator) {
            element = isTemplate ? new FunctionTemplateDeclaration(parent, functionName) : new FunctionDeclaration(parent, functionName);
            element.setParameterTypes(parameterTypes);
            element.setReturnType(returnType);
            this.setIndex(element);
            info = (FunctionInfo)this.getElementInfo(element);
        } else {
            assert (false);
            return null;
        }
        element.setActive(declarator.isActive());
        info.setStatic(declSpecifier.getStorageClass() == 3);
        parent.addChild(element);
        this.setIdentifierPosition(info, (IASTNode)name);
        if (!isTemplate) {
            this.setBodyPosition(info, declarator.getParent());
        }
        return element;
    }

    private Using createUsingDirective(Parent parent, ICPPASTUsingDirective usingDirDeclaration) throws CModelException {
        IASTName name = usingDirDeclaration.getQualifiedName();
        Using element = new Using((ICElement)parent, ASTStringUtil.getQualifiedName(name), true);
        this.setIndex(element);
        element.setActive(usingDirDeclaration.isActive());
        parent.addChild(element);
        this.setIdentifierPosition((SourceManipulation)element, name);
        this.setBodyPosition(element, (IASTNode)usingDirDeclaration);
        return element;
    }

    private Using createUsingDeclaration(Parent parent, ICPPASTUsingDeclaration usingDeclaration) throws CModelException {
        IASTName name = usingDeclaration.getName();
        Using element = new Using((ICElement)parent, ASTStringUtil.getSimpleName(name), false);
        this.setIndex(element);
        element.setActive(usingDeclaration.isActive());
        parent.addChild(element);
        this.setIdentifierPosition((SourceManipulation)element, name);
        this.setBodyPosition(element, (IASTNode)usingDeclaration);
        return element;
    }

    private CElementInfo getElementInfo(CElement cElement) {
        CElementInfo info = this.fNewElements.get(cElement);
        if (info == null) {
            info = cElement.createElementInfo();
            this.fNewElements.put(cElement, info);
        }
        return info;
    }

    private SourceManipulationInfo getSourceManipulationInfo(SourceManipulation cElement) {
        return (SourceManipulationInfo)this.getElementInfo(cElement);
    }

    private void setBodyPosition(SourceManipulation element, IASTNode astNode) throws CModelException {
        this.setBodyPosition(this.getSourceManipulationInfo(element), astNode);
    }

    private void setBodyPosition(SourceManipulationInfo info, IASTNode astNode) {
        IASTFileLocation location = astNode.getFileLocation();
        if (location != null) {
            info.setPos(location.getNodeOffset(), location.getNodeLength());
            info.setLines(location.getStartingLineNumber(), location.getEndingLineNumber());
        } else {
            IASTFileLocation maxLocation;
            IASTNodeLocation[] locations = astNode.getNodeLocations();
            IASTFileLocation minLocation = CModelBuilder2.getMinFileLocation(locations);
            if (minLocation != null && (maxLocation = CModelBuilder2.getMaxFileLocation(locations)) != null) {
                int startOffset = minLocation.getNodeOffset();
                int endOffset = maxLocation.getNodeOffset() + maxLocation.getNodeLength();
                info.setPos(startOffset, endOffset - startOffset);
                int startLine = minLocation.getStartingLineNumber();
                int endLine = maxLocation.getEndingLineNumber();
                info.setLines(startLine, endLine);
            }
        }
    }

    private void setIdentifierPosition(SourceManipulation element, IASTNode astNode) {
        this.setIdentifierPosition(this.getSourceManipulationInfo(element), astNode);
    }

    private void setIdentifierPosition(SourceManipulation element, IASTName astName) {
        this.setIdentifierPosition(this.getSourceManipulationInfo(element), (IASTNode)astName);
    }

    private void setIdentifierPosition(SourceManipulationInfo info, IASTNode astName) {
        IASTFileLocation location = astName.getFileLocation();
        if (location != null) {
            info.setIdPos(location.getNodeOffset(), location.getNodeLength());
        } else {
            IASTFileLocation maxLocation;
            IASTNodeLocation[] locations = astName.getNodeLocations();
            IASTFileLocation minLocation = CModelBuilder2.getMinFileLocation(locations);
            if (minLocation != null && (maxLocation = CModelBuilder2.getMaxFileLocation(locations)) != null) {
                int startOffset = minLocation.getNodeOffset();
                int endOffset = maxLocation.getNodeOffset() + maxLocation.getNodeLength();
                info.setIdPos(startOffset, endOffset - startOffset);
            }
        }
    }

    private static IASTFileLocation getMaxFileLocation(IASTNodeLocation[] locations) {
        if (locations == null || locations.length == 0) {
            return null;
        }
        IASTNodeLocation nodeLocation = locations[locations.length - 1];
        return nodeLocation.asFileLocation();
    }

    private static IASTFileLocation getMinFileLocation(IASTNodeLocation[] locations) {
        if (locations == null || locations.length == 0) {
            return null;
        }
        IASTNodeLocation nodeLocation = locations[0];
        return nodeLocation.asFileLocation();
    }

    private void handleVisibilityLabel(ICPPASTVisibilityLabel visibilityLabel) {
        this.setCurrentVisibility(this.adaptVisibilityConstant(visibilityLabel.getVisibility()));
    }

    private ASTAccessVisibility adaptVisibilityConstant(int visibility) {
        switch (visibility) {
            case 1: {
                return ASTAccessVisibility.PUBLIC;
            }
            case 2: {
                return ASTAccessVisibility.PROTECTED;
            }
            case 3: {
                return ASTAccessVisibility.PRIVATE;
            }
        }
        assert (false) : "Unknown visibility";
        return ASTAccessVisibility.PUBLIC;
    }

    private void setCurrentVisibility(ASTAccessVisibility visibility) {
        this.fCurrentVisibility = visibility;
    }

    private ASTAccessVisibility getCurrentVisibility() {
        if (this.fCurrentVisibility == null) {
            return ASTAccessVisibility.PUBLIC;
        }
        return this.fCurrentVisibility;
    }

    private void popDefaultVisibility() {
        if (!this.fVisibilityStack.isEmpty()) {
            this.setCurrentVisibility(this.fVisibilityStack.pop());
        }
    }

    private void pushDefaultVisibility(ASTAccessVisibility visibility) {
        this.fVisibilityStack.push(this.getCurrentVisibility());
        this.setCurrentVisibility(visibility);
    }

    private static IScope getScope(IASTName astName) {
        IBinding binding = astName.resolveBinding();
        if (binding != null) {
            try {
                return binding.getScope();
            }
            catch (DOMException e) {
                return null;
            }
        }
        return null;
    }
}

