/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl;

import com.google.gson.JsonObject;
import java.util.List;
import org.eclipse.tracecompass.ctf.core.event.CTFClock;
import org.eclipse.tracecompass.ctf.parser.CTFParser;
import org.eclipse.tracecompass.internal.ctf.core.Activator;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ICommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.JsonClockMetadataNode;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ParseException;
import org.eclipse.tracecompass.internal.ctf.core.event.types.ICTFMetadataNode;

public final class ClockParser
implements ICommonTreeParser {
    private static final String NAME = "name";
    private static final String FREQUENCY = "freq";
    private static final String ORIGIN = "origin";
    private static final String SECONDS = "seconds";
    private static final String CYCLES = "cycles";
    private static final String OFFSET = "offset";
    private static final String OFFSET_S = "offset_s";
    private static final String PRECISION = "precision";
    private static final String DESCRIPTION = "description";
    private static final String UNIX_EPOCH = "unix-epoch";
    public static final ClockParser INSTANCE = new ClockParser();

    private ClockParser() {
    }

    @Override
    public CTFClock parse(ICTFMetadataNode clock, ICommonTreeParser.ICommonTreeParserParameter unused) throws ParseException {
        CTFClock ctfClock;
        block7: {
            block6: {
                JsonClockMetadataNode jsonClock;
                block8: {
                    JsonObject offset;
                    ctfClock = new CTFClock();
                    if (!(clock instanceof JsonClockMetadataNode)) break block6;
                    jsonClock = (JsonClockMetadataNode)clock;
                    ctfClock.addAttribute(FREQUENCY, jsonClock.getFrequency());
                    ctfClock.addAttribute(NAME, jsonClock.getName());
                    ctfClock.addAttribute(PRECISION, jsonClock.getPrecision());
                    if (jsonClock.getDescription() != null) {
                        ctfClock.addAttribute(DESCRIPTION, jsonClock.getPrecision());
                    }
                    if ((offset = jsonClock.getOffset()).has(SECONDS) && offset.has(CYCLES)) {
                        Long seconds = offset.get(SECONDS).getAsLong();
                        Long cycles = offset.get(CYCLES).getAsLong();
                        ctfClock.addAttribute(OFFSET, cycles);
                        ctfClock.addAttribute(OFFSET_S, seconds);
                    }
                    if (jsonClock.getOrigin() == null) break block7;
                    if (!jsonClock.getOrigin().isJsonObject()) break block8;
                    ctfClock.addAttribute(ORIGIN, jsonClock.getOrigin().getAsJsonObject().get(NAME).getAsString());
                    break block7;
                }
                if (!jsonClock.getOrigin().getAsString().equals(UNIX_EPOCH)) break block7;
                ctfClock.addAttribute(ORIGIN, UNIX_EPOCH);
                break block7;
            }
            List<ICTFMetadataNode> children = clock.getChildren();
            for (ICTFMetadataNode child : children) {
                String key = child.getChild(0).getChild(0).getChild(0).getText();
                ICTFMetadataNode value = child.getChild(1).getChild(0).getChild(0);
                String type = value.getType();
                String text = value.getText();
                if (CTFParser.tokenNames[101].equals(type) || CTFParser.tokenNames[21].equals(type)) {
                    Long numValue;
                    try {
                        numValue = Long.parseLong(text);
                    }
                    catch (NumberFormatException e) {
                        Activator.log(2, "Number conversion issue with " + text + ". Assigning " + key + " = 0.");
                        numValue = 0L;
                    }
                    ctfClock.addAttribute(key, numValue);
                    continue;
                }
                ctfClock.addAttribute(key, text);
            }
        }
        return ctfClock;
    }
}

