/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.api;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.viatra.query.runtime.api.IQueryGroup;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.impl.BaseQueryGroup;

public class GenericQueryGroup
extends BaseQueryGroup {
    private final Set<IQuerySpecification<?>> patterns;

    public GenericQueryGroup(Set<IQuerySpecification<?>> patterns) {
        this.patterns = patterns;
    }

    @Override
    public Set<IQuerySpecification<?>> getSpecifications() {
        return this.patterns;
    }

    public static IQueryGroup of(Stream<IQuerySpecification<?>> querySpecifications) {
        return new GenericQueryGroup(querySpecifications.collect(Collectors.toSet()));
    }

    public static IQueryGroup of(Set<IQuerySpecification<?>> querySpecifications) {
        return new GenericQueryGroup(querySpecifications);
    }

    public static IQueryGroup of(IQuerySpecification<?> ... querySpecifications) {
        return GenericQueryGroup.of(new HashSet(Arrays.asList(querySpecifications)));
    }

    public static IQueryGroup of(IQueryGroup ... subGroups) {
        HashSet patterns = new HashSet();
        IQueryGroup[] iQueryGroupArray = subGroups;
        int n = subGroups.length;
        int n2 = 0;
        while (n2 < n) {
            IQueryGroup group = iQueryGroupArray[n2];
            patterns.addAll(group.getSpecifications());
            ++n2;
        }
        return new GenericQueryGroup(patterns);
    }
}

