/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.dse.evolutionary.mutationrate;

import java.util.Collection;
import org.eclipse.viatra.dse.evolutionary.interfaces.IMutationRate;
import org.eclipse.viatra.dse.objectives.TrajectoryFitness;

public class AdaptiveMutationRate
implements IMutationRate {
    private double baseMutationChance;
    private double adaptiveMutation;

    public AdaptiveMutationRate() {
        this(0.5, 0.33);
    }

    public AdaptiveMutationRate(double baseMutationChance) {
        this(baseMutationChance, 0.33);
    }

    public AdaptiveMutationRate(double baseMutationChance, double adaptiveMutation) {
        this.baseMutationChance = baseMutationChance;
        this.adaptiveMutation = adaptiveMutation;
    }

    @Override
    public double getMutationChance(Collection<TrajectoryFitness> currentPopulation, Collection<TrajectoryFitness> survivedPopulation, Collection<TrajectoryFitness> parentPopulation) {
        int paretoFrontSize = 0;
        for (TrajectoryFitness trajectoryFitness : parentPopulation) {
            if (trajectoryFitness.rank != 1) continue;
            ++paretoFrontSize;
        }
        return this.baseMutationChance + this.adaptiveMutation * (double)paretoFrontSize / (double)parentPopulation.size();
    }
}

