/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.dse.multithreading;

import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.eclipse.viatra.dse.api.DesignSpaceExplorer;
import org.eclipse.viatra.dse.base.ExplorerThread;

public class DSEThreadPool
extends ThreadPoolExecutor {
    private static final long THREAD_KEEP_ALIVE_IN_SECONDS = 60L;

    public DSEThreadPool() {
        super(0, DSEThreadPool.getProcNumber(), 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    }

    private static int getProcNumber() {
        return Runtime.getRuntime().availableProcessors();
    }

    public boolean tryStartNewStrategy(ExplorerThread strategy) {
        if (!this.canStartNewThread()) {
            return false;
        }
        try {
            this.submit(strategy);
        }
        catch (RejectedExecutionException e) {
            Logger.getLogger(DesignSpaceExplorer.class).info((Object)"Couldn't start new thread.", (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean canStartNewThread() {
        return this.getMaximumPoolSize() > this.getActiveCount();
    }
}

