/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.dse.util;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.viatra.query.runtime.matchers.util.Preconditions;

public final class EMFHelper {
    private static final Logger logger = Logger.getLogger(EMFHelper.class);

    private EMFHelper() {
    }

    public static EditingDomain getEditingDomain(Notifier notifier) {
        Objects.requireNonNull(notifier);
        if (notifier instanceof EObject) {
            EObject eObject = (EObject)notifier;
            return AdapterFactoryEditingDomain.getEditingDomainFor((EObject)eObject);
        }
        if (notifier instanceof Resource) {
            Resource resource = (Resource)notifier;
            EList contents = resource.getContents();
            if (contents.isEmpty()) {
                return null;
            }
            return AdapterFactoryEditingDomain.getEditingDomainFor((EObject)((EObject)contents.get(0)));
        }
        if (notifier instanceof ResourceSet) {
            ResourceSet resourceSet = (ResourceSet)notifier;
            if (resourceSet.getResources().isEmpty()) {
                return null;
            }
            return EMFHelper.getEditingDomain((Notifier)resourceSet.getResources().get(0));
        }
        return null;
    }

    public static EditingDomain createEditingDomain(Notifier notifier) {
        EditingDomain domain = EMFHelper.getEditingDomain(notifier);
        if (domain != null) {
            return domain;
        }
        EMFHelper.registerExtensionForXmiSerializer("dummyext");
        if (notifier instanceof EObject) {
            EObject eObject = (EObject)notifier;
            domain = new AdapterFactoryEditingDomain(null, (CommandStack)new BasicCommandStack());
            Resource resource = domain.getResourceSet().createResource(URI.createFileURI((String)"dummy.dummyext"));
            domain.getCommandStack().execute((Command)new AddCommand(domain, resource.getContents(), (Object)eObject));
            return domain;
        }
        if (notifier instanceof Resource) {
            Resource resource = (Resource)notifier;
            ResourceSet resourceSet = resource.getResourceSet();
            if (resourceSet != null) {
                return new AdapterFactoryEditingDomain(null, (CommandStack)new BasicCommandStack(), resourceSet);
            }
            domain = new AdapterFactoryEditingDomain(null, (CommandStack)new BasicCommandStack(), null);
            resourceSet = domain.getResourceSet();
            domain.getCommandStack().execute((Command)new AddCommand(domain, resourceSet.getResources(), (Object)resource));
            return domain;
        }
        if (notifier instanceof ResourceSet) {
            return new AdapterFactoryEditingDomain(null, (CommandStack)new BasicCommandStack(), (ResourceSet)notifier);
        }
        throw new EmfHelperException("Not supported argument type.");
    }

    public static void saveModel(Notifier model, String fileName) {
        Resource resource;
        Objects.requireNonNull(model);
        Preconditions.checkArgument((fileName != null && !fileName.isEmpty() ? 1 : 0) != 0, (String)"File name is null or empty.");
        int extensionIndex = fileName.lastIndexOf(46);
        Preconditions.checkState((extensionIndex > -1 && extensionIndex != fileName.length() - 1 ? 1 : 0) != 0, (String)"Bad file extension.");
        String ext = fileName.substring(extensionIndex + 1);
        EMFHelper.registerExtensionForXmiSerializer(ext);
        URI uri = URI.createFileURI((String)fileName);
        if (model instanceof ResourceSet) {
            throw new EmfHelperException("Unsupported type: ResourceSet");
        }
        if (model instanceof Resource) {
            resource = (Resource)model;
        } else if (model instanceof EObject) {
            EObject root = (EObject)model;
            ResourceSetImpl resSet = new ResourceSetImpl();
            resource = resSet.createResource(uri);
            resource.getContents().add((Object)root);
        } else {
            throw new EmfHelperException("Unkown type: " + String.valueOf(model.getClass()));
        }
        resource.setURI(uri);
        EMFHelper.saveResource(resource);
    }

    private static void saveResource(Resource resource) {
        try {
            resource.save(Collections.emptyMap());
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
    }

    public static Resource loadModel(String fileName) throws IOException {
        Preconditions.checkArgument((fileName != null && !fileName.isEmpty() ? 1 : 0) != 0, (String)"File name is null or empty.");
        int extensionIndex = fileName.lastIndexOf(46);
        Preconditions.checkState((extensionIndex > -1 && extensionIndex != fileName.length() - 1 ? 1 : 0) != 0, (String)"Bad file extension.");
        String ext = fileName.substring(extensionIndex + 1);
        EMFHelper.registerExtensionForXmiSerializer(ext);
        ResourceSetImpl rSet = new ResourceSetImpl();
        URI fileUri = URI.createFileURI((String)fileName);
        Resource resource = rSet.createResource(fileUri);
        resource.load(null);
        return resource;
    }

    public static EObject getRootEObject(Notifier notifier) {
        if (notifier instanceof EObject) {
            return (EObject)notifier;
        }
        if (notifier instanceof Resource) {
            Resource resource = (Resource)notifier;
            EList contents = resource.getContents();
            if (contents.size() > 1) {
                logger.warn((Object)"Resource has more than one root.");
            }
            if (contents.isEmpty()) {
                return null;
            }
            return (EObject)contents.get(0);
        }
        if (notifier instanceof ResourceSet) {
            ResourceSet resourceSet = (ResourceSet)notifier;
            EList resources = resourceSet.getResources();
            if (resources.size() > 1) {
                logger.warn((Object)"ResourceSet has more than one resources.");
            }
            if (resources.isEmpty()) {
                return null;
            }
            return EMFHelper.getRootEObject((Notifier)resources.get(0));
        }
        throw new EmfHelperException("Unkown type: " + String.valueOf(notifier.getClass()));
    }

    public static void registerExtensionForXmiSerializer(String ext) {
        Resource.Factory.Registry reg = Resource.Factory.Registry.INSTANCE;
        Map m = reg.getExtensionToFactoryMap();
        m.computeIfAbsent(ext, e -> new XMIResourceFactoryImpl());
    }

    public static Notifier clone(Notifier notifier) {
        EcoreUtil.Copier copier = new EcoreUtil.Copier();
        Notifier clonedModel = EMFHelper.clone(notifier, copier, null);
        copier.copyReferences();
        return clonedModel;
    }

    private static Notifier clone(Notifier notifier, EcoreUtil.Copier copier, ResourceSet resourceSetToCloneTo) {
        Objects.requireNonNull(copier);
        if (notifier instanceof EObject) {
            EObject eObject = (EObject)notifier;
            return copier.copy(eObject);
        }
        if (notifier instanceof Resource) {
            Resource resource = (Resource)notifier;
            ResourceSet rSetTemp = resourceSetToCloneTo;
            if (resourceSetToCloneTo == null) {
                rSetTemp = new ResourceSetImpl();
            }
            Resource clonedResource = rSetTemp.createResource(URI.createFileURI((String)"dummy.dummyext"));
            for (EObject eObject : resource.getContents()) {
                EObject clonedEObject = copier.copy(eObject);
                clonedResource.getContents().add((Object)clonedEObject);
            }
            return clonedResource;
        }
        if (notifier instanceof ResourceSet) {
            ResourceSet resourceSet = (ResourceSet)notifier;
            ResourceSetImpl clonedResourceSet = new ResourceSetImpl();
            for (Resource resource : resourceSet.getResources()) {
                EMFHelper.clone((Notifier)resource, copier, (ResourceSet)clonedResourceSet);
            }
            return clonedResourceSet;
        }
        throw new EmfHelperException("Not supported argument type.");
    }

    public static MetaModelElements getAllMetaModelElements(Set<EPackage> metaModelPackages) {
        return EMFHelper.getMetaModelElements(metaModelPackages, true, true, true);
    }

    public static MetaModelElements getClasses(Set<EPackage> metaModelPackages) {
        return EMFHelper.getMetaModelElements(metaModelPackages, true, false, false);
    }

    public static MetaModelElements getReferences(Set<EPackage> metaModelPackages) {
        return EMFHelper.getMetaModelElements(metaModelPackages, false, true, false);
    }

    public static MetaModelElements getAttrbiutes(Set<EPackage> metaModelPackages) {
        return EMFHelper.getMetaModelElements(metaModelPackages, false, false, true);
    }

    private static MetaModelElements getMetaModelElements(Set<EPackage> metaModelPackages, boolean getClasses, boolean getReferences, boolean getAttrbiutes) {
        ENamedElementComparator comparator = new ENamedElementComparator();
        MetaModelElements result = new MetaModelElements();
        result.metaModelPackages = metaModelPackages;
        if (getClasses) {
            result.classes = new TreeSet<ENamedElement>(comparator);
        }
        if (getReferences) {
            result.references = new HashSet<EReference>();
            result.referencesOfClass = new HashMap<EClass, Set<EReference>>();
        }
        if (getAttrbiutes) {
            result.attributes = new HashSet<EAttribute>();
            result.attributesOfClass = new HashMap<EClass, Set<EAttribute>>();
        }
        for (EPackage ePackage : metaModelPackages) {
            for (EClassifier eClassifier : ePackage.getEClassifiers()) {
                if (!(eClassifier instanceof EClass)) continue;
                EClass eClass = (EClass)eClassifier;
                if (getClasses) {
                    result.classes.add(eClass);
                }
                if (getReferences) {
                    result.referencesOfClass.put(eClass, new TreeSet<ENamedElement>(comparator));
                    for (EReference eReference : eClass.getEAllReferences()) {
                        result.references.add(eReference);
                        result.referencesOfClass.get(eClass).add(eReference);
                    }
                }
                if (!getAttrbiutes) continue;
                result.attributesOfClass.put(eClass, new TreeSet<ENamedElement>(comparator));
                for (EAttribute eAttribute : eClass.getEAllAttributes()) {
                    result.attributes.add(eAttribute);
                    result.attributesOfClass.get(eClass).add(eAttribute);
                }
            }
        }
        return result;
    }

    public static class ENamedElementComparator
    implements Comparator<ENamedElement> {
        @Override
        public int compare(ENamedElement eClass1, ENamedElement eClass2) {
            return eClass1.getName().compareTo(eClass2.getName());
        }
    }

    public static class EmfHelperException
    extends RuntimeException {
        private static final long serialVersionUID = 7635796550669616626L;

        public EmfHelperException(String string) {
            super(string);
        }

        public EmfHelperException(String string, Throwable e) {
            super(string, e);
        }
    }

    public static class MetaModelElements {
        public Set<EPackage> metaModelPackages;
        public Set<EClass> classes;
        public Set<EAttribute> attributes;
        public Set<EReference> references;
        public Map<EClass, Set<EAttribute>> attributesOfClass;
        public Map<EClass, Set<EReference>> referencesOfClass;
    }
}

