/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.network.communication.timely;

import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.util.Direction;
import org.eclipse.viatra.query.runtime.matchers.util.Preconditions;
import org.eclipse.viatra.query.runtime.rete.network.Receiver;
import org.eclipse.viatra.query.runtime.rete.network.communication.CommunicationGroup;
import org.eclipse.viatra.query.runtime.rete.network.communication.MessageSelector;
import org.eclipse.viatra.query.runtime.rete.network.communication.Timestamp;
import org.eclipse.viatra.query.runtime.rete.network.communication.timely.TimestampTransformation;
import org.eclipse.viatra.query.runtime.rete.network.mailbox.Mailbox;

public class TimelyMailboxProxy
implements Mailbox {
    protected final TimestampTransformation preprocessor;
    protected final Mailbox wrapped;

    public TimelyMailboxProxy(Mailbox wrapped, TimestampTransformation preprocessor) {
        Preconditions.checkArgument((!(wrapped instanceof TimelyMailboxProxy) ? 1 : 0) != 0, (String)"Proxy in a proxy is not allowed!");
        this.wrapped = wrapped;
        this.preprocessor = preprocessor;
    }

    public Mailbox getWrappedMailbox() {
        return this.wrapped;
    }

    @Override
    public void postMessage(Direction direction, Tuple update, Timestamp timestamp) {
        this.wrapped.postMessage(direction, update, this.preprocessor.process(timestamp));
    }

    public String toString() {
        return this.preprocessor.toString() + "_PROXY -> " + this.wrapped.toString();
    }

    public void clear() {
        this.wrapped.clear();
    }

    @Override
    public void deliverAll(MessageSelector selector) {
        this.wrapped.deliverAll(selector);
    }

    @Override
    public CommunicationGroup getCurrentGroup() {
        return this.wrapped.getCurrentGroup();
    }

    @Override
    public void setCurrentGroup(CommunicationGroup group) {
        this.wrapped.setCurrentGroup(group);
    }

    @Override
    public Receiver getReceiver() {
        return this.wrapped.getReceiver();
    }

    @Override
    public boolean isEmpty() {
        return this.wrapped.isEmpty();
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        TimelyMailboxProxy that = (TimelyMailboxProxy)obj;
        return this.wrapped.equals(that.wrapped) && this.preprocessor == that.preprocessor;
    }

    public int hashCode() {
        int hash = 1;
        hash = hash * 17 + this.wrapped.hashCode();
        hash = hash * 31 + this.preprocessor.hashCode();
        return hash;
    }
}

