/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.ios.templates;

import com.google.common.base.Objects;
import org.eclipse.emf.common.util.EList;
import org.eclipse.vorto.codegen.api.IFileTemplate;
import org.eclipse.vorto.codegen.api.InvocationContext;
import org.eclipse.vorto.core.api.model.functionblock.FunctionBlock;
import org.eclipse.vorto.core.api.model.functionblock.FunctionblockModel;
import org.eclipse.vorto.core.api.model.functionblock.Operation;
import org.eclipse.vorto.core.api.model.functionblock.ReturnType;
import org.eclipse.vorto.core.api.model.informationmodel.FunctionblockProperty;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.eclipse.xtend2.lib.StringConcatenation;

public class CoreBluetoothDetectionTemplate
implements IFileTemplate<InformationModel> {
    public String getFileName(InformationModel context) {
        String _name = context.getName();
        return String.valueOf(_name) + "Delegate.swift";
    }

    public String getPath(InformationModel context) {
        return "";
    }

    public String getContent(InformationModel context, InvocationContext invocationContext) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"//Generated by Vorto");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"import Foundation");
        _builder.newLine();
        _builder.append((Object)"import CoreBluetooth");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"let ");
        String _name = context.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)"UUID = NSUserDefaults.standardUserDefaults().stringForKey(\"");
        String _name_1 = context.getName();
        _builder.append((Object)_name_1, "");
        _builder.append((Object)"_uuid\")");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"class ");
        String _name_2 = context.getName();
        _builder.append((Object)_name_2, "");
        _builder.append((Object)"Delegate: NSObject, CBPeripheralDelegate, CBCentralManagerDelegate {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"var ");
        String _name_3 = context.getName();
        _builder.append((Object)_name_3, "\t");
        _builder.append((Object)"Peripheral : CBPeripheral!");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"var found = false");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"var detectionCompleted:(()->Void)?");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"override init() {}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"func found() -> Bool {");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"return self.found");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"func centralManagerDidUpdateState(central: CBCentralManager!) {");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"if central.state == CBCentralManagerState.PoweredOn {");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"// Scan for peripherals if BLE is turned on");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"central.scanForPeripheralsWithServices(nil, options: nil)");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"println(\"Searching for ");
        String _displayname = context.getDisplayname();
        _builder.append((Object)_displayname, "            ");
        _builder.append((Object)" devices ...\")");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"        ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"else {");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"// Can have different conditions for all states if needed - show generic alert for now");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"println(\"Bluetooth switched off or not initialized\")");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"// Check out the discovered peripherals to find ");
        String _displayname_1 = context.getDisplayname();
        _builder.append((Object)_displayname_1, "     ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)"func centralManager(central: CBCentralManager!, didDiscoverPeripheral peripheral: CBPeripheral!, advertisementData: [NSObject : AnyObject]!, RSSI: NSNumber!) {");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"var deviceUUID  = peripheral.identifier.UUIDString");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"if ");
        String _name_4 = context.getName();
        _builder.append((Object)_name_4, "        ");
        _builder.append((Object)"DeviceReader.found(advertisementData) == true {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"            ");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"println(\"Scanning...Detected \\(deviceUUID)\")");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"if  ");
        String _name_5 = context.getName();
        _builder.append((Object)_name_5, "            ");
        _builder.append((Object)"UUID == deviceUUID {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"                ");
        _builder.append((Object)"self.");
        String _name_6 = context.getName();
        _builder.append((Object)_name_6, "                ");
        _builder.append((Object)"Peripheral = peripheral");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"                ");
        _builder.append((Object)"self.");
        String _name_7 = context.getName();
        _builder.append((Object)_name_7, "                ");
        _builder.append((Object)"Peripheral.delegate = self");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"                ");
        _builder.append((Object)"println(\"");
        String _displayname_2 = context.getDisplayname();
        _builder.append((Object)_displayname_2, "                ");
        _builder.append((Object)" found.\")");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"                ");
        _builder.append((Object)"self.found = true");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"central.connectPeripheral(peripheral, options: nil)");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"if (self.found()) {");
        _builder.newLine();
        _builder.append((Object)"                ");
        _builder.append((Object)"self.detectionCompleted!()");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"// Discover services of the peripheral");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"func centralManager(central: CBCentralManager!, didConnectPeripheral peripheral: CBPeripheral!) {");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"println(\"Discovering peripheral services\")");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"peripheral.discoverServices(nil)");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"// If disconnected, start searching again");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"func centralManager(central: CBCentralManager!, didDisconnectPeripheral peripheral: CBPeripheral!, error: NSError!) {");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"println(\"");
        String _displayname_3 = context.getDisplayname();
        _builder.append((Object)_displayname_3, "        ");
        _builder.append((Object)" disconnected\")");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"        ");
        _builder.append((Object)"self.found = false");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"central.scanForPeripheralsWithServices(nil, options: nil)");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"// Check if the service discovered is valid i.e. one of the following:");
        _builder.newLine();
        EList _properties = context.getProperties();
        for (FunctionblockProperty fbProperty : _properties) {
            _builder.append((Object)"    ");
            _builder.append((Object)"// ");
            FunctionblockModel _type = fbProperty.getType();
            String _displayname_4 = _type.getDisplayname();
            _builder.append((Object)_displayname_4, "    ");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"    ");
        _builder.append((Object)"func peripheral(peripheral: CBPeripheral!, didDiscoverServices error: NSError!) {");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"for service in peripheral.services {");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"let thisService = service as! CBService");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"if ");
        String _name_8 = context.getName();
        _builder.append((Object)_name_8, "            ");
        _builder.append((Object)"Device.validService(thisService) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"                ");
        _builder.append((Object)"// Discover characteristics of all valid services");
        _builder.newLine();
        _builder.append((Object)"                ");
        _builder.append((Object)"peripheral.discoverCharacteristics(nil, forService: thisService)");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"// Get data values when they are updated");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"func peripheral(peripheral: CBPeripheral!, didUpdateValueForCharacteristic characteristic: CBCharacteristic!, error: NSError!) {");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.newLine();
        EList _properties_1 = context.getProperties();
        for (FunctionblockProperty fbProperty_1 : _properties_1) {
            _builder.append((Object)"        ");
            _builder.append((Object)"if characteristics.UUID == ");
            FunctionblockModel _type_1 = fbProperty_1.getType();
            String _name_9 = _type_1.getName();
            _builder.append((Object)_name_9, "        ");
            _builder.append((Object)"DataUUID {");
            _builder.newLineIfNotEmpty();
            FunctionblockModel _type_2 = fbProperty_1.getType();
            FunctionBlock _functionblock = _type_2.getFunctionblock();
            EList _operations = _functionblock.getOperations();
            for (Operation operation : _operations) {
                boolean _notEquals;
                ReturnType _returnType = operation.getReturnType();
                boolean bl = _notEquals = !Objects.equal((Object)_returnType, null);
                if (!_notEquals) continue;
                _builder.append((Object)"        ");
                _builder.append((Object)"\t");
                _builder.append((Object)"let ");
                FunctionblockModel _type_3 = fbProperty_1.getType();
                String _name_10 = _type_3.getName();
                _builder.append((Object)_name_10, "        \t");
                _builder.append((Object)"_value = ");
                String _name_11 = context.getName();
                _builder.append((Object)_name_11, "        \t");
                _builder.append((Object)"Device.");
                String _name_12 = operation.getName();
                _builder.append((Object)_name_12, "        \t");
                _builder.append((Object)"(characteristics.value)");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"        ");
                _builder.append((Object)"\t");
                _builder.append((Object)"// do something with the value");
                _builder.newLine();
            }
            _builder.append((Object)"        ");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder.toString();
    }
}

