/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.ui.tasks;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.URIUtil;

public class LocationWrapper {
    private static final String ERROR_MESSAGE = "Invalid workspace location provided";
    private String path;
    private String projectName;
    private URI uri;

    public LocationWrapper(String path, String projectName) {
        this.path = path;
        this.projectName = projectName;
        try {
            this.uri = URIUtil.fromString((String)(String.valueOf(path) + "/" + projectName));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(ERROR_MESSAGE, e);
        }
    }

    public Path getValidPath() {
        return new Path(this.uri.toString());
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }
}

