/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.webui.templates.service.bosch;

import org.eclipse.vorto.codegen.api.IFileTemplate;
import org.eclipse.vorto.codegen.api.InvocationContext;
import org.eclipse.vorto.codegen.webui.templates.TemplateUtils;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.eclipse.xtend2.lib.StringConcatenation;

public class ThingBuilderTemplate
implements IFileTemplate<InformationModel> {
    public String getFileName(InformationModel context) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"ThingBuilder.java");
        return _builder.toString();
    }

    public String getPath(InformationModel context) {
        StringConcatenation _builder = new StringConcatenation();
        String _baseApplicationPath = TemplateUtils.getBaseApplicationPath(context);
        _builder.append((Object)_baseApplicationPath, "");
        _builder.append((Object)"/service/bosch");
        return _builder.toString();
    }

    public String getContent(InformationModel element, InvocationContext context) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"package com.example.iot.");
        String _name = element.getName();
        String _lowerCase = _name.toLowerCase();
        _builder.append((Object)_lowerCase, "");
        _builder.append((Object)".service.bosch;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"import java.util.Date;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"import com.example.iot.");
        String _name_1 = element.getName();
        String _lowerCase_1 = _name_1.toLowerCase();
        _builder.append((Object)_lowerCase_1, "");
        _builder.append((Object)".service.bosch.internal.model.FeatureImpl;");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"import com.example.iot.");
        String _name_2 = element.getName();
        String _lowerCase_2 = _name_2.toLowerCase();
        _builder.append((Object)_lowerCase_2, "");
        _builder.append((Object)".service.bosch.internal.model.ThingImpl;");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"import com.example.iot.");
        String _name_3 = element.getName();
        String _lowerCase_3 = _name_3.toLowerCase();
        _builder.append((Object)_lowerCase_3, "");
        _builder.append((Object)".service.bosch.model.AclEntry;");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"import com.example.iot.");
        String _name_4 = element.getName();
        String _lowerCase_4 = _name_4.toLowerCase();
        _builder.append((Object)_lowerCase_4, "");
        _builder.append((Object)".service.bosch.model.Feature;");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"import com.example.iot.");
        String _name_5 = element.getName();
        String _lowerCase_5 = _name_5.toLowerCase();
        _builder.append((Object)_lowerCase_5, "");
        _builder.append((Object)".service.bosch.model.Thing;");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"import com.google.gson.Gson;");
        _builder.newLine();
        _builder.append((Object)"import com.google.gson.GsonBuilder;");
        _builder.newLine();
        _builder.append((Object)"import com.google.gson.reflect.TypeToken;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"public class ThingBuilder {");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private ThingImpl thing;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ThingBuilder() {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"this.thing = new ThingImpl();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"this.thing.getAttributes().put(ThingImpl.ATTRIBUTE_CREATEDON, Thing.JSON_DATE_FORMAT.format(new Date()));");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ThingBuilder fromThing(com.bosch.cr.model.things.Thing thing) {\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"String json = thing.toJson().toString();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"Gson gson = new GsonBuilder().create();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"this.thing = gson.fromJson(json, new TypeToken<ThingImpl>(){}.getType());");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return this;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ThingBuilder withThingId(String thingId) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"this.thing.setThingId(thingId);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return this;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ThingBuilder withThingId(String namespace, String deviceId) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"StringBuilder builder = new StringBuilder();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"builder.append(namespace);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"builder.append(\":\");");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"builder.append(deviceId);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return withThingId(builder.toString());");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ThingBuilder withCreationBy(String userId) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"this.thing.getAttributes().put(ThingImpl.ATTRIBUTE_CREATEDBY, userId);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return this;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ThingBuilder withThingName(String thingName) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"this.thing.getAttributes().put(ThingImpl.ATTRIBUTE_NAME, thingName);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return this;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ThingBuilder withDeviceId(String deviceId) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"this.thing.getAttributes().put(ThingImpl.ATTRIBUTE_DEVICEID, deviceId);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return this;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ThingBuilder withFeature(Feature feature) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"this.thing.getFeatures().put(feature.getId(), ((FeatureImpl)feature).getContent());");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return this;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ThingBuilder withPermission(String authorizationSubject, AclEntry acl) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"this.thing.getAcl().put(authorizationSubject, acl);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return this;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public Thing build() {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return this.thing;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        return _builder.toString();
    }
}

