/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.views;

import org.eclipse.dali.core.Generator;
import org.eclipse.dali.core.GeneratorType;
import org.eclipse.dali.core.Id;
import org.eclipse.dali.core.PersistentAttribute;
import org.eclipse.dali.edit.DaliItemProviderAdapterFactory;
import org.eclipse.dali.edit.IdItemProvider;
import org.eclipse.dali.ui.views.ColumnComposite;
import org.eclipse.dali.ui.views.GeneratedValueComposite;
import org.eclipse.dali.ui.views.IMappingCompositeBuilder;
import org.eclipse.dali.ui.views.IPersistenceComposite;
import org.eclipse.dali.ui.views.SequenceGeneratorComposite;
import org.eclipse.dali.ui.views.TableGeneratorComposite;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.PageBook;

public class IdMappingComposite
extends Composite
implements IPersistenceComposite {
    private boolean populating;
    private GeneratedValueComposite generatedValueComposite;
    private PageBook generatorComposite;
    private ColumnComposite columnComposite;
    private TableGeneratorComposite tableGeneratorComposite;
    private SequenceGeneratorComposite sequenceGeneratorComposite;
    private Composite emptyComposite;
    private Id id;
    private INotifyChangedListener idListener;
    EditingDomain editingDomain;
    private DaliItemProviderAdapterFactory adapterFactory;
    private IdItemProvider idItemProvider;
    static /* synthetic */ Class class$0;

    protected IdMappingComposite(Composite parent, EditingDomain editingDomain, DaliItemProviderAdapterFactory adapterFactory) {
        super(parent, 0);
        this.editingDomain = editingDomain;
        this.adapterFactory = adapterFactory;
        this.initialize();
        this.initializeLayout();
    }

    private void initialize() {
        this.idItemProvider = (IdItemProvider)this.adapterFactory.createIdAdapter();
    }

    private void initializeLayout() {
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.generatedValueComposite = new GeneratedValueComposite(this, this.editingDomain, this.adapterFactory);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.generatedValueComposite.setLayoutData(gridData);
        this.columnComposite = new ColumnComposite(this, this.editingDomain, this.adapterFactory);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.columnComposite.setLayoutData(gridData);
        this.generatorComposite = new PageBook((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.generatorComposite.setLayoutData((Object)gridData);
        this.tableGeneratorComposite = new TableGeneratorComposite((Composite)this.generatorComposite, this.editingDomain, this.adapterFactory);
        this.sequenceGeneratorComposite = new SequenceGeneratorComposite((Composite)this.generatorComposite, this.editingDomain, this.adapterFactory);
        this.emptyComposite = new Composite((Composite)this.generatorComposite, 0);
        this.generatorComposite.showPage((Control)this.emptyComposite);
    }

    protected void updateGeneratorComposite(GeneratorType newGeneratorType) {
        if (newGeneratorType.getValue() == 4) {
            this.tableGeneratorComposite.populate((EObject)this.id.getGenerator());
            this.generatorComposite.showPage((Control)this.tableGeneratorComposite);
        } else if (newGeneratorType.getValue() == 2) {
            this.sequenceGeneratorComposite.populate((EObject)this.id.getGenerator());
            this.generatorComposite.showPage((Control)this.sequenceGeneratorComposite);
        }
    }

    protected void removeGeneratorComposite() {
        this.tableGeneratorComposite.populate(null);
        this.sequenceGeneratorComposite.populate(null);
        this.id.setGenerator(null);
    }

    public void populate(EObject model) {
        this.populating = true;
        if (this.id != null) {
            this.idItemProvider.removeListener(this.getIdListener());
            this.id.eAdapters().remove((Object)this.idItemProvider);
        }
        if (model == null) {
            this.id = null;
            this.generatedValueComposite.populate(null);
            this.tableGeneratorComposite.populate(null);
            this.columnComposite.populate(null);
            this.populating = false;
            return;
        }
        this.id = (Id)((PersistentAttribute)model).getFlavor();
        this.idItemProvider.addListener(this.getIdListener());
        this.id.eAdapters().add((Object)this.idItemProvider);
        this.generatedValueComposite.populate((EObject)this.id.getGeneratedValue());
        this.updateGeneratorComposite(this.id.getGeneratedValue().getStrategy());
        this.columnComposite.populate((EObject)this.id.getColumn());
        this.populating = false;
    }

    private INotifyChangedListener getIdListener() {
        if (this.idListener == null) {
            this.idListener = new INotifyChangedListener(){

                public void notifyChanged(Notification notification) {
                    IdMappingComposite.this.idChanged(notification);
                }
            };
        }
        return this.idListener;
    }

    protected void idChanged(Notification notification) {
        if (notification.getFeatureID(Id.class) == 1) {
            Generator cfr_ignored_0 = (Generator)notification.getNewValue();
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    IdMappingComposite.this.updateGeneratorComposite(IdMappingComposite.this.id.getGeneratedValue().getStrategy());
                }
            });
        }
    }

    public void dispose() {
        super.dispose();
    }

    public static class IdMappingCompositeBuilder
    implements IMappingCompositeBuilder {
        public IPersistenceComposite buildMappingComposite(Composite parent, EditingDomain editingDomain, DaliItemProviderAdapterFactory adapterFactory) {
            return new IdMappingComposite(parent, editingDomain, adapterFactory);
        }
    }
}

