/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.core;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.dali.core.IPersistenceModelStatus;
import org.eclipse.dali.core.impl.PersistenceModelStatus;

public class PersistenceModelException
extends CoreException {
    private static final long serialVersionUID = 1L;
    CoreException nestedCoreException;

    public PersistenceModelException(Throwable e, int code) {
        this(new PersistenceModelStatus(code, e));
    }

    public PersistenceModelException(CoreException exception) {
        super(exception.getStatus());
        this.nestedCoreException = exception;
    }

    public PersistenceModelException(IPersistenceModelStatus status) {
        super((IStatus)status);
    }

    public Throwable getException() {
        if (this.nestedCoreException == null) {
            return this.getStatus().getException();
        }
        return this.nestedCoreException;
    }

    public IPersistenceModelStatus getPersistenceModelStatus() {
        IStatus status = this.getStatus();
        if (status instanceof IPersistenceModelStatus) {
            return (IPersistenceModelStatus)status;
        }
        return new PersistenceModelStatus(this.nestedCoreException);
    }

    public boolean isDoesNotExist() {
        IPersistenceModelStatus status = this.getPersistenceModelStatus();
        return status != null && status.isDoesNotExist();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintStream output) {
        PrintStream printStream = output;
        synchronized (printStream) {
            super.printStackTrace(output);
            Throwable throwable = this.getException();
            if (throwable != null) {
                output.print("Caused by: ");
                throwable.printStackTrace(output);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintWriter output) {
        PrintWriter printWriter = output;
        synchronized (printWriter) {
            super.printStackTrace(output);
            Throwable throwable = this.getException();
            if (throwable != null) {
                output.print("Caused by: ");
                throwable.printStackTrace(output);
            }
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Persistence Model Exception: ");
        if (this.getException() != null) {
            buffer.append(this.getException().toString());
        } else {
            buffer.append(this.getStatus().toString());
        }
        return buffer.toString();
    }
}

