/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.core.adapters.java;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.dali.core.ITextRange;
import org.eclipse.dali.core.util.jdt.ASTTools;
import org.eclipse.dali.core.util.jdt.AnnotationEditFormatter;
import org.eclipse.dali.core.util.jdt.JDTTools;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;

public abstract class Member {
    private final IMember jdtMember;

    Member(IMember jdtMember) {
        this.jdtMember = jdtMember;
    }

    public IMember getJDTMember() {
        return this.jdtMember;
    }

    public String getName() {
        return this.getJDTMember().getElementName();
    }

    public CompilationUnit createASTRoot() {
        return JDTTools.createASTRoot(this.getJDTMember());
    }

    BodyDeclaration bodyDeclaration() {
        return this.bodyDeclaration(this.createASTRoot());
    }

    abstract BodyDeclaration bodyDeclaration(CompilationUnit var1);

    public boolean containsAnyAnnotation(String[] annotationNames) {
        return this.containsAnyAnnotation(annotationNames, this.createASTRoot());
    }

    public boolean containsAnyAnnotation(String[] annotationNames, CompilationUnit astRoot) {
        return this.containsAnyAnnotation(annotationNames, this.bodyDeclaration(astRoot));
    }

    public boolean containsAnyAnnotation(String[] annotationNames, BodyDeclaration bodyDeclaration) {
        return ASTTools.containsAnyAnnotation(bodyDeclaration, annotationNames);
    }

    public boolean containsAnnotation(String annotationName) {
        return this.getAnnotation(annotationName) != null;
    }

    public boolean containsAnnotation(String annotationName, CompilationUnit astRoot) {
        return this.getAnnotation(annotationName, astRoot) != null;
    }

    public boolean containsAnnotation(String annotationName, BodyDeclaration bodyDeclaration) {
        return this.getAnnotation(annotationName, bodyDeclaration) != null;
    }

    public Annotation getAnnotation(String annotationName) {
        return this.getAnnotation(annotationName, this.createASTRoot());
    }

    public Annotation getAnnotation(String annotationName, CompilationUnit astRoot) {
        return this.getAnnotation(annotationName, this.bodyDeclaration(astRoot));
    }

    public Annotation getAnnotation(String annotationName, BodyDeclaration bodyDeclaration) {
        return ASTTools.getAnnotation(bodyDeclaration, annotationName);
    }

    public Annotation addAnnotation(String annotationName) {
        return this.addAnnotation(annotationName, this.createASTRoot());
    }

    public Annotation addAnnotation(String annotationName, CompilationUnit astRoot) {
        return this.addAnnotation(annotationName, this.bodyDeclaration(astRoot));
    }

    public Annotation addAnnotation(final String annotationName, BodyDeclaration declaration) {
        if (this.containsAnnotation(annotationName, declaration)) {
            throw new IllegalStateException("annotation already exists: " + annotationName);
        }
        JDTTools.addImport(this.getJDTMember().getCompilationUnit(), "javax.persistence." + annotationName);
        this.editAnnotation(new IAnnotationEditor(){

            public void edit(BodyDeclaration bodyDeclaration) {
                ASTTools.addAnnotation(bodyDeclaration, annotationName);
            }
        });
        return this.getAnnotation(annotationName, declaration);
    }

    public void removeAnnotation(String annotationName) {
        this.removeAnnotation(annotationName, this.createASTRoot());
    }

    public void removeAnnotation(String annotationName, CompilationUnit astRoot) {
        this.removeAnnotation(annotationName, this.bodyDeclaration(astRoot));
    }

    public void removeAnnotation(final String annotationName, BodyDeclaration declaration) {
        if (!this.containsAnnotation(annotationName, declaration)) {
            throw new IllegalStateException("annotation does not exist: " + annotationName);
        }
        this.editAnnotation(new IAnnotationEditor(){

            public void edit(BodyDeclaration bodyDeclaration) {
                ASTTools.removeAnnotation(bodyDeclaration, annotationName);
            }
        });
    }

    public boolean containsAnnotationElement(String annotationName, String elementName) {
        return this.getMemberValuePair(annotationName, elementName) != null;
    }

    public boolean containsAnnotationElement(String annotationName, String elementName, CompilationUnit astRoot) {
        return this.getMemberValuePair(annotationName, elementName, astRoot) != null;
    }

    public boolean containsAnnotationElement(String annotationName, String elementName, BodyDeclaration bodyDeclaration) {
        return this.getMemberValuePair(annotationName, elementName, bodyDeclaration) != null;
    }

    public Expression getAnnotationElement(String annotationName, String elementName) {
        return this.getMemberValuePair(annotationName, elementName).getValue();
    }

    public Expression getAnnotationElement(String annotationName, String elementName, CompilationUnit astRoot) {
        return this.getMemberValuePair(annotationName, elementName, astRoot).getValue();
    }

    public Expression getAnnotationElement(String annotationName, String elementName, BodyDeclaration bodyDeclaration) {
        return this.getMemberValuePair(annotationName, elementName, bodyDeclaration).getValue();
    }

    public String getAnnotationElementStringValue(String annotationName, String elementName) {
        return this.getAnnotationElementStringValue(annotationName, elementName, this.createASTRoot());
    }

    public String getAnnotationElementStringValue(String annotationName, String elementName, CompilationUnit astRoot) {
        return this.getAnnotationElementStringValue(annotationName, elementName, this.bodyDeclaration(astRoot));
    }

    public String getAnnotationElementStringValue(String annotationName, String elementName, BodyDeclaration bodyDeclaration) {
        return ASTTools.getAnnotationElementStringValue(bodyDeclaration, annotationName, elementName);
    }

    public MemberValuePair getMemberValuePair(String annotationName, String elementName) {
        return this.getMemberValuePair(annotationName, elementName, this.createASTRoot());
    }

    public MemberValuePair getMemberValuePair(String annotationName, String elementName, CompilationUnit astRoot) {
        return this.getMemberValuePair(annotationName, elementName, this.bodyDeclaration(astRoot));
    }

    public MemberValuePair getMemberValuePair(String annotationName, String elementName, BodyDeclaration bodyDeclaration) {
        return ASTTools.getMemberValuePair(bodyDeclaration, annotationName, elementName);
    }

    public void removeAnnotationElement(final String annotationName, final String elementName) {
        if (!this.containsAnnotationElement(annotationName, elementName)) {
            throw new IllegalStateException("annotation element does not exist: " + annotationName + "(" + elementName + ")");
        }
        this.editAnnotation(new IAnnotationEditor(){

            public void edit(BodyDeclaration bodyDeclaration) {
                ASTTools.removeAnnotationElement(bodyDeclaration, annotationName, elementName);
            }
        });
    }

    public void editAnnotation(IAnnotationEditor annotationEditor) {
        Document doc;
        ICompilationUnit compilationUnit = this.getJDTMember().getCompilationUnit();
        boolean hasTextEditor = true;
        ITextFileBuffer buffer = FileBuffers.getTextFileBufferManager().getTextFileBuffer(compilationUnit.getResource().getFullPath());
        if (!compilationUnit.isWorkingCopy()) {
            try {
                compilationUnit.becomeWorkingCopy(null, null);
            }
            catch (JavaModelException ex) {
                throw new RuntimeException(ex);
            }
        }
        if (buffer == null) {
            String source;
            hasTextEditor = false;
            try {
                source = compilationUnit.getBuffer().getContents();
            }
            catch (JavaModelException e) {
                throw new RuntimeException(e);
            }
            doc = new Document(source);
        } else {
            doc = (Document)buffer.getDocument();
        }
        CompilationUnit astRoot = this.createASTRoot();
        astRoot.recordModifications();
        annotationEditor.edit(this.bodyDeclaration(astRoot));
        TextEdit edits = astRoot.rewrite((IDocument)doc, compilationUnit.getJavaProject().getOptions(true));
        try {
            AnnotationEditFormatter formatter = new AnnotationEditFormatter((IDocument)doc);
            formatter.apply(edits);
        }
        catch (MalformedTreeException ex) {
            throw new RuntimeException(ex);
        }
        catch (BadLocationException ex) {
            throw new RuntimeException(ex);
        }
        if (!hasTextEditor) {
            String newSource = doc.get();
            try {
                compilationUnit.getBuffer().setContents(newSource);
                compilationUnit.commitWorkingCopy(true, null);
                compilationUnit.discardWorkingCopy();
            }
            catch (JavaModelException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public ITextRange getTextRange(String annotationName) {
        Annotation annotation = this.getAnnotation(annotationName);
        if (annotation == null) {
            return null;
        }
        return ASTTools.getTextRange((ASTNode)annotation);
    }

    public static interface IAnnotationEditor {
        public void edit(BodyDeclaration var1);
    }
}

