/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.views;

import java.util.Iterator;
import java.util.List;
import org.eclipse.dali.core.DaliPackage;
import org.eclipse.dali.core.JoinColumn;
import org.eclipse.dali.db.Table;
import org.eclipse.dali.edit.DaliItemProviderAdapterFactory;
import org.eclipse.dali.edit.JoinColumnItemProvider;
import org.eclipse.dali.internal.utility.CollectionTools;
import org.eclipse.dali.ui.views.IPersistenceComposite;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class JoinColumnComposite
extends Composite
implements IPersistenceComposite {
    private JoinColumn joinColumn;
    private JoinColumnItemProvider joinColumnItemProvider;
    private INotifyChangedListener joinColumnListener;
    protected EditingDomain editingDomain;
    protected Combo joinColumnCombo;
    protected Combo referencedColumnCombo;
    protected boolean populating;
    static /* synthetic */ Class class$0;

    public JoinColumnComposite(Composite parent, EditingDomain editingDomain, DaliItemProviderAdapterFactory adapterFactory) {
        super(parent, 0);
        this.editingDomain = editingDomain;
        this.joinColumnItemProvider = (JoinColumnItemProvider)adapterFactory.createJoinColumnAdapter();
        this.initializeLayout();
    }

    private void initializeLayout() {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        Group joinColumnGroup = new Group((Composite)this, 16);
        joinColumnGroup.setText("Join Column");
        joinColumnGroup.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        joinColumnGroup.setLayoutData((Object)gridData);
        Label joinColumnLabel = new Label((Composite)joinColumnGroup, 16384);
        joinColumnLabel.setText("Name:");
        this.joinColumnCombo = this.buildJoinColumnCombo((Composite)joinColumnGroup);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.joinColumnCombo.setLayoutData((Object)gridData);
        Label referencedColumnNameLabel = new Label((Composite)joinColumnGroup, 16384);
        referencedColumnNameLabel.setText("Referenced Column:");
        this.referencedColumnCombo = this.buildReferencedColumnCombo((Composite)joinColumnGroup);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.referencedColumnCombo.setLayoutData((Object)gridData);
    }

    private Combo buildJoinColumnCombo(Composite parent) {
        final Combo combo = new Combo(parent, 2052);
        combo.add("Default()");
        combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (JoinColumnComposite.this.populating) {
                    return;
                }
                String joinColumnText = ((Combo)e.getSource()).getText();
                if (joinColumnText.equals("")) {
                    joinColumnText = null;
                    if (JoinColumnComposite.this.joinColumn.getSpecifiedName() == null || JoinColumnComposite.this.joinColumn.getSpecifiedName().equals("")) {
                        return;
                    }
                }
                if (joinColumnText != null && combo.getItemCount() > 0 && joinColumnText.equals(combo.getItem(0))) {
                    joinColumnText = null;
                }
                if (JoinColumnComposite.this.joinColumn.getSpecifiedName() == null || !JoinColumnComposite.this.joinColumn.getSpecifiedName().equals(joinColumnText)) {
                    JoinColumnComposite.this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)JoinColumnComposite.this.editingDomain, (Object)JoinColumnComposite.this.joinColumn, (Object)DaliPackage.eINSTANCE.getJoinColumn_SpecifiedName(), (Object)joinColumnText));
                }
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)combo, "org.eclipse.dali.ui.mapping_joinColumnName");
        return combo;
    }

    private Combo buildReferencedColumnCombo(Composite parent) {
        final Combo combo = new Combo(parent, 2052);
        combo.add("Default()");
        combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (JoinColumnComposite.this.populating) {
                    return;
                }
                String referencedColumnText = ((Combo)e.getSource()).getText();
                if (referencedColumnText.equals("")) {
                    referencedColumnText = null;
                    if (JoinColumnComposite.this.joinColumn.getSpecifiedReferencedColumnName() == null || JoinColumnComposite.this.joinColumn.getSpecifiedReferencedColumnName().equals("")) {
                        return;
                    }
                }
                if (referencedColumnText != null && combo.getItemCount() > 0 && referencedColumnText.equals(combo.getItem(0))) {
                    referencedColumnText = null;
                }
                if (JoinColumnComposite.this.joinColumn.getSpecifiedReferencedColumnName() == null || !JoinColumnComposite.this.joinColumn.getSpecifiedReferencedColumnName().equals(referencedColumnText)) {
                    JoinColumnComposite.this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)JoinColumnComposite.this.editingDomain, (Object)JoinColumnComposite.this.joinColumn, (Object)DaliPackage.eINSTANCE.getJoinColumn_SpecifiedReferencedColumnName(), (Object)referencedColumnText));
                }
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)combo, "org.eclipse.dali.ui.mapping_joinReferencedColumn");
        return combo;
    }

    private INotifyChangedListener getJoinColumnListener() {
        if (this.joinColumnListener == null) {
            this.joinColumnListener = new INotifyChangedListener(){

                public void notifyChanged(Notification notification) {
                    JoinColumnComposite.this.joinColumnChanged(notification);
                }
            };
        }
        return this.joinColumnListener;
    }

    protected void joinColumnChanged(Notification notification) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.core.JoinColumn");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (notification.getFeatureID((Class)clazz) == 4) {
            final String joinColumnName = (String)notification.getNewValue();
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    if (JoinColumnComposite.this.joinColumnCombo.getText() == null || !JoinColumnComposite.this.joinColumnCombo.getText().equals(joinColumnName)) {
                        if (joinColumnName == null) {
                            JoinColumnComposite.this.joinColumnCombo.setText("");
                        } else {
                            JoinColumnComposite.this.joinColumnCombo.setText(joinColumnName);
                        }
                    }
                }
            });
        } else {
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.dali.core.JoinColumn");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (notification.getFeatureID((Class)clazz2) == 7) {
                final String referencedColumn = (String)notification.getNewValue();
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        if (JoinColumnComposite.this.referencedColumnCombo.getText() == null || !JoinColumnComposite.this.referencedColumnCombo.getText().equals(referencedColumn)) {
                            if (referencedColumn == null) {
                                JoinColumnComposite.this.referencedColumnCombo.setText("");
                            } else {
                                JoinColumnComposite.this.referencedColumnCombo.setText(referencedColumn);
                            }
                        }
                    }
                });
            }
        }
    }

    public void populate(EObject model) {
        this.populating = true;
        if (this.joinColumn != null) {
            this.joinColumnItemProvider.removeListener(this.getJoinColumnListener());
            this.joinColumn.eAdapters().remove((Object)this.joinColumnItemProvider);
        }
        this.joinColumn = (JoinColumn)model;
        if (this.joinColumn == null) {
            return;
        }
        this.joinColumnItemProvider.addListener(this.getJoinColumnListener());
        this.joinColumn.eAdapters().add((Object)this.joinColumnItemProvider);
        this.populateJoinColumnCombo();
        this.populateReferencedColumnCombo();
        this.populating = false;
    }

    private void populateJoinColumnCombo() {
        String joinColumnName = this.joinColumn.getSpecifiedName();
        String defaultJoinColumnName = this.joinColumn.getDefaultName();
        this.joinColumnCombo.setItem(0, "Default (" + defaultJoinColumnName + ")");
        if (this.joinColumn.getPersistenceProject().getConnectionInfo().isConnected()) {
            this.joinColumnCombo.remove(1, this.joinColumnCombo.getItemCount() - 1);
            Table table = this.joinColumn.getTable();
            if (table != null) {
                Iterator i = CollectionTools.sort((List)CollectionTools.list((Iterator)table.columnNames())).iterator();
                while (i.hasNext()) {
                    this.joinColumnCombo.add((String)i.next());
                }
            }
        }
        if (joinColumnName != null) {
            if (!this.joinColumnCombo.getText().equals(joinColumnName)) {
                this.joinColumnCombo.setText(joinColumnName);
            }
        } else if (!this.joinColumnCombo.getText().equals("Default (" + defaultJoinColumnName + ")")) {
            this.joinColumnCombo.select(0);
        }
    }

    private void populateReferencedColumnCombo() {
        String referencedColumnName = this.joinColumn.getSpecifiedReferencedColumnName();
        String defaultReferencedColumnName = this.joinColumn.getDefaultReferencedColumnName();
        this.referencedColumnCombo.setItem(0, "Default (" + defaultReferencedColumnName + ")");
        if (this.joinColumn.getPersistenceProject().getConnectionInfo().isConnected()) {
            this.referencedColumnCombo.remove(1, this.referencedColumnCombo.getItemCount() - 1);
            Table table = this.joinColumn.getReferencedTable();
            if (table != null) {
                Iterator i = CollectionTools.sort((List)CollectionTools.list((Iterator)table.columnNames())).iterator();
                while (i.hasNext()) {
                    this.referencedColumnCombo.add((String)i.next());
                }
            }
        }
        if (referencedColumnName != null) {
            if (!this.referencedColumnCombo.getText().equals(referencedColumnName)) {
                this.referencedColumnCombo.setText(referencedColumnName);
            }
        } else if (!this.referencedColumnCombo.getText().equals("Default (" + defaultReferencedColumnName + ")")) {
            this.referencedColumnCombo.select(0);
        }
    }
}

