/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.views;

import java.util.Iterator;
import org.eclipse.dali.orm.JoinColumn;
import org.eclipse.dali.orm.OrmFactory;
import org.eclipse.dali.orm.OrmPackage;
import org.eclipse.dali.orm.SingleRelationshipMapping;
import org.eclipse.dali.orm.adapters.IJoinColumnModelAdapter;
import org.eclipse.dali.orm.adapters.ISingleRelationshipMappingModelAdapter;
import org.eclipse.dali.orm.provider.JoinColumnItemProvider;
import org.eclipse.dali.orm.provider.OrmItemProviderAdapterFactory;
import org.eclipse.dali.orm.provider.SingleRelationshipMappingItemProvider;
import org.eclipse.dali.ui.DaliUiMessages;
import org.eclipse.dali.ui.views.IPersistenceComposite;
import org.eclipse.dali.ui.views.JoinColumnDialog;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class JoinColumnComposite
extends Composite
implements IPersistenceComposite {
    private SingleRelationshipMapping singleRelationshipMapping;
    private JoinColumnItemProvider joinColumnItemProvider;
    private SingleRelationshipMappingItemProvider singleRelationshipMappingItemProvider;
    private INotifyChangedListener joinColumnListener;
    protected EditingDomain editingDomain;
    private Group joinColumnsGroup;
    private Button overrideDefaultJoinColumnsCheckBox;
    private ListViewer joinColumnsListViewer;
    private Button joinColumnsRemoveButton;
    private Button joinColumnsEditButton;
    private INotifyChangedListener singleRelationshipMappingListener;
    protected boolean populating;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public JoinColumnComposite(Composite parent, EditingDomain editingDomain, OrmItemProviderAdapterFactory adapterFactory, SingleRelationshipMappingItemProvider itemProvider) {
        super(parent, 0);
        this.editingDomain = editingDomain;
        this.joinColumnItemProvider = (JoinColumnItemProvider)adapterFactory.createJoinColumnAdapter();
        this.singleRelationshipMappingItemProvider = itemProvider;
        this.initializeLayout();
    }

    private void initializeLayout() {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.overrideDefaultJoinColumnsCheckBox = new Button((Composite)this, 32);
        this.overrideDefaultJoinColumnsCheckBox.setText(DaliUiMessages.JoinColumnComposite_overrideDefaultJoinColumns);
        this.overrideDefaultJoinColumnsCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                JoinColumnComposite.this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)JoinColumnComposite.this.editingDomain, (Object)JoinColumnComposite.this.singleRelationshipMapping, (Object)OrmPackage.eINSTANCE.getSingleRelationshipMapping_DefaultJoinColumns(), (Object)(!JoinColumnComposite.this.overrideDefaultJoinColumnsCheckBox.getSelection() ? 1 : 0)));
            }
        });
        this.joinColumnsGroup = new Group((Composite)this, 16);
        this.joinColumnsGroup.setText(DaliUiMessages.JoinColumnComposite_joinColumn);
        this.joinColumnsGroup.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 2;
        this.joinColumnsGroup.setLayoutData((Object)gridData);
        this.joinColumnsListViewer = new ListViewer((Composite)this.joinColumnsGroup, 2050);
        this.joinColumnsListViewer.setContentProvider(this.buildJoinColumnsListContentProvider());
        this.joinColumnsListViewer.setLabelProvider((IBaseLabelProvider)this.buildJoinColumnsListLabelProvider());
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.verticalSpan = 3;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.joinColumnsListViewer.getList().setLayoutData((Object)gridData);
        Button addJoinColumnButton = new Button((Composite)this.joinColumnsGroup, 0);
        addJoinColumnButton.setText(DaliUiMessages.JoinColumnComposite_add);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        addJoinColumnButton.setLayoutData((Object)gridData);
        addJoinColumnButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                JoinColumnComposite.this.addJoinColumn();
            }
        });
        this.joinColumnsEditButton = new Button((Composite)this.joinColumnsGroup, 0);
        this.joinColumnsEditButton.setText(DaliUiMessages.JoinColumnComposite_edit);
        this.joinColumnsEditButton.setEnabled(false);
        this.joinColumnsEditButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                JoinColumnComposite.this.editJoinColumn();
            }
        });
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.joinColumnsEditButton.setLayoutData((Object)gridData);
        this.joinColumnsRemoveButton = new Button((Composite)this.joinColumnsGroup, 0);
        this.joinColumnsRemoveButton.setText(DaliUiMessages.JoinColumnComposite_remove);
        this.joinColumnsRemoveButton.setEnabled(false);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        this.joinColumnsRemoveButton.setLayoutData((Object)gridData);
        this.joinColumnsRemoveButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                JoinColumnComposite.this.removeJoinColumn();
            }
        });
        this.joinColumnsListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                JoinColumnComposite.this.updateEnablement();
            }
        });
    }

    private IContentProvider buildJoinColumnsListContentProvider() {
        return new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return ((SingleRelationshipMapping)inputElement).getJoinColumns().toArray();
            }
        };
    }

    private ILabelProvider buildJoinColumnsListLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                JoinColumn joinColumn = (JoinColumn)element;
                if (JoinColumnComposite.this.singleRelationshipMapping.isDefaultJoinColumns()) {
                    return JoinColumnComposite.this.buildDefaultJoinColumnLabel(joinColumn);
                }
                return JoinColumnComposite.this.buildJoinColumnLabel(joinColumn);
            }
        };
    }

    private String buildDefaultJoinColumnLabel(JoinColumn joinColumn) {
        return NLS.bind((String)DaliUiMessages.JoinColumnComposite_mappingBetweenTwoParamsDefault, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
    }

    private String buildJoinColumnLabel(JoinColumn joinColumn) {
        if (joinColumn.getSpecifiedName() == null) {
            if (joinColumn.getSpecifiedReferencedColumnName() == null) {
                return NLS.bind((String)DaliUiMessages.JoinColumnComposite_mappingBetweenTwoParamsBothDefault, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
            }
            return NLS.bind((String)DaliUiMessages.JoinColumnComposite_mappingBetweenTwoParamsFirstDefault, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
        }
        if (joinColumn.getSpecifiedReferencedColumnName() == null) {
            return NLS.bind((String)DaliUiMessages.JoinColumnComposite_mappingBetweenTwoParamsSecDefault, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
        }
        return NLS.bind((String)DaliUiMessages.JoinColumnComposite_mappingBetweenTwoParams, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
    }

    private INotifyChangedListener getJoinColumnListener() {
        if (this.joinColumnListener == null) {
            this.joinColumnListener = new INotifyChangedListener(){

                public void notifyChanged(Notification notification) {
                    JoinColumnComposite.this.joinColumnChanged(notification, JoinColumnComposite.this.joinColumnsListViewer);
                }
            };
        }
        return this.joinColumnListener;
    }

    protected void joinColumnChanged(Notification notification, final ListViewer listViewer) {
        block28: {
            block27: {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.dali.orm.JoinColumn");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (notification.getFeatureID((Class)clazz) == 4) break block27;
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("org.eclipse.dali.orm.JoinColumn");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (notification.getFeatureID((Class)clazz2) == 7) break block27;
                Class<?> clazz3 = class$0;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$0 = Class.forName("org.eclipse.dali.orm.JoinColumn");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (notification.getFeatureID((Class)clazz3) == 1) break block27;
                Class<?> clazz4 = class$0;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$0 = Class.forName("org.eclipse.dali.orm.JoinColumn");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (notification.getFeatureID((Class)clazz4) == 3) break block27;
                Class<?> clazz5 = class$0;
                if (clazz5 == null) {
                    try {
                        clazz5 = class$0 = Class.forName("org.eclipse.dali.orm.JoinColumn");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (notification.getFeatureID((Class)clazz5) == 6) break block27;
                Class<?> clazz6 = class$0;
                if (clazz6 == null) {
                    try {
                        clazz6 = class$0 = Class.forName("org.eclipse.dali.orm.JoinColumn");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (notification.getFeatureID((Class)clazz6) != 0) break block28;
            }
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    listViewer.refresh();
                }
            });
        }
    }

    private void addJoinColumn() {
        JoinColumnDialog dialog = new JoinColumnDialog(this.getShell(), this.singleRelationshipMapping);
        this.addJoinColumnFromDialog(dialog);
    }

    private void addJoinColumnFromDialog(JoinColumnDialog dialog) {
        if (dialog.open() == 0) {
            IJoinColumnModelAdapter columnModelAdapter = ((ISingleRelationshipMappingModelAdapter)this.singleRelationshipMapping.getModelAdapter()).buildJoinColumnModelAdapter();
            String name = dialog.getSelectedName();
            String referencedColumnName = dialog.getReferencedColumnName();
            JoinColumn joinColumn = OrmFactory.eINSTANCE.createJoinColumn(columnModelAdapter);
            this.editingDomain.getCommandStack().execute(AddCommand.create((EditingDomain)this.editingDomain, (Object)this.singleRelationshipMapping, (Object)OrmPackage.eINSTANCE.getSingleRelationshipMapping_JoinColumns(), (Object)joinColumn));
            this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)this.editingDomain, (Object)joinColumn, (Object)OrmPackage.eINSTANCE.getJoinColumn_SpecifiedName(), (Object)name));
            this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)this.editingDomain, (Object)joinColumn, (Object)OrmPackage.eINSTANCE.getJoinColumn_SpecifiedReferencedColumnName(), (Object)referencedColumnName));
        }
    }

    private void editJoinColumn() {
        JoinColumn joinColumn = this.getSelectedJoinColumn();
        JoinColumnDialog dialog = new JoinColumnDialog(this.getShell(), joinColumn);
        this.editJoinColumnFromDialog(dialog, joinColumn);
    }

    private JoinColumn getSelectedJoinColumn() {
        return (JoinColumn)((StructuredSelection)this.joinColumnsListViewer.getSelection()).getFirstElement();
    }

    private void editJoinColumnFromDialog(JoinColumnDialog dialog, JoinColumn joinColumn) {
        if (dialog.open() == 0) {
            this.editJoinColumnDialogOkd(dialog, joinColumn);
        }
    }

    private void editJoinColumnDialogOkd(JoinColumnDialog dialog, JoinColumn joinColumn) {
        String name = dialog.getSelectedName();
        String referencedColumnName = dialog.getReferencedColumnName();
        if (dialog.isDefaultNameSelected()) {
            if (joinColumn.getSpecifiedName() != null) {
                this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)this.editingDomain, (Object)joinColumn, (Object)OrmPackage.eINSTANCE.getJoinColumn_SpecifiedName(), null));
            }
        } else if (joinColumn.getSpecifiedName() == null || !joinColumn.getSpecifiedName().equals(name)) {
            this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)this.editingDomain, (Object)joinColumn, (Object)OrmPackage.eINSTANCE.getJoinColumn_SpecifiedName(), (Object)name));
        }
        if (dialog.isDefaultReferencedColumnNameSelected()) {
            if (joinColumn.getSpecifiedReferencedColumnName() != null) {
                this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)this.editingDomain, (Object)joinColumn, (Object)OrmPackage.eINSTANCE.getJoinColumn_SpecifiedReferencedColumnName(), null));
            }
        } else if (joinColumn.getSpecifiedReferencedColumnName() == null || !joinColumn.getSpecifiedReferencedColumnName().equals(referencedColumnName)) {
            this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)this.editingDomain, (Object)joinColumn, (Object)OrmPackage.eINSTANCE.getJoinColumn_SpecifiedReferencedColumnName(), (Object)referencedColumnName));
        }
    }

    private void removeJoinColumn() {
        ISelection selection = this.joinColumnsListViewer.getSelection();
        if (selection instanceof StructuredSelection) {
            Iterator i = ((StructuredSelection)selection).iterator();
            while (i.hasNext()) {
                this.singleRelationshipMapping.getJoinColumns().remove((Object)((JoinColumn)i.next()));
            }
        }
    }

    private INotifyChangedListener getSingleRelationshipMappingListener() {
        if (this.singleRelationshipMappingListener == null) {
            this.singleRelationshipMappingListener = new INotifyChangedListener(){

                public void notifyChanged(Notification notification) {
                    JoinColumnComposite.this.singleRelationshipMappingChanged(notification);
                }
            };
        }
        return this.singleRelationshipMappingListener;
    }

    protected void singleRelationshipMappingChanged(Notification notification) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.dali.orm.SingleRelationshipMapping");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (notification.getFeatureID((Class)clazz) == 6) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    JoinColumnComposite.this.joinColumnsListViewer.refresh();
                    boolean isDefault = JoinColumnComposite.this.singleRelationshipMapping.isDefaultJoinColumns();
                    JoinColumnComposite.this.overrideDefaultJoinColumnsCheckBox.setSelection(!isDefault);
                    JoinColumnComposite.this.updateEnablement();
                }
            });
        } else {
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.dali.orm.SingleRelationshipMapping");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (notification.getFeatureID((Class)clazz2) == 7) {
                if (notification.getEventType() == 3) {
                    ((JoinColumn)notification.getNewValue()).eAdapters().add((Object)this.joinColumnItemProvider);
                } else if (notification.getEventType() == 4) {
                    ((JoinColumn)notification.getOldValue()).eAdapters().remove((Object)this.joinColumnItemProvider);
                }
            }
        }
    }

    private void enableGroup(Group group, boolean enabled) {
        group.setEnabled(enabled);
        int i = 0;
        while (i < group.getChildren().length) {
            group.getChildren()[i].setEnabled(enabled);
            ++i;
        }
    }

    public void populate(EObject model) {
        Iterator i;
        this.populating = true;
        if (this.singleRelationshipMapping != null) {
            this.singleRelationshipMappingItemProvider.removeListener(this.getSingleRelationshipMappingListener());
            this.joinColumnItemProvider.removeListener(this.getJoinColumnListener());
            this.singleRelationshipMapping.eAdapters().remove((Object)this.singleRelationshipMappingItemProvider);
            i = this.singleRelationshipMapping.getJoinColumns().iterator();
            while (i.hasNext()) {
                ((JoinColumn)i.next()).eAdapters().remove((Object)this.joinColumnItemProvider);
            }
        }
        this.singleRelationshipMapping = (SingleRelationshipMapping)model;
        if (this.singleRelationshipMapping == null) {
            this.joinColumnsListViewer.setInput(null);
            return;
        }
        this.singleRelationshipMappingItemProvider.addListener(this.getSingleRelationshipMappingListener());
        this.joinColumnItemProvider.addListener(this.getJoinColumnListener());
        this.singleRelationshipMapping.eAdapters().add((Object)this.singleRelationshipMappingItemProvider);
        i = this.singleRelationshipMapping.getJoinColumns().iterator();
        while (i.hasNext()) {
            ((JoinColumn)i.next()).eAdapters().add((Object)this.joinColumnItemProvider);
        }
        this.joinColumnsListViewer.setInput((Object)this.singleRelationshipMapping);
        this.updateEnablement();
        this.overrideDefaultJoinColumnsCheckBox.setSelection(!this.singleRelationshipMapping.isDefaultJoinColumns());
        this.populating = false;
    }

    private void updateEnablement() {
        boolean groupEnabledState = !this.singleRelationshipMapping.isDefaultJoinColumns();
        this.enableGroup(this.joinColumnsGroup, groupEnabledState);
        this.joinColumnsRemoveButton.setEnabled(groupEnabledState && !((StructuredSelection)this.joinColumnsListViewer.getSelection()).isEmpty());
        this.joinColumnsEditButton.setEnabled(groupEnabledState && ((StructuredSelection)this.joinColumnsListViewer.getSelection()).size() == 1);
    }
}

