/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.parser;

import java.util.EmptyStackException;

public class IntStack {
    private int[] list = null;
    private int size = 0;

    public IntStack() {
        this(100);
    }

    public IntStack(int maxdepth) {
        this.list = new int[maxdepth];
        this.initialize();
    }

    public boolean empty() {
        return this.size == 0;
    }

    public int get(int slot) {
        return this.list[slot];
    }

    void initialize() {
        int i = 0;
        while (i < this.list.length) {
            this.list[i] = -1;
            ++i;
        }
    }

    public int peek() {
        if (this.size == 0) {
            throw new EmptyStackException();
        }
        return this.list[this.size - 1];
    }

    public int pop() {
        int value = this.peek();
        this.list[this.size - 1] = -1;
        --this.size;
        return value;
    }

    public int push(int newValue) {
        if (this.size == this.list.length) {
            throw new StackOverflowError();
        }
        this.list[this.size++] = newValue;
        return newValue;
    }

    public int size() {
        return this.list.length;
    }
}

