/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.wsil.datamodel;

import org.apache.wsil.Description;
import org.apache.wsil.Service;
import org.apache.wsil.extension.ExtensionElement;
import org.apache.wsil.extension.uddi.ServiceDescription;
import org.eclipse.wst.ws.internal.datamodel.Model;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.util.Uddi4jHelper;
import org.eclipse.wst.ws.internal.explorer.platform.util.Validator;
import org.eclipse.wst.ws.internal.explorer.platform.wsil.datamodel.WsilServiceElement;
import org.uddi4j.datatype.service.BusinessService;
import org.uddi4j.util.DiscoveryURL;

public class WsilUddiServiceElement
extends WsilServiceElement {
    private BusinessService busService_ = null;

    public WsilUddiServiceElement(String name, Model model, Service service) {
        super(name, model, service);
    }

    public void setServiceDefinition(BusinessService busService) {
        this.busService_ = busService;
    }

    public BusinessService getServiceDefinition() {
        return this.busService_;
    }

    public String getName() {
        return this.busService_ == null ? null : this.busService_.getDefaultNameString();
    }

    public String getDescription() {
        return this.busService_ == null ? null : this.busService_.getDefaultDescriptionString();
    }

    public String getUDDIServiceInquiryAPI() {
        ServiceDescription sd = this.getValidUDDIServiceDescription();
        return sd == null ? null : sd.getLocation();
    }

    public String getUDDIServiceKey() {
        ServiceDescription sd = this.getValidUDDIServiceDescription();
        return sd == null ? null : sd.getServiceKey().getText();
    }

    public String getUDDIServiceDiscoveryURL() {
        ServiceDescription sd = this.getValidUDDIServiceDescription();
        if (sd == null) {
            return null;
        }
        DiscoveryURL discoveryURL = sd.getDiscoveryURL();
        return discoveryURL == null ? null : discoveryURL.getText();
    }

    private ServiceDescription getValidUDDIServiceDescription() {
        Description[] descList = this.service_.getDescriptions();
        int i = 0;
        while (i < descList.length) {
            String serviceKey;
            ExtensionElement extElement = descList[i].getExtensionElement();
            if (extElement instanceof ServiceDescription && Validator.validateURL(((ServiceDescription)extElement).getLocation()) && (serviceKey = ((ServiceDescription)extElement).getServiceKey().getText()) != null && serviceKey.length() > 0) {
                return (ServiceDescription)extElement;
            }
            ++i;
        }
        return null;
    }

    public boolean validateUDDIService() {
        ServiceDescription sd = this.getValidUDDIServiceDescription();
        return sd != null;
    }

    public String getWsdlUrl() {
        return new Uddi4jHelper().getWSDL(this.getServiceDefinition(), null);
    }

    public String toString() {
        return this.getName();
    }
}

