/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.newsourcepage;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.wst.jsdt.internal.corext.buildpath.BuildpathDelta;
import org.eclipse.wst.jsdt.internal.corext.buildpath.IBuildpathModifierListener;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;

public abstract class BuildpathModifierAction
extends Action
implements ISelectionChangedListener {
    public static final int ADD_SEL_SF_TO_BP = 0;
    public static final int REMOVE_FROM_BP = 1;
    public static final int EXCLUDE = 2;
    public static final int UNEXCLUDE = 3;
    public static final int EDIT_FILTERS = 4;
    public static final int CREATE_LINK = 5;
    public static final int RESET_ALL = 6;
    public static final int EDIT_OUTPUT = 7;
    public static final int CREATE_OUTPUT = 8;
    public static final int RESET = 9;
    public static final int INCLUDE = 10;
    public static final int UNINCLUDE = 11;
    public static final int CREATE_FOLDER = 12;
    public static final int ADD_JAR_TO_BP = 13;
    public static final int ADD_LIB_TO_BP = 14;
    public static final int ADD_SEL_LIB_TO_BP = 15;
    public static final int CONFIGURE_BUILD_PATH = 16;
    public static final int RESET_ALL_OUTPUT_FOLDERS = 17;
    public static final int DROP_DOWN_ACTION = 18;
    private final IWorkbenchSite fSite;
    private final List fSelectedElements;
    private final ISetSelectionTarget fSelectionTarget;
    private final List fListeners;
    static /* synthetic */ Class class$0;

    public BuildpathModifierAction(IWorkbenchSite site, ISetSelectionTarget selectionTarget, int id) {
        this(site, selectionTarget, id, 1);
    }

    public BuildpathModifierAction(IWorkbenchSite site, ISetSelectionTarget selectionTarget, int id, int style) {
        super("", style);
        this.fSite = site;
        this.fSelectionTarget = selectionTarget;
        this.fSelectedElements = new ArrayList();
        this.fListeners = new ArrayList();
        this.setId(Integer.toString(id));
    }

    public abstract String getDetailedDescription();

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection) {
            this.setEnabled(this.canHandle((IStructuredSelection)selection));
            this.fSelectedElements.clear();
            this.fSelectedElements.addAll(((IStructuredSelection)selection).toList());
        } else {
            this.setEnabled(this.canHandle((IStructuredSelection)StructuredSelection.EMPTY));
            this.fSelectedElements.clear();
        }
    }

    protected abstract boolean canHandle(IStructuredSelection var1);

    protected List getSelectedElements() {
        return this.fSelectedElements;
    }

    public void addBuildpathModifierListener(IBuildpathModifierListener listener) {
        this.fListeners.add(listener);
    }

    public void removeBuildpathModifierListener(IBuildpathModifierListener listener) {
        this.fListeners.remove(listener);
    }

    protected void informListeners(BuildpathDelta delta) {
        Iterator iterator = this.fListeners.iterator();
        while (iterator.hasNext()) {
            ((IBuildpathModifierListener)iterator.next()).buildpathChanged(delta);
        }
    }

    protected Shell getShell() {
        if (this.fSite == null) {
            return JavaScriptPlugin.getActiveWorkbenchShell();
        }
        return this.fSite.getShell() != null ? this.fSite.getShell() : JavaScriptPlugin.getActiveWorkbenchShell();
    }

    protected void showExceptionDialog(CoreException exception, String title) {
        this.showError(exception, this.getShell(), title, exception.getMessage());
    }

    protected void showError(CoreException e, Shell shell, String title, String message) {
        IStatus status = e.getStatus();
        if (status != null) {
            ErrorDialog.openError((Shell)shell, (String)message, (String)title, (IStatus)status);
        } else {
            MessageDialog.openError((Shell)shell, (String)title, (String)message);
        }
    }

    protected void selectAndReveal(final ISelection selection) {
        IWorkbenchPart part;
        if (this.fSelectionTarget != null) {
            this.fSelectionTarget.selectReveal(selection);
        }
        if (this.fSite == null) {
            return;
        }
        IWorkbenchPage page = this.fSite.getPage();
        if (page == null) {
            return;
        }
        ArrayList<IWorkbenchPart> parts = new ArrayList<IWorkbenchPart>();
        IViewReference[] refs = page.getViewReferences();
        int i = 0;
        while (i < refs.length) {
            part = refs[i].getPart(false);
            if (part != null) {
                parts.add(part);
            }
            ++i;
        }
        refs = page.getEditorReferences();
        i = 0;
        while (i < refs.length) {
            if (refs[i].getPart(false) != null) {
                parts.add(refs[i].getPart(false));
            }
            ++i;
        }
        Iterator itr = parts.iterator();
        while (itr.hasNext()) {
            part = (IWorkbenchPart)itr.next();
            ISetSelectionTarget target = null;
            if (part instanceof ISetSelectionTarget) {
                target = (ISetSelectionTarget)part;
            } else {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.ui.part.ISetSelectionTarget");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                target = (ISetSelectionTarget)part.getAdapter((Class)clazz);
            }
            if (target == null) continue;
            final ISetSelectionTarget finalTarget = target;
            page.getWorkbenchWindow().getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    finalTarget.selectReveal(selection);
                }
            });
        }
    }
}

