/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.jem.util.emf.workbench.EMFWorkbenchContextBase;
import org.eclipse.jem.util.emf.workbench.ISynchronizerExtender;
import org.eclipse.jem.util.emf.workbench.ProjectResourceSet;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.wst.common.componentcore.internal.ArtifactEditModel;
import org.eclipse.wst.common.componentcore.internal.ModuleStructuralModel;
import org.eclipse.wst.common.componentcore.internal.ModulecorePlugin;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.impl.ComponentCoreURIConverter;
import org.eclipse.wst.common.componentcore.internal.impl.WTPResourceFactoryRegistry;
import org.eclipse.wst.common.componentcore.internal.util.IModuleConstants;
import org.eclipse.wst.common.componentcore.internal.util.ModuleCoreMessages;
import org.eclipse.wst.common.internal.emfworkbench.edit.EditModelRegistry;
import org.eclipse.wst.common.internal.emfworkbench.integration.EditModel;
import org.eclipse.wst.common.internal.emfworkbench.integration.EditModelNature;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class ModuleCoreNature
extends EditModelNature
implements IProjectNature,
IModuleConstants,
ISynchronizerExtender {
    public static final String VALIDATION_BUILDER_ID = "org.eclipse.wst.validation.validationbuilder";
    private ModuleStructuralModel cachedWriteHandle;
    private ModuleStructuralModel cachedReadHandle;

    public static ModuleCoreNature getModuleCoreNature(IProject aProject) {
        try {
            if (aProject != null && aProject.isAccessible()) {
                return (ModuleCoreNature)aProject.getNature("org.eclipse.wst.common.modulecore.ModuleCoreNature");
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    public static boolean isFlexibleProject(IProject project) {
        boolean foundNature;
        boolean bl = foundNature = ModuleCoreNature.getModuleCoreNature(project) != null;
        if (foundNature) {
            return ModuleCoreNature.componentResourceExists(project);
        }
        return false;
    }

    public static boolean componentResourceExists(IProject project) {
        IFile compFile = project.getFile(StructureEdit.MODULE_META_FILE_NAME);
        if (compFile.isAccessible()) {
            return true;
        }
        compFile = project.getFile(".settings/.component");
        if (compFile.isAccessible()) {
            return true;
        }
        compFile = project.getFile(".component");
        if (compFile.isAccessible()) {
            return true;
        }
        compFile = project.getFile(".wtpmodules");
        return compFile.isAccessible();
    }

    public static ModuleCoreNature addModuleCoreNatureIfNecessary(IProject aProject, IProgressMonitor aMonitor) {
        try {
            block10: {
                if (aProject.hasNature("org.eclipse.wst.common.modulecore.ModuleCoreNature")) {
                    return ModuleCoreNature.getModuleCoreNature(aProject);
                }
                IJobManager manager = Platform.getJobManager();
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                if (aMonitor != null) {
                    aMonitor.beginTask("Add ModuleCore Nature", 5);
                }
                manager.beginRule((ISchedulingRule)root, aMonitor);
                try {
                    try {
                        IProjectDescription description = aProject.getDescription();
                        String[] currentNatureIds = description.getNatureIds();
                        String[] newNatureIds = new String[currentNatureIds.length + 1];
                        System.arraycopy(currentNatureIds, 0, newNatureIds, 0, currentNatureIds.length);
                        newNatureIds[currentNatureIds.length] = "org.eclipse.wst.common.modulecore.ModuleCoreNature";
                        description.setNatureIds(newNatureIds);
                        aProject.setDescription(description, aMonitor);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                        manager.endRule((ISchedulingRule)root);
                        break block10;
                    }
                }
                catch (Throwable throwable) {
                    manager.endRule((ISchedulingRule)root);
                    throw throwable;
                }
                manager.endRule((ISchedulingRule)root);
            }
            if (aMonitor != null) {
                aMonitor.done();
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return ModuleCoreNature.getModuleCoreNature(aProject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModuleStructuralModel getModuleStructuralModelForRead(Object anAccessorKey) {
        ModuleStructuralModel editModel = (ModuleStructuralModel)this.getEmfContext().getExistingEditModel("org.eclipse.wst.modulecore.structuralModel", null, true);
        if (editModel == null) {
            ModuleStructuralModel moduleStructuralModel = editModel = (ModuleStructuralModel)EditModelRegistry.getInstance().createEditModelForRead("org.eclipse.wst.modulecore.structuralModel", this.getEmfContext(), null);
            synchronized (moduleStructuralModel) {
                this.getEmfContext().cacheEditModel((EditModel)editModel, null);
                editModel.access(anAccessorKey);
            }
        }
        ModuleStructuralModel moduleStructuralModel = editModel;
        synchronized (moduleStructuralModel) {
            editModel.access(anAccessorKey);
        }
        return editModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModuleStructuralModel getModuleStructuralModelForWrite(Object anAccessorKey) {
        ModuleStructuralModel editModel = (ModuleStructuralModel)this.getEmfContext().getExistingEditModel("org.eclipse.wst.modulecore.structuralModel", null, false);
        if (editModel == null) {
            ModuleStructuralModel moduleStructuralModel = editModel = (ModuleStructuralModel)EditModelRegistry.getInstance().createEditModelForWrite("org.eclipse.wst.modulecore.structuralModel", this.getEmfContext(), null);
            synchronized (moduleStructuralModel) {
                this.getEmfContext().cacheEditModel((EditModel)editModel, null);
                editModel.access(anAccessorKey);
            }
        }
        ModuleStructuralModel moduleStructuralModel = editModel;
        synchronized (moduleStructuralModel) {
            editModel.access(anAccessorKey);
        }
        return editModel;
    }

    public ArtifactEditModel getArtifactEditModelForRead(URI aModuleURI, Object anAccessorKey) {
        return this.getArtifactEditModelForRead(aModuleURI, anAccessorKey, null);
    }

    public ArtifactEditModel getArtifactEditModelForRead(URI aModuleURI, Object anAccessorKey, String projectType, Map params) {
        block9: {
            if (params == null) {
                params = new HashMap<String, URI>();
            }
            params.put("MODULE_URI", aModuleURI);
            if (projectType != null) {
                return (ArtifactEditModel)this.getEditModelForRead(projectType, anAccessorKey, params);
            }
            try {
                IProject aProject = StructureEdit.getContainingProject(aModuleURI);
                IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)aProject);
                if (facetedProject == null) break block9;
                String[] editModelIDs = EditModelRegistry.getInstance().getRegisteredEditModelIDs();
                int i = 0;
                while (i < editModelIDs.length) {
                    try {
                        ArtifactEditModel editModel;
                        IProjectFacet facet = ProjectFacetsManager.getProjectFacet((String)editModelIDs[i]);
                        if (facet != null && facetedProject.hasProjectFacet(facet) && (editModel = (ArtifactEditModel)this.getEditModelForRead(editModelIDs[i], anAccessorKey, params)) != null) {
                            return editModel;
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                    catch (Exception e) {
                        ModulecorePlugin.logError(4, ModuleCoreMessages.Acquiring_ArtifactEdit_For_Read_Exception, e);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                ModulecorePlugin.logError(4, ModuleCoreMessages.Acquiring_ArtifactEdit_For_Read_Exception, e);
            }
        }
        return null;
    }

    public ArtifactEditModel getArtifactEditModelForRead(URI aModuleURI, Object anAccessorKey, String projectType) {
        HashMap params = new HashMap();
        return this.getArtifactEditModelForRead(aModuleURI, anAccessorKey, projectType, params);
    }

    public ArtifactEditModel getArtifactEditModelForWrite(URI aModuleURI, Object anAccessorKey) {
        return this.getArtifactEditModelForWrite(aModuleURI, anAccessorKey, null);
    }

    public ArtifactEditModel getArtifactEditModelForWrite(URI aModuleURI, Object anAccessorKey, String projectType, Map params) {
        block9: {
            if (params == null) {
                params = new HashMap<String, URI>();
            }
            params.put("MODULE_URI", aModuleURI);
            if (projectType != null) {
                return (ArtifactEditModel)this.getEditModelForWrite(projectType, anAccessorKey, params);
            }
            try {
                IProject aProject = StructureEdit.getContainingProject(aModuleURI);
                IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)aProject);
                if (facetedProject == null) break block9;
                String[] editModelIDs = EditModelRegistry.getInstance().getRegisteredEditModelIDs();
                int i = 0;
                while (i < editModelIDs.length) {
                    try {
                        ArtifactEditModel editModel;
                        IProjectFacet facet = ProjectFacetsManager.getProjectFacet((String)editModelIDs[i]);
                        if (facet != null && facetedProject.hasProjectFacet(facet) && (editModel = (ArtifactEditModel)this.getEditModelForWrite(editModelIDs[i], anAccessorKey, params)) != null) {
                            return editModel;
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                    catch (Exception e) {
                        ModulecorePlugin.logError(4, ModuleCoreMessages.Acquiring_ArtifactEdit_For_Write_Exception, e);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                ModulecorePlugin.logError(4, ModuleCoreMessages.Acquiring_ArtifactEdit_For_Write_Exception, e);
            }
        }
        return null;
    }

    public ArtifactEditModel getArtifactEditModelForWrite(URI aModuleURI, Object anAccessorKey, String projectType) {
        HashMap params = new HashMap();
        return this.getArtifactEditModelForWrite(aModuleURI, anAccessorKey, projectType, params);
    }

    public String getNatureID() {
        return "org.eclipse.wst.common.modulecore.ModuleCoreNature";
    }

    public void primaryContributeToContext(EMFWorkbenchContextBase aNature) {
        if (this.emfContext == aNature) {
            return;
        }
        this.emfContext = aNature;
        this.getEmfContext().setDefaultToMOF5Compatibility(true);
        ProjectResourceSet projectResourceSet = aNature.getResourceSet();
        projectResourceSet.setResourceFactoryRegistry((Resource.Factory.Registry)WTPResourceFactoryRegistry.INSTANCE);
        projectResourceSet.setURIConverter(this.createURIConverter(this.getProject(), projectResourceSet));
        projectResourceSet.getSynchronizer().addExtender((ISynchronizerExtender)this);
        this.cacheModuleStructuralModels();
    }

    protected void primConfigure() throws CoreException {
        super.primConfigure();
        ProjectUtilities.addToBuildSpec((String)VALIDATION_BUILDER_ID, (IProject)this.project);
    }

    private URIConverter createURIConverter(IProject aProject, ProjectResourceSet aResourceSet) {
        ComponentCoreURIConverter uriConverter = new ComponentCoreURIConverter(aProject, aResourceSet.getSynchronizer());
        uriConverter.addInputContainer((IContainer)this.getProject());
        return uriConverter;
    }

    public ResourceSet getResourceSet() {
        return this.getEmfContextBase().getResourceSet();
    }

    public void secondaryContributeToContext(EMFWorkbenchContextBase aNature) {
    }

    public void configure() throws CoreException {
        super.configure();
    }

    private void cacheModuleStructuralModels() {
        if (this.cachedWriteHandle == null) {
            this.cachedWriteHandle = this.getModuleStructuralModelForWrite(this);
        }
        if (this.cachedReadHandle == null) {
            this.cachedReadHandle = this.getModuleStructuralModelForRead(this);
        }
    }

    protected String getPluginID() {
        return "org.eclipse.wst.common.modulecore";
    }

    public EditModel getExistingEditModel(String artifactEditModelId, Map params, boolean isReadOnly) {
        return this.getEmfContext().getExistingEditModel(artifactEditModelId, params, isReadOnly);
    }

    public void shutdown() {
        super.shutdown();
        if (this.cachedWriteHandle != null) {
            if (this.cachedWriteHandle.isDirty()) {
                this.cachedWriteHandle.saveIfNecessary(this);
            }
            this.cachedWriteHandle.dispose();
            this.cachedWriteHandle = null;
        }
        if (this.cachedReadHandle != null) {
            if (this.cachedReadHandle.isDirty()) {
                this.cachedReadHandle.saveIfNecessary(this);
            }
            this.cachedReadHandle.dispose();
            this.cachedReadHandle = null;
        }
    }

    public void projectChanged(IResourceDelta delta) {
        if (delta.getKind() == 16384) {
            if (this.cachedWriteHandle == null) {
                this.cachedWriteHandle = this.getModuleStructuralModelForWrite(this);
            }
            if (this.cachedReadHandle == null) {
                this.cachedReadHandle = this.getModuleStructuralModelForRead(this);
            }
        }
    }

    public void projectClosed() {
        this.emfContext = null;
        if (this.cachedWriteHandle != null) {
            if (this.cachedWriteHandle.isDirty()) {
                this.cachedWriteHandle.saveIfNecessary(this);
            }
            this.cachedWriteHandle.dispose();
            this.cachedWriteHandle = null;
        }
        if (this.cachedReadHandle != null) {
            this.cachedReadHandle.dispose();
            this.cachedReadHandle = null;
        }
    }
}

