/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.mappings.details;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.jpt.core.context.Column;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.ui.WidgetFactory;
import org.eclipse.jpt.ui.internal.mappings.JptUiMappingsMessages;
import org.eclipse.jpt.ui.internal.mappings.db.ColumnCombo;
import org.eclipse.jpt.ui.internal.mappings.db.TableCombo;
import org.eclipse.jpt.ui.internal.util.LabeledControlUpdater;
import org.eclipse.jpt.ui.internal.util.LabeledLabel;
import org.eclipse.jpt.ui.internal.widgets.AbstractFormPane;
import org.eclipse.jpt.ui.internal.widgets.AbstractPane;
import org.eclipse.jpt.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnComposite
extends AbstractFormPane<Column> {
    public ColumnComposite(AbstractFormPane<?> parentPane, PropertyValueModel<? extends Column> subjectHolder, Composite parent) {
        super(parentPane, subjectHolder, parent);
    }

    public ColumnComposite(AbstractFormPane<?> parentPane, PropertyValueModel<? extends Column> subjectHolder, Composite parent, boolean automaticallyAlignWidgets) {
        super(parentPane, subjectHolder, parent, automaticallyAlignWidgets);
    }

    public ColumnComposite(PropertyValueModel<? extends Column> subjectHolder, Composite parent, WidgetFactory widgetFactory) {
        super(subjectHolder, parent, widgetFactory);
    }

    private ColumnCombo<Column> buildColumnCombo(Composite container) {
        return new ColumnCombo<Column>((AbstractPane)this, container){

            @Override
            protected void addPropertyNames(Collection<String> propertyNames) {
                super.addPropertyNames(propertyNames);
                propertyNames.add("defaultNameProperty");
                propertyNames.add("specifiedNameProperty");
                propertyNames.add("defaultTableProperty");
                propertyNames.add("specifiedTableProperty");
            }

            @Override
            protected void propertyChanged(String propertyName) {
                if (propertyName == "defaultTableProperty" || propertyName == "specifiedTableProperty") {
                    this.doPopulate();
                } else {
                    super.propertyChanged(propertyName);
                }
            }

            @Override
            protected String defaultValue() {
                return ((Column)this.subject()).getDefaultName();
            }

            @Override
            protected void setValue(String value) {
                ((Column)this.subject()).setSpecifiedName(value);
            }

            @Override
            protected Table table() {
                return ((Column)this.subject()).getDbTable();
            }

            @Override
            protected String value() {
                return ((Column)this.subject()).getSpecifiedName();
            }
        };
    }

    private WritablePropertyValueModel<String> buildColumnDefinitionHolder() {
        return new PropertyAspectAdapter<Column, String>(this.getSubjectHolder(), new String[]{"columnDefinitionProperty"}){

            protected String buildValue_() {
                return ((Column)this.subject).getColumnDefinition();
            }

            protected void setValue_(String value) {
                if (value.length() == 0) {
                    value = null;
                }
                ((Column)this.subject).setColumnDefinition(value);
            }
        };
    }

    private WritablePropertyValueModel<Integer> buildDefaultLengthHolder() {
        return new PropertyAspectAdapter<Column, Integer>(this.getSubjectHolder(), new String[]{"defaultLengthProperty"}){

            protected Integer buildValue_() {
                return ((Column)this.subject).getDefaultLength();
            }

            protected void subjectChanged() {
                Object oldValue = this.getValue();
                super.subjectChanged();
                Object newValue = this.getValue();
                if (oldValue == newValue && newValue == null) {
                    this.fireAspectChange(Integer.MIN_VALUE, newValue);
                }
            }
        };
    }

    private Control buildDefaultLengthLabel(Composite container) {
        Label label = this.buildLabel(container, JptUiMappingsMessages.DefaultWithoutValue);
        new LabeledControlUpdater(new LabeledLabel(label), this.buildDefaultLengthLabelHolder());
        return label;
    }

    private PropertyValueModel<String> buildDefaultLengthLabelHolder() {
        return new TransformationPropertyValueModel<Integer, String>(this.buildDefaultLengthHolder()){

            protected String transform(Integer value) {
                Integer defaultValue = ColumnComposite.this.subject() != null ? ((Column)ColumnComposite.this.subject()).getDefaultLength() : Column.DEFAULT_LENGTH;
                return NLS.bind((String)JptUiMappingsMessages.DefaultWithValue, (Object)defaultValue);
            }
        };
    }

    private WritablePropertyValueModel<Integer> buildDefaultPrecisionHolder() {
        return new PropertyAspectAdapter<Column, Integer>(this.getSubjectHolder(), new String[]{"defaultPrecisionProperty"}){

            protected Integer buildValue_() {
                return ((Column)this.subject).getDefaultPrecision();
            }

            protected void subjectChanged() {
                Object oldValue = this.getValue();
                super.subjectChanged();
                Object newValue = this.getValue();
                if (oldValue == newValue && newValue == null) {
                    this.fireAspectChange(Integer.MIN_VALUE, newValue);
                }
            }
        };
    }

    private Control buildDefaultPrecisionLabel(Composite container) {
        Label label = this.buildLabel(container, JptUiMappingsMessages.DefaultWithoutValue);
        new LabeledControlUpdater(new LabeledLabel(label), this.buildDefaultPrecisionLabelHolder());
        return label;
    }

    private PropertyValueModel<String> buildDefaultPrecisionLabelHolder() {
        return new TransformationPropertyValueModel<Integer, String>(this.buildDefaultPrecisionHolder()){

            protected String transform(Integer value) {
                Integer defaultValue = ColumnComposite.this.subject() != null ? ((Column)ColumnComposite.this.subject()).getDefaultPrecision() : Column.DEFAULT_PRECISION;
                return NLS.bind((String)JptUiMappingsMessages.DefaultWithValue, (Object)defaultValue);
            }
        };
    }

    private WritablePropertyValueModel<Integer> buildDefaultScaleHolder() {
        return new PropertyAspectAdapter<Column, Integer>(this.getSubjectHolder(), new String[]{"defaultScaleProperty"}){

            protected Integer buildValue_() {
                return ((Column)this.subject).getDefaultScale();
            }

            protected void subjectChanged() {
                Object oldValue = this.getValue();
                super.subjectChanged();
                Object newValue = this.getValue();
                if (oldValue == newValue && newValue == null) {
                    this.fireAspectChange(Boolean.TRUE, newValue);
                }
            }
        };
    }

    private Control buildDefaultScaleLabel(Composite container) {
        Label label = this.buildLabel(container, JptUiMappingsMessages.DefaultWithoutValue);
        new LabeledControlUpdater(new LabeledLabel(label), this.buildDefaultScaleLabelHolder());
        return label;
    }

    private PropertyValueModel<String> buildDefaultScaleLabelHolder() {
        return new TransformationPropertyValueModel<Integer, String>(this.buildDefaultScaleHolder()){

            protected String transform(Integer value) {
                Integer defaultValue = ColumnComposite.this.subject() != null ? ((Column)ColumnComposite.this.subject()).getDefaultScale() : Column.DEFAULT_SCALE;
                return NLS.bind((String)JptUiMappingsMessages.DefaultWithValue, (Object)defaultValue);
            }
        };
    }

    private WritablePropertyValueModel<Boolean> buildInsertableHolder() {
        return new PropertyAspectAdapter<Column, Boolean>(this.getSubjectHolder(), new String[]{"specifiedInsertableProperty"}){

            protected Boolean buildValue_() {
                return ((Column)this.subject).getSpecifiedInsertable();
            }

            protected void setValue_(Boolean value) {
                ((Column)this.subject).setSpecifiedInsertable(value);
            }
        };
    }

    private PropertyValueModel<String> buildInsertableStringHolder() {
        return new TransformationPropertyValueModel<Boolean, String>(this.buildInsertableHolder()){

            protected String transform(Boolean value) {
                Boolean defaultValue;
                if (ColumnComposite.this.subject() != null && value == null && (defaultValue = ((Column)ColumnComposite.this.subject()).getDefaultInsertable()) != null) {
                    String defaultStringValue = defaultValue != false ? JptUiMappingsMessages.Boolean_True : JptUiMappingsMessages.Boolean_False;
                    return NLS.bind((String)JptUiMappingsMessages.ColumnComposite_insertableWithDefault, (Object)defaultStringValue);
                }
                return JptUiMappingsMessages.ColumnComposite_insertable;
            }
        };
    }

    private WritablePropertyValueModel<Integer> buildLengthHolder() {
        return new PropertyAspectAdapter<Column, Integer>(this.getSubjectHolder(), new String[]{"spcifiedLengthProperty"}){

            protected Integer buildValue_() {
                return ((Column)this.subject).getSpecifiedLength();
            }

            protected void setValue_(Integer value) {
                if (value == -1) {
                    value = null;
                }
                ((Column)this.subject).setSpecifiedLength(value);
            }
        };
    }

    private WritablePropertyValueModel<Boolean> buildNullableHolder() {
        return new PropertyAspectAdapter<Column, Boolean>(this.getSubjectHolder(), new String[]{"defaultNullableProperty", "specifiedNullableProperty"}){

            protected Boolean buildValue_() {
                return ((Column)this.subject).getSpecifiedNullable();
            }

            protected void setValue_(Boolean value) {
                ((Column)this.subject).setSpecifiedNullable(value);
            }

            protected void subjectChanged() {
                Object oldValue = this.getValue();
                super.subjectChanged();
                Object newValue = this.getValue();
                if (oldValue == newValue && newValue == null) {
                    this.fireAspectChange(Boolean.TRUE, newValue);
                }
            }
        };
    }

    private PropertyValueModel<String> buildNullableStringHolder() {
        return new TransformationPropertyValueModel<Boolean, String>(this.buildNullableHolder()){

            protected String transform(Boolean value) {
                Boolean defaultValue;
                if (ColumnComposite.this.subject() != null && value == null && (defaultValue = ((Column)ColumnComposite.this.subject()).getDefaultNullable()) != null) {
                    String defaultStringValue = defaultValue != false ? JptUiMappingsMessages.Boolean_True : JptUiMappingsMessages.Boolean_False;
                    return NLS.bind((String)JptUiMappingsMessages.ColumnComposite_nullableWithDefault, (Object)defaultStringValue);
                }
                return JptUiMappingsMessages.ColumnComposite_nullable;
            }
        };
    }

    private WritablePropertyValueModel<Integer> buildPrecisionHolder() {
        return new PropertyAspectAdapter<Column, Integer>(this.getSubjectHolder(), new String[]{"spcifiedPrecisionProperty"}){

            protected Integer buildValue_() {
                return ((Column)this.subject).getSpecifiedPrecision();
            }

            protected void setValue_(Integer value) {
                if (value == -1) {
                    value = null;
                }
                ((Column)this.subject).setSpecifiedPrecision(value);
            }
        };
    }

    private WritablePropertyValueModel<Integer> buildScaleHolder() {
        return new PropertyAspectAdapter<Column, Integer>(this.getSubjectHolder(), new String[]{"spcifiedScaleProperty"}){

            protected Integer buildValue_() {
                return ((Column)this.subject).getSpecifiedScale();
            }

            protected void setValue_(Integer value) {
                if (value == -1) {
                    value = null;
                }
                ((Column)this.subject).setSpecifiedScale(value);
            }
        };
    }

    private TableCombo<Column> buildTableCombo(Composite container) {
        return new TableCombo<Column>((AbstractPane)this, container){

            @Override
            protected void addPropertyNames(Collection<String> propertyNames) {
                super.addPropertyNames(propertyNames);
                propertyNames.add("defaultTableProperty");
                propertyNames.add("specifiedTableProperty");
            }

            @Override
            protected String defaultValue() {
                return ((Column)this.subject()).getDefaultTable();
            }

            @Override
            protected String schemaName() {
                return null;
            }

            @Override
            protected void setValue(String value) {
                ((Column)this.subject()).setSpecifiedTable(value);
            }

            @Override
            protected Table table() {
                return ((Column)this.subject()).getDbTable();
            }

            @Override
            protected String value() {
                return ((Column)this.subject()).getSpecifiedTable();
            }

            @Override
            protected Iterator<String> values() {
                return ((Column)this.subject()).getOwner().getTypeMapping().associatedTableNamesIncludingInherited();
            }
        };
    }

    private WritablePropertyValueModel<Boolean> buildUniqueHolder() {
        return new PropertyAspectAdapter<Column, Boolean>(this.getSubjectHolder(), new String[]{"defaultUniqueProperty", "specifiedUniqueProperty"}){

            protected Boolean buildValue_() {
                return ((Column)this.subject).getSpecifiedUnique();
            }

            protected void setValue_(Boolean value) {
                ((Column)this.subject).setSpecifiedUnique(value);
            }

            protected void subjectChanged() {
                Object oldValue = this.getValue();
                super.subjectChanged();
                Object newValue = this.getValue();
                if (oldValue == newValue && newValue == null) {
                    this.fireAspectChange(Boolean.TRUE, newValue);
                }
            }
        };
    }

    private PropertyValueModel<String> buildUniqueStringHolder() {
        return new TransformationPropertyValueModel<Boolean, String>(this.buildUniqueHolder()){

            protected String transform(Boolean value) {
                Boolean defaultValue;
                if (ColumnComposite.this.subject() != null && value == null && (defaultValue = ((Column)ColumnComposite.this.subject()).getDefaultUnique()) != null) {
                    String defaultStringValue = defaultValue != false ? JptUiMappingsMessages.Boolean_True : JptUiMappingsMessages.Boolean_False;
                    return NLS.bind((String)JptUiMappingsMessages.ColumnComposite_uniqueWithDefault, (Object)defaultStringValue);
                }
                return JptUiMappingsMessages.ColumnComposite_unique;
            }
        };
    }

    private WritablePropertyValueModel<Boolean> buildUpdatableHolder() {
        return new PropertyAspectAdapter<Column, Boolean>(this.getSubjectHolder(), new String[]{"defaulUpdatableProperty", "specifiedUpdatableProperty"}){

            protected Boolean buildValue_() {
                return ((Column)this.subject).getSpecifiedUpdatable();
            }

            protected void setValue_(Boolean value) {
                ((Column)this.subject).setSpecifiedUpdatable(value);
            }

            protected void subjectChanged() {
                Object oldValue = this.getValue();
                super.subjectChanged();
                Object newValue = this.getValue();
                if (oldValue == newValue && newValue == null) {
                    this.fireAspectChange(Boolean.TRUE, newValue);
                }
            }
        };
    }

    private PropertyValueModel<String> buildUpdatableStringHolder() {
        return new TransformationPropertyValueModel<Boolean, String>(this.buildUpdatableHolder()){

            protected String transform(Boolean value) {
                Boolean defaultValue;
                if (ColumnComposite.this.subject() != null && value == null && (defaultValue = ((Column)ColumnComposite.this.subject()).getDefaultUpdatable()) != null) {
                    String defaultStringValue = defaultValue != false ? JptUiMappingsMessages.Boolean_True : JptUiMappingsMessages.Boolean_False;
                    return NLS.bind((String)JptUiMappingsMessages.ColumnComposite_updatableWithDefault, (Object)defaultStringValue);
                }
                return JptUiMappingsMessages.ColumnComposite_updatable;
            }
        };
    }

    private void initializeDetailsPane(Composite container) {
        this.buildTriStateCheckBoxWithDefault(this.buildSubPane(container, 4), JptUiMappingsMessages.ColumnComposite_insertable, this.buildInsertableHolder(), this.buildInsertableStringHolder(), "org.eclipse.jpt.ui.mapping_columnInsertable");
        this.buildTriStateCheckBoxWithDefault(container, JptUiMappingsMessages.ColumnComposite_updatable, this.buildUpdatableHolder(), this.buildUpdatableStringHolder(), "org.eclipse.jpt.ui.mapping_columnUpdatable");
        this.buildTriStateCheckBoxWithDefault(container, JptUiMappingsMessages.ColumnComposite_unique, this.buildUniqueHolder(), this.buildUniqueStringHolder(), "org.eclipse.jpt.ui.mapping_columnUnique");
        this.buildTriStateCheckBoxWithDefault(container, JptUiMappingsMessages.ColumnComposite_nullable, this.buildNullableHolder(), this.buildNullableStringHolder(), "org.eclipse.jpt.ui.mapping_columnNullable");
        Spinner lengthSpinner = this.buildLabeledSpinner(container, JptUiMappingsMessages.ColumnComposite_length, this.buildLengthHolder(), -1, -1, Integer.MAX_VALUE, this.buildDefaultLengthLabel(container), "org.eclipse.jpt.ui.mapping_columnLength");
        this.updateGridData(container, lengthSpinner);
        Spinner precisionSpinner = this.buildLabeledSpinner(container, JptUiMappingsMessages.ColumnComposite_precision, this.buildPrecisionHolder(), -1, -1, Integer.MAX_VALUE, this.buildDefaultPrecisionLabel(container), "org.eclipse.jpt.ui.mapping_columnPrecision");
        this.updateGridData(container, precisionSpinner);
        Spinner scaleSpinner = this.buildLabeledSpinner(container, JptUiMappingsMessages.ColumnComposite_scale, this.buildScaleHolder(), -1, -1, Integer.MAX_VALUE, this.buildDefaultScaleLabel(container), "org.eclipse.jpt.ui.mapping_columnScale");
        this.updateGridData(container, scaleSpinner);
        this.buildLabeledText(container, JptUiMappingsMessages.ColumnComposite_columnDefinition, this.buildColumnDefinitionHolder());
    }

    @Override
    protected void initializeLayout(Composite container) {
        container = this.buildTitledPane(container, JptUiMappingsMessages.ColumnComposite_columnSection);
        this.buildLabeledComposite(container, JptUiMappingsMessages.ColumnComposite_name, this.buildColumnCombo(container), "org.eclipse.jpt.ui.mapping_column");
        this.buildLabeledComposite(container, JptUiMappingsMessages.ColumnComposite_table, this.buildTableCombo(container), "org.eclipse.jpt.ui.mapping_columnTable");
        container = this.buildCollapsableSubSection(container, JptUiMappingsMessages.ColumnComposite_details, (PropertyValueModel<Boolean>)new SimplePropertyValueModel((Object)Boolean.FALSE));
        this.initializeDetailsPane(this.buildSubPane(container, 0, 16));
    }

    private void updateGridData(Composite container, Spinner spinner) {
        Composite paneContainer = spinner.getParent();
        while (container != paneContainer.getParent()) {
            paneContainer = paneContainer.getParent();
        }
        Control[] controls = paneContainer.getChildren();
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = false;
        gridData.horizontalAlignment = 1;
        controls[1].setLayoutData((Object)gridData);
        controls[2].setLayoutData((Object)new GridData(768));
        this.removeAlignRight(controls[2]);
    }
}

