/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.core.internal.validation.eclipse;

import java.io.InputStream;
import java.util.HashMap;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.xml.core.internal.validation.core.AbstractNestedValidator;
import org.eclipse.wst.xml.core.internal.validation.core.NestedValidatorContext;
import org.eclipse.wst.xml.core.internal.validation.core.ValidationMessage;
import org.eclipse.wst.xml.core.internal.validation.core.ValidationReport;
import org.eclipse.wst.xsd.core.internal.XSDCorePlugin;
import org.eclipse.wst.xsd.core.internal.validation.XSDValidationConfiguration;
import org.eclipse.wst.xsd.core.internal.validation.eclipse.XSDMessageInfoHelper;
import org.eclipse.wst.xsd.core.internal.validation.eclipse.XSDValidator;

public class Validator
extends AbstractNestedValidator {
    protected HashMap xsdConfigurations = new HashMap();
    static /* synthetic */ Class class$0;

    protected void setupValidation(NestedValidatorContext context) {
        XSDValidationConfiguration configuration = new XSDValidationConfiguration();
        boolean honourAllSchemaLocations = XSDCorePlugin.getDefault().getPluginPreferences().getBoolean("honourAllSchemaLocations");
        boolean fullSchemaConformance = XSDCorePlugin.getDefault().getPluginPreferences().getBoolean("fullSchemaConformance");
        try {
            configuration.setFeature(XSDValidationConfiguration.HONOUR_ALL_SCHEMA_LOCATIONS, honourAllSchemaLocations);
            configuration.setFeature(XSDValidationConfiguration.FULL_SCHEMA_CONFORMANCE, fullSchemaConformance);
        }
        catch (Exception exception) {}
        this.xsdConfigurations.put(context, configuration);
        super.setupValidation(context);
    }

    protected void teardownValidation(NestedValidatorContext context) {
        this.xsdConfigurations.remove(context);
        super.teardownValidation(context);
    }

    public ValidationReport validate(String uri, InputStream inputstream, NestedValidatorContext context) {
        XSDValidator validator = XSDValidator.getInstance();
        XSDValidationConfiguration configuration = (XSDValidationConfiguration)this.xsdConfigurations.get(context);
        ValidationReport valreport = null;
        valreport = validator.validate(uri, inputstream, configuration);
        return valreport;
    }

    protected void addInfoToMessage(ValidationMessage validationMessage, IMessage message) {
        String key = validationMessage.getKey();
        if (key != null) {
            XSDMessageInfoHelper messageInfoHelper = new XSDMessageInfoHelper();
            String[] messageInfo = messageInfoHelper.createMessageInfo(key, validationMessage.getMessage());
            message.setAttribute("columnNumber", (Object)new Integer(validationMessage.getColumnNumber()));
            message.setAttribute("squiggleSelectionStrategy", (Object)messageInfo[0]);
            message.setAttribute("squiggleNameOrValue", (Object)messageInfo[1]);
        }
    }

    protected String getValidatorID() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.xsd.core.internal.validation.eclipse.XSDDelegatingValidator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz.getName();
    }
}

