"use strict";
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
Object.defineProperty(exports, "__esModule", { value: true });
function configure(_proxyUrl, _strictSSL) {
}
exports.configure = configure;
async function xhr(options) {
    const requestHeaders = new Headers(options.headers || {});
    if (options.user && options.password) {
        requestHeaders.set('Authorization', 'Basic ' + btoa(options.user + ":" + options.password));
    }
    const requestInit = {
        method: options.type,
        redirect: options.followRedirects > 0 ? 'follow' : 'manual',
        mode: 'cors',
        headers: requestHeaders
    };
    const requestInfo = new Request(options.url, requestInit);
    const response = await fetch(requestInfo);
    const resposeHeaders = {};
    for (let name in response.headers) {
        resposeHeaders[name] = response.headers.get(name);
    }
    return {
        responseText: await response.text(),
        status: response.status,
        headers: resposeHeaders
    };
}
exports.xhr = xhr;
