/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.languageconfiguration.internal;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IMultiTextSelection;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.tm4e.languageconfiguration.internal.model.CharacterPair;
import org.eclipse.tm4e.languageconfiguration.internal.registry.LanguageConfigurationRegistryManager;
import org.eclipse.tm4e.languageconfiguration.internal.supports.CommentSupport;
import org.eclipse.tm4e.languageconfiguration.internal.utils.TextUtils;
import org.eclipse.tm4e.ui.internal.utils.ContentTypeHelper;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class ToggleLineCommentHandler
extends AbstractHandler {
    public static final String TOGGLE_LINE_COMMENT_COMMAND_ID = "org.eclipse.tm4e.languageconfiguration.toggleLineCommentCommand";
    public static final String ADD_BLOCK_COMMENT_COMMAND_ID = "org.eclipse.tm4e.languageconfiguration.addBlockCommentCommand";
    public static final String REMOVE_BLOCK_COMMENT_COMMAND_ID = "org.eclipse.tm4e.languageconfiguration.removeBlockCommentCommand";

    private static <T> @Nullable T adapt(@Nullable Object sourceObject, Class<T> adapter) {
        return (T)Adapters.adapt((Object)sourceObject, adapter);
    }

    public @Nullable Object execute(@Nullable ExecutionEvent event) throws ExecutionException {
        block36: {
            if (event == null) {
                return null;
            }
            IEditorPart part = HandlerUtil.getActiveEditor((ExecutionEvent)event);
            ITextEditor editor = ToggleLineCommentHandler.adapt(part, ITextEditor.class);
            if (editor == null) {
                return null;
            }
            ISelection selection = editor.getSelectionProvider().getSelection();
            if (!(selection instanceof ITextSelection var5_6)) break block36;
            IEditorInput input = editor.getEditorInput();
            IDocumentProvider docProvider = editor.getDocumentProvider();
            if (docProvider == null || input == null) {
                return null;
            }
            IDocument document = docProvider.getDocument((Object)input);
            if (document == null) {
                return null;
            }
            try {
                info = ContentTypeHelper.findContentTypes((IDocument)document);
                if (info == null) {
                    return null;
                }
            }
            catch (CoreException e) {
                return null;
            }
            IContentType[] contentTypes = info.getContentTypes();
            Command command = event.getCommand();
            CommentSupport commentSupport = this.getCommentSupport(contentTypes);
            if (commentSupport == null) {
                return null;
            }
            if (!this.isValid(commentSupport, command)) {
                return null;
            }
            IRewriteTarget target = ToggleLineCommentHandler.adapt(editor, IRewriteTarget.class);
            if (target != null) {
                target.beginCompoundChange();
            }
            try {
                try {
                    switch (command.getId()) {
                        case "org.eclipse.tm4e.languageconfiguration.toggleLineCommentCommand": {
                            String lineComment = commentSupport.getLineComment();
                            if (lineComment != null && !lineComment.isEmpty()) {
                                this.updateLineComment(document, (ITextSelection)textSelection, lineComment, editor);
                                break;
                            }
                            CharacterPair blockComment = commentSupport.getBlockComment();
                            if (blockComment != null) {
                                Set<Integer> lines = this.computeLines((ITextSelection)textSelection, document);
                                for (int line : lines) {
                                    int lineOffset = document.getLineOffset(line);
                                    int lineLength = document.getLineLength(line);
                                    TextSelection range = new TextSelection(lineOffset, line == document.getNumberOfLines() - 1 ? lineLength : lineLength - 1);
                                    this.toggleBlockComment(document, (ITextSelection)range, commentSupport, editor);
                                }
                            }
                            break;
                        }
                        case "org.eclipse.tm4e.languageconfiguration.addBlockCommentCommand": {
                            IRegion existingBlock = this.getBlockComment(document, (ITextSelection)textSelection, commentSupport);
                            CharacterPair blockComment = commentSupport.getBlockComment();
                            if (existingBlock != null && blockComment != null) {
                                this.addBlockComment(document, (ITextSelection)textSelection, blockComment, editor);
                            }
                            break;
                        }
                        case "org.eclipse.tm4e.languageconfiguration.removeBlockCommentCommand": {
                            IRegion existingBlock = this.getBlockComment(document, (ITextSelection)textSelection, commentSupport);
                            CharacterPair blockComment = commentSupport.getBlockComment();
                            if (existingBlock == null || blockComment == null) break;
                            this.removeBlockComment(document, (ITextSelection)textSelection, existingBlock, blockComment, editor);
                        }
                        default: {
                            break;
                        }
                    }
                }
                catch (BadLocationException badLocationException) {
                    if (target != null) {
                        target.endCompoundChange();
                    }
                }
            }
            finally {
                if (target != null) {
                    target.endCompoundChange();
                }
            }
        }
        return null;
    }

    private Set<Integer> computeLines(ITextSelection textSelection, IDocument document) throws BadLocationException {
        if (textSelection instanceof IMultiTextSelection var4_4) {
            v0 = multiSelection.getRegions();
        } else {
            IRegion[] iRegionArray = new IRegion[1];
            v0 = iRegionArray;
            iRegionArray[0] = new Region(textSelection.getOffset(), textSelection.getLength());
        }
        IRegion[] regions = v0;
        HashSet<Integer> lines = new HashSet<Integer>();
        IRegion[] iRegionArray = regions;
        int n = regions.length;
        int n2 = 0;
        while (n2 < n) {
            IRegion region = iRegionArray[n2];
            int lineFrom = document.getLineOfOffset(region.getOffset());
            int lineTo = document.getLineOfOffset(region.getOffset() + region.getLength());
            int line = lineFrom;
            while (line <= lineTo) {
                lines.add(line);
                ++line;
            }
            ++n2;
        }
        return lines;
    }

    private void toggleBlockComment(IDocument document, ITextSelection textSelection, CommentSupport commentSupport, ITextEditor editor) throws BadLocationException {
        IRegion existingBlock = this.getBlockComment(document, textSelection, commentSupport);
        CharacterPair blockComment = commentSupport.getBlockComment();
        if (blockComment == null) {
            return;
        }
        if (existingBlock == null) {
            this.addBlockComment(document, textSelection, blockComment, editor);
        } else {
            this.removeBlockComment(document, textSelection, existingBlock, blockComment, editor);
        }
    }

    private boolean isValid(CommentSupport commentSupport, Command command) {
        String lineComment = commentSupport.getLineComment();
        if (TOGGLE_LINE_COMMENT_COMMAND_ID.equals(command.getId()) && lineComment != null && !lineComment.isEmpty()) {
            return true;
        }
        CharacterPair blockComment = commentSupport.getBlockComment();
        return blockComment != null && !"".equals(blockComment.open) && !"".equals(blockComment.close);
    }

    private @Nullable CommentSupport getCommentSupport(IContentType[] contentTypes) {
        LanguageConfigurationRegistryManager registry = LanguageConfigurationRegistryManager.getInstance();
        IContentType[] iContentTypeArray = contentTypes;
        int n = contentTypes.length;
        int n2 = 0;
        while (n2 < n) {
            CommentSupport commentSupport;
            IContentType contentType = iContentTypeArray[n2];
            if (registry.shouldComment(contentType) && (commentSupport = registry.getCommentSupport(contentType)) != null) {
                return commentSupport;
            }
            ++n2;
        }
        return null;
    }

    private void updateLineComment(IDocument document, ITextSelection selection, String comment, ITextEditor editor) throws BadLocationException {
        if (this.areLinesCommented(document, selection, comment)) {
            this.removeLineComments(document, selection, comment, editor);
        } else {
            this.addLineComments(document, selection, comment, editor);
        }
    }

    private boolean areLinesCommented(IDocument document, ITextSelection selection, String comment) throws BadLocationException {
        int lineNumber = selection.getStartLine();
        while (lineNumber <= selection.getEndLine()) {
            IRegion lineRegion = document.getLineInformation(lineNumber);
            if (!document.get(lineRegion.getOffset(), lineRegion.getLength()).trim().startsWith(comment)) {
                return false;
            }
            ++lineNumber;
        }
        return true;
    }

    private @Nullable IRegion getBlockComment(IDocument document, ITextSelection selection, CommentSupport commentSupport) throws BadLocationException {
        if (selection.getText() == null) {
            return null;
        }
        CharacterPair blockComment = commentSupport.getBlockComment();
        if (blockComment == null) {
            return null;
        }
        String text = document.get();
        String open = blockComment.open;
        String close = blockComment.close;
        int selectionStart = selection.getOffset();
        int selectionEnd = selectionStart + selection.getLength();
        int openOffset = TextUtils.startIndexOfOffsetTouchingString(text, selectionStart, open);
        if (openOffset == -1 && ((openOffset = text.lastIndexOf(open, selectionStart)) == -1 || openOffset < document.getLineOffset(selection.getStartLine()))) {
            return null;
        }
        int closeOffset = TextUtils.startIndexOfOffsetTouchingString(text, selectionEnd, close);
        if (closeOffset == -1 || closeOffset < openOffset + open.length()) {
            closeOffset = text.indexOf(close, selectionEnd);
            IRegion endLineRegion = document.getLineInformation(document.getLineOfOffset(selectionEnd));
            if (openOffset == -1 || closeOffset < openOffset + open.length() || closeOffset > endLineRegion.getOffset() + endLineRegion.getLength()) {
                return null;
            }
        }
        int othercloseOffset = text.indexOf(close, openOffset + open.length());
        while (othercloseOffset != -1 && othercloseOffset < closeOffset) {
            int startOfLineOffset = document.getLineOffset(document.getLineOfOffset(othercloseOffset));
            if (commentSupport.getLineComment() != null && text.substring(startOfLineOffset, othercloseOffset).indexOf(commentSupport.getLineComment()) != -1) {
                return null;
            }
            othercloseOffset = text.indexOf(close, othercloseOffset + close.length());
        }
        return new Region(openOffset, closeOffset - openOffset);
    }

    private void removeLineComments(IDocument document, ITextSelection selection, String comment, ITextEditor editor) throws BadLocationException {
        int lineNumber = selection.getStartLine();
        int endLineNumber = selection.getEndLine();
        String oldText = document.get();
        int deletedChars = 0;
        boolean isStartBeforeComment = false;
        while (lineNumber <= endLineNumber) {
            int commentOffset = oldText.indexOf(comment, document.getLineOffset(lineNumber) + deletedChars);
            document.replace(commentOffset - deletedChars, comment.length(), "");
            if (deletedChars == 0) {
                boolean bl = isStartBeforeComment = commentOffset > selection.getOffset();
            }
            if (lineNumber != endLineNumber) {
                deletedChars += comment.length();
            }
            ++lineNumber;
        }
        TextSelection newSelection = new TextSelection(selection.getOffset() - (isStartBeforeComment ? 0 : comment.length()), selection.getLength() - deletedChars);
        editor.selectAndReveal(newSelection.getOffset(), newSelection.getLength());
    }

    private void addLineComments(IDocument document, ITextSelection selection, String comment, ITextEditor editor) throws BadLocationException {
        int insertedChars = 0;
        for (int lineNumber : this.computeLines(selection, document)) {
            document.replace(document.getLineOffset(lineNumber), 0, comment);
            insertedChars += comment.length();
        }
        TextSelection newSelection = new TextSelection(selection.getOffset() + comment.length(), selection.getLength() + insertedChars);
        editor.selectAndReveal(newSelection.getOffset(), newSelection.getLength());
    }

    private void removeBlockComment(IDocument document, ITextSelection selection, IRegion existingBlock, CharacterPair blockComment, ITextEditor editor) throws BadLocationException {
        int openOffset = existingBlock.getOffset();
        int openLength = blockComment.open.length();
        int closeOffset = existingBlock.getOffset() + existingBlock.getLength();
        int closeLength = blockComment.close.length();
        document.replace(openOffset, openLength, "");
        document.replace(closeOffset - openLength, closeLength, "");
        int offsetFix = openLength;
        int lengthFix = 0;
        if (selection.getOffset() < openOffset + openLength) {
            offsetFix = selection.getOffset() - openOffset;
            lengthFix = openLength - offsetFix;
        }
        if (selection.getOffset() + selection.getLength() > closeOffset) {
            lengthFix += selection.getOffset() + selection.getLength() - closeOffset;
        }
        TextSelection newSelection = new TextSelection(selection.getOffset() - offsetFix, selection.getLength() - lengthFix);
        editor.selectAndReveal(newSelection.getOffset(), newSelection.getLength());
    }

    private void addBlockComment(IDocument document, ITextSelection selection, CharacterPair blockComment, ITextEditor editor) throws BadLocationException {
        document.replace(selection.getOffset(), 0, blockComment.open);
        document.replace(selection.getOffset() + selection.getLength() + blockComment.open.length(), 0, blockComment.close);
        TextSelection newSelection = new TextSelection(selection.getOffset() + blockComment.close.length(), selection.getLength());
        editor.selectAndReveal(newSelection.getOffset(), newSelection.getLength());
    }
}

