/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.KnnVectorsReader;
import org.apache.lucene.codecs.NormsProducer;
import org.apache.lucene.codecs.PointsReader;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.codecs.TermVectorsReader;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.VectorValues;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.util.Bits;

public abstract class CodecReader
extends LeafReader {
    protected CodecReader() {
    }

    public abstract StoredFieldsReader getFieldsReader();

    public abstract TermVectorsReader getTermVectorsReader();

    public abstract NormsProducer getNormsReader();

    public abstract DocValuesProducer getDocValuesReader();

    public abstract FieldsProducer getPostingsReader();

    public abstract PointsReader getPointsReader();

    public abstract KnnVectorsReader getVectorReader();

    @Override
    public final void document(int docID, StoredFieldVisitor visitor) throws IOException {
        this.checkBounds(docID);
        this.getFieldsReader().visitDocument(docID, visitor);
    }

    @Override
    public final Fields getTermVectors(int docID) throws IOException {
        TermVectorsReader termVectorsReader = this.getTermVectorsReader();
        if (termVectorsReader == null) {
            return null;
        }
        this.checkBounds(docID);
        return termVectorsReader.get(docID);
    }

    private void checkBounds(int docID) {
        Objects.checkIndex(docID, this.maxDoc());
    }

    @Override
    public final Terms terms(String field) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (fi == null || fi.getIndexOptions() == IndexOptions.NONE) {
            return null;
        }
        return this.getPostingsReader().terms(field);
    }

    private FieldInfo getDVField(String field, DocValuesType type) {
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (fi == null) {
            return null;
        }
        if (fi.getDocValuesType() == DocValuesType.NONE) {
            return null;
        }
        if (fi.getDocValuesType() != type) {
            return null;
        }
        return fi;
    }

    @Override
    public final NumericDocValues getNumericDocValues(String field) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getDVField(field, DocValuesType.NUMERIC);
        if (fi == null) {
            return null;
        }
        return this.getDocValuesReader().getNumeric(fi);
    }

    @Override
    public final BinaryDocValues getBinaryDocValues(String field) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getDVField(field, DocValuesType.BINARY);
        if (fi == null) {
            return null;
        }
        return this.getDocValuesReader().getBinary(fi);
    }

    @Override
    public final SortedDocValues getSortedDocValues(String field) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getDVField(field, DocValuesType.SORTED);
        if (fi == null) {
            return null;
        }
        return this.getDocValuesReader().getSorted(fi);
    }

    @Override
    public final SortedNumericDocValues getSortedNumericDocValues(String field) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getDVField(field, DocValuesType.SORTED_NUMERIC);
        if (fi == null) {
            return null;
        }
        return this.getDocValuesReader().getSortedNumeric(fi);
    }

    @Override
    public final SortedSetDocValues getSortedSetDocValues(String field) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getDVField(field, DocValuesType.SORTED_SET);
        if (fi == null) {
            return null;
        }
        return this.getDocValuesReader().getSortedSet(fi);
    }

    @Override
    public final NumericDocValues getNormValues(String field) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (fi == null || !fi.hasNorms()) {
            return null;
        }
        return this.getNormsReader().getNorms(fi);
    }

    @Override
    public final PointValues getPointValues(String field) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (fi == null || fi.getPointDimensionCount() == 0) {
            return null;
        }
        return this.getPointsReader().getValues(field);
    }

    @Override
    public final VectorValues getVectorValues(String field) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (fi == null || fi.getVectorDimension() == 0) {
            return null;
        }
        return this.getVectorReader().getVectorValues(field);
    }

    @Override
    public final TopDocs searchNearestVectors(String field, float[] target, int k, Bits acceptDocs, int visitedLimit) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (fi == null || fi.getVectorDimension() == 0) {
            return null;
        }
        return this.getVectorReader().search(field, target, k, acceptDocs, visitedLimit);
    }

    @Override
    protected void doClose() throws IOException {
    }

    @Override
    public void checkIntegrity() throws IOException {
        this.ensureOpen();
        if (this.getPostingsReader() != null) {
            this.getPostingsReader().checkIntegrity();
        }
        if (this.getNormsReader() != null) {
            this.getNormsReader().checkIntegrity();
        }
        if (this.getDocValuesReader() != null) {
            this.getDocValuesReader().checkIntegrity();
        }
        if (this.getFieldsReader() != null) {
            this.getFieldsReader().checkIntegrity();
        }
        if (this.getTermVectorsReader() != null) {
            this.getTermVectorsReader().checkIntegrity();
        }
        if (this.getPointsReader() != null) {
            this.getPointsReader().checkIntegrity();
        }
        if (this.getVectorReader() != null) {
            this.getVectorReader().checkIntegrity();
        }
    }
}

