/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.xaml.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.xwt.tools.ui.xaml.XamlAttribute;
import org.eclipse.xwt.tools.ui.xaml.XamlElement;
import org.eclipse.xwt.tools.ui.xaml.XamlPackage;
import org.eclipse.xwt.tools.ui.xaml.impl.XamlNodeImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XamlElementImpl
extends XamlNodeImpl
implements XamlElement {
    protected XamlElementImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return XamlPackage.Literals.XAML_ELEMENT;
    }

    @Override
    public Node generate(Document document, Map<String, Object> options) {
        Element root;
        Attr prefixNode;
        if (document == null) {
            return null;
        }
        String prefix = this.getPrefix();
        if (prefix != null && (prefixNode = (root = document.getDocumentElement()).getAttributeNode(prefix)) == null) {
            root.setAttribute("xmlns:" + prefix, this.namespace);
            if (this.getOwnerDocument() != null) {
                this.getOwnerDocument().addDeclaredNamespace(prefix, this.namespace);
            }
        }
        String qualifiedName = prefix == null ? this.getName() : String.valueOf(prefix) + ":" + this.getName();
        String namespace = this.getNamespace();
        Element node = document.createElementNS(namespace, qualifiedName);
        for (XamlAttribute attribute : this.getAttributes()) {
            Node newAttr = attribute.generate(document, options);
            if (newAttr == null) continue;
            if (newAttr instanceof Attr) {
                node.setAttributeNode((Attr)newAttr);
                continue;
            }
            if (newAttr.getChildNodes().getLength() == 0 && newAttr.getAttributes().getLength() == 0) continue;
            node.appendChild(newAttr);
        }
        for (XamlElement child : this.getChildNodes()) {
            Node newChild = child.generate(document, options);
            if (newChild == null) continue;
            node.appendChild(newChild);
        }
        String value = this.getValue();
        if (value != null) {
            this.generateContent(document, node, value);
        }
        return node;
    }

    protected void generateContent(Document document, Node node, String value) {
        String content = this.getContent(node);
        if (this.equals(value, content)) {
            return;
        }
        String string = value = value == null ? "" : value;
        if (content != null) {
            List<Text> contentNodes = this.getContentNodes(node);
            for (Text text : contentNodes) {
                String nodeValue = text.getNodeValue();
                if (nodeValue == null || this.filter(nodeValue).length() == 0) continue;
                text.setData(value);
            }
        } else {
            Text textNode = document.createTextNode(value == null ? "" : value);
            node.appendChild(textNode);
        }
    }

    protected String getContent(Node parent) {
        List<Text> textNodes = this.getContentNodes(parent);
        if (textNodes.isEmpty()) {
            return null;
        }
        StringBuilder content = new StringBuilder();
        for (Text text : textNodes) {
            String value = text.getNodeValue();
            if (value == null || (value = this.filter(value)).length() == 0) continue;
            content.append(value);
        }
        return content.length() > 0 ? content.toString() : null;
    }

    protected List<Text> getContentNodes(Node node) {
        NodeList childNodes = node.getChildNodes();
        int length = childNodes.getLength();
        if (length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Text> contentTexts = new ArrayList<Text>();
        int i = 0;
        while (i < length) {
            Node item = childNodes.item(i);
            if (item.getNodeType() == 3) {
                contentTexts.add((Text)item);
            }
            ++i;
        }
        return contentTexts;
    }

    protected String filter(String value) {
        value = value.replace("\n", "");
        value = value.replace("\t", "");
        value = value.replace("\r", "");
        return value;
    }

    @Override
    public String getFlatValue() {
        StringBuilder result = new StringBuilder();
        String p = this.getPrefix();
        if (p != null) {
            result.append(p);
            result.append(":");
        }
        result.append(this.name);
        EList<XamlAttribute> attributes = this.getAttributes();
        EList<XamlElement> children = this.getChildNodes();
        if (!attributes.isEmpty()) {
            result.append(" ");
            int i = 0;
            while (i < attributes.size()) {
                String value;
                XamlAttribute attr = (XamlAttribute)attributes.get(i);
                result.append(attr.getName());
                result.append("=");
                String flatValue = attr.getFlatValue();
                if (flatValue == null) {
                    flatValue = "";
                }
                if ((value = flatValue.trim()).indexOf(" ") != -1) {
                    result.append("{" + value + "}");
                } else {
                    result.append(value);
                }
                if (i + 1 < attributes.size()) {
                    result.append(", ");
                }
                ++i;
            }
        } else if (!children.isEmpty()) {
            for (XamlElement child : children) {
                String flatValue = child.getFlatValue();
                if (flatValue == null) continue;
                result.append(" ");
                result.append(flatValue);
            }
        } else if (this.value != null) {
            result.append(" ");
            result.append(this.value);
        }
        return result.toString();
    }
}

