/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.commands;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.xwt.tools.ui.designer.commands.AddNewChildCommand;
import org.eclipse.xwt.tools.ui.designer.commands.ApplyAttributeSettingCommand;
import org.eclipse.xwt.tools.ui.designer.commands.DeleteCommand;
import org.eclipse.xwt.tools.ui.designer.commands.NamedCommand;
import org.eclipse.xwt.tools.ui.designer.loader.XWTProxy;
import org.eclipse.xwt.tools.ui.xaml.XamlAttribute;
import org.eclipse.xwt.tools.ui.xaml.XamlElement;
import org.eclipse.xwt.tools.ui.xaml.XamlFactory;
import org.eclipse.xwt.tools.ui.xaml.XamlNode;

public class FormDataCreateCommand
extends Command {
    private EditPart parent;
    private FormData formData;
    private Command command;
    private XamlNode forCreate;
    static int i = 0;
    private CompoundCommand commandList;

    public FormDataCreateCommand(EditPart parent, XamlNode forCreate, FormData formData) {
        this.parent = parent;
        this.forCreate = forCreate;
        this.formData = formData;
    }

    public boolean canExecute() {
        return this.parent != null && this.formData != null && this.forCreate != null;
    }

    public void execute() {
        ApplyAttributeSettingCommand command;
        XamlElement formDataChild;
        System.out.println(this.formData.toString());
        this.commandList = new CompoundCommand();
        XamlNode parentNode = (XamlNode)this.parent.getModel();
        XamlAttribute layoutDataAttr = this.forCreate.getAttribute("layoutData", "http://www.eclipse.org/xwt/presentation");
        if (layoutDataAttr == null) {
            layoutDataAttr = XamlFactory.eINSTANCE.createAttribute("layoutData", "http://www.eclipse.org/xwt/presentation");
        }
        if ((formDataChild = layoutDataAttr.getChild("FormData", "http://www.eclipse.org/xwt/presentation")) == null) {
            formDataChild = XamlFactory.eINSTANCE.createElement("FormData", "http://www.eclipse.org/xwt/presentation");
        }
        if (this.formData.width != -1) {
            command = new ApplyAttributeSettingCommand((XamlNode)formDataChild, "width", "http://www.eclipse.org/xwt/presentation", Integer.toString(this.formData.width));
            this.addCommand(command);
        }
        if (this.formData.height != -1) {
            command = new ApplyAttributeSettingCommand((XamlNode)formDataChild, "height", "http://www.eclipse.org/xwt/presentation", Integer.toString(this.formData.height));
            this.addCommand(command);
        }
        this.computeFormDataCommand((XamlNode)formDataChild, this.formData.left, "left");
        this.computeFormDataCommand((XamlNode)formDataChild, this.formData.top, "top");
        this.computeFormDataCommand((XamlNode)formDataChild, this.formData.right, "right");
        this.computeFormDataCommand((XamlNode)formDataChild, this.formData.bottom, "bottom");
        this.addNewChild((XamlNode)layoutDataAttr, (XamlNode)formDataChild);
        this.addNewChild(this.forCreate, (XamlNode)layoutDataAttr);
        this.addNewChild(parentNode, this.forCreate);
        this.command = this.commandList.unwrap();
        if (this.command.canExecute()) {
            this.command.execute();
        }
    }

    private void computeFormDataCommand(XamlNode formDataChild, FormAttachment formAttachment, String name) {
        XamlAttribute attachmentAttr = formDataChild.getAttribute(name, "http://www.eclipse.org/xwt/presentation");
        if (formAttachment != null) {
            if (attachmentAttr == null) {
                attachmentAttr = XamlFactory.eINSTANCE.createAttribute(name, "http://www.eclipse.org/xwt/presentation");
            }
            this.computeAttatchCommand(attachmentAttr, formAttachment);
            this.addNewChild(formDataChild, (XamlNode)attachmentAttr);
        } else if (attachmentAttr != null) {
            this.addCommand(new DeleteCommand((XamlNode)attachmentAttr));
        }
    }

    private void computeAttatchCommand(XamlAttribute parent, FormAttachment attachment) {
        Control control;
        XamlElement attachmentChild = parent.getChild("FormAttachment", "http://www.eclipse.org/xwt/presentation");
        if (attachmentChild == null) {
            attachmentChild = XamlFactory.eINSTANCE.createElement("FormAttachment", "http://www.eclipse.org/xwt/presentation");
        }
        if ((control = attachment.control) != null) {
            XamlElement bindChild;
            XamlAttribute controlAttr;
            String controlName = this.getName(control);
            if (controlName == null) {
                controlName = NamedCommand.generateName((Widget)control);
                this.addCommand(new NamedCommand((Widget)control, controlName));
            }
            if ((controlAttr = attachmentChild.getAttribute("control", "http://www.eclipse.org/xwt/presentation")) == null) {
                controlAttr = XamlFactory.eINSTANCE.createAttribute("control", "http://www.eclipse.org/xwt/presentation");
            }
            if ((bindChild = controlAttr.getChild("Binding", "http://www.eclipse.org/xwt/presentation")) == null) {
                bindChild = XamlFactory.eINSTANCE.createElement("Binding", "http://www.eclipse.org/xwt/presentation");
            }
            ApplyAttributeSettingCommand command = new ApplyAttributeSettingCommand((XamlNode)bindChild, "ElementName", "http://www.eclipse.org/xwt/presentation", controlName);
            this.addCommand(command);
            this.addNewChild((XamlNode)controlAttr, (XamlNode)bindChild);
            this.addNewChild((XamlNode)attachmentChild, (XamlNode)controlAttr);
            String alignment = "SWT.DEFAULT";
            switch (attachment.alignment) {
                case 128: {
                    alignment = "SWT.TOP";
                    break;
                }
                case 1024: {
                    alignment = "SWT.BOTTOM";
                    break;
                }
                case 131072: {
                    alignment = "SWT.RIGHT";
                    break;
                }
                case 0x1000000: {
                    alignment = "SWT.CENTER";
                    break;
                }
                case 16384: {
                    alignment = "SWT.LEFT";
                }
            }
            command = new ApplyAttributeSettingCommand((XamlNode)attachmentChild, "alignment", "http://www.eclipse.org/xwt/presentation", alignment);
            this.addCommand(command);
        } else {
            this.addCommand(new DeleteCommand((XamlNode)attachmentChild.getAttribute("control")));
        }
        ApplyAttributeSettingCommand command = new ApplyAttributeSettingCommand((XamlNode)attachmentChild, "denominator", "http://www.eclipse.org/xwt/presentation", Integer.toString(attachment.denominator));
        this.addCommand(command);
        command = new ApplyAttributeSettingCommand((XamlNode)attachmentChild, "numerator", "http://www.eclipse.org/xwt/presentation", Integer.toString(attachment.numerator));
        this.addCommand(command);
        command = new ApplyAttributeSettingCommand((XamlNode)attachmentChild, "offset", "http://www.eclipse.org/xwt/presentation", Integer.toString(attachment.offset));
        this.addCommand(command);
        this.addNewChild((XamlNode)parent, (XamlNode)attachmentChild);
    }

    private void addCommand(Command command) {
        if (command == null || !command.canExecute()) {
            return;
        }
        this.commandList.add(command);
    }

    private void addNewChild(XamlNode parent, XamlNode child) {
        if (child instanceof XamlAttribute && !parent.getAttributes().contains((Object)child)) {
            this.commandList.add((Command)new AddNewChildCommand(parent, child));
        } else if (child instanceof XamlElement && !parent.getChildNodes().contains((Object)child)) {
            this.commandList.add((Command)new AddNewChildCommand(parent, child));
        }
    }

    private String getName(Control control) {
        XamlNode model = XWTProxy.getModel(control);
        if (model == null) {
            return null;
        }
        XamlAttribute nameAttr = model.getAttribute("name", "http://www.eclipse.org/xwt/presentation");
        if (nameAttr == null) {
            nameAttr = model.getAttribute("name", "http://www.eclipse.org/xwt");
        }
        if (nameAttr != null) {
            return nameAttr.getValue();
        }
        return null;
    }

    public boolean canUndo() {
        return this.command != null && this.command.canUndo();
    }

    public void undo() {
        this.command.undo();
    }
}

