/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.parts;

import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.xwt.tools.ui.designer.loader.XWTProxy;
import org.eclipse.xwt.tools.ui.designer.parts.CompositeEditPart;
import org.eclipse.xwt.tools.ui.designer.policies.layout.TabFolderLayoutEditPolicy;
import org.eclipse.xwt.tools.ui.xaml.XamlNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TabFolderEditPart
extends CompositeEditPart {
    public TabFolderEditPart(Composite tabFolder, XamlNode model) {
        super(tabFolder, model);
    }

    @Override
    protected void collectExternalModels(List<Object> collector) {
        XamlNode data;
        super.collectExternalModels(collector);
        Control control = this.getActiveItemControl();
        if (control != null && !control.isDisposed() && (data = XWTProxy.getModel(control)) != null) {
            collector.add(data);
        }
    }

    public Control getActiveItemControl() {
        Item activeItem = this.getActiveItem();
        if (activeItem == null || activeItem.isDisposed()) {
            return null;
        }
        if (activeItem instanceof TabItem) {
            return ((TabItem)activeItem).getControl();
        }
        if (activeItem instanceof CTabItem) {
            return ((CTabItem)activeItem).getControl();
        }
        return null;
    }

    public Item getActiveItem() {
        Widget widget = this.getWidget();
        if (widget == null || widget.isDisposed()) {
            return null;
        }
        if (widget instanceof TabFolder) {
            TabItem[] selection = ((TabFolder)widget).getSelection();
            if (selection != null && selection.length > 0) {
                return selection[0];
            }
        } else if (widget instanceof CTabFolder) {
            CTabFolder folder = (CTabFolder)widget;
            CTabItem selection = folder.getSelection();
            if (selection != null) {
                return selection;
            }
            CTabItem[] items = folder.getItems();
            if (items != null && items.length > 0) {
                folder.setSelection(items[0]);
                return items[0];
            }
        }
        return null;
    }

    public EditPart getActiveItemPart() {
        Item tabItem = this.getActiveItem();
        if (tabItem == null) {
            return null;
        }
        XamlNode data = XWTProxy.getModel(tabItem);
        if (data != null) {
            return (EditPart)this.getViewer().getEditPartRegistry().get(data);
        }
        return null;
    }

    @Override
    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new TabFolderLayoutEditPolicy());
    }
}

