/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.properties;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.xwt.metadata.IProperty;
import org.eclipse.xwt.tools.ui.designer.core.properties.LabelProviderFactory;
import org.eclipse.xwt.tools.ui.designer.core.properties.editors.ArrayCellEditor;
import org.eclipse.xwt.tools.ui.designer.core.properties.editors.BooleanCellEditor;
import org.eclipse.xwt.tools.ui.designer.core.properties.editors.CharacterCellEditor;
import org.eclipse.xwt.tools.ui.designer.core.properties.editors.ColorCellEditor;
import org.eclipse.xwt.tools.ui.designer.core.properties.editors.FontCellEditor;
import org.eclipse.xwt.tools.ui.designer.core.properties.editors.ImageCellEditor;
import org.eclipse.xwt.tools.ui.designer.core.properties.editors.IntegerCellEditor;
import org.eclipse.xwt.tools.ui.designer.core.properties.editors.PointCellEditor;
import org.eclipse.xwt.tools.ui.designer.core.properties.editors.RectangleCellEditor;
import org.eclipse.xwt.tools.ui.designer.properties.PropertyContext;
import org.eclipse.xwt.tools.ui.designer.properties.TypedProperties;
import org.eclipse.xwt.tools.ui.designer.properties.editors.LayoutCellEditor;
import org.eclipse.xwt.tools.ui.designer.properties.editors.ObjectCellEditor;
import org.eclipse.xwt.tools.ui.designer.properties.editors.TextCellEditor;
import org.eclipse.xwt.tools.ui.designer.properties.editors.TypedPropertiesCellEditor;

public class XWTPropertyDescriptor
extends PropertyDescriptor {
    private PropertyContext fContext;

    public XWTPropertyDescriptor(PropertyContext fContext, IProperty id) {
        super((Object)id, id.getName());
        this.fContext = fContext;
        this.initLabelProvider(id);
    }

    private void initLabelProvider(IProperty property) {
        Class type = property.getType();
        String name = property.getName();
        ILabelProvider labelProvider = null;
        if (Integer.class == type || Integer.TYPE == type) {
            if (TypedProperties.getTypes().contains(name)) {
                labelProvider = TypedProperties.getLabelProvider(name);
            }
        } else {
            labelProvider = LabelProviderFactory.getLabelProvider((Class)property.getType());
        }
        this.setLabelProvider(labelProvider);
    }

    public CellEditor createPropertyEditor(Composite parent) {
        CellEditor editor = this.createCellEditor((IProperty)this.getId(), parent);
        if (editor != null && this.getValidator() != null) {
            editor.setValidator(this.getValidator());
        }
        return editor;
    }

    public CellEditor createCellEditor(IProperty property, Composite parent) {
        Class type = property.getType();
        String name = property.getName();
        Object editor = null;
        if (Color.class == type) {
            editor = new ColorCellEditor(parent);
        } else if (Font.class == type) {
            editor = new FontCellEditor(parent);
        } else if (Boolean.class == type || Boolean.TYPE == type) {
            editor = new BooleanCellEditor(parent);
        } else if (Image.class == type) {
            editor = new ImageCellEditor(parent);
        } else if (Point.class == type) {
            editor = new PointCellEditor(parent);
        } else if (Rectangle.class == type) {
            editor = new RectangleCellEditor(parent);
        } else if (Layout.class == type) {
            editor = new LayoutCellEditor(parent);
        } else if (Integer.class == type || Integer.TYPE == type) {
            editor = TypedProperties.getTypes().contains(name) ? new TypedPropertiesCellEditor(parent, name) : new IntegerCellEditor(parent);
        } else if (IContentProvider.class.isAssignableFrom(type) || ILabelProvider.class.isAssignableFrom(type)) {
            editor = new ObjectCellEditor(parent, type);
        } else {
            if (String.class == type) {
                return new TextCellEditor(this.fContext, property, parent);
            }
            if (Character.class == type || Character.TYPE == type) {
                return new CharacterCellEditor(parent);
            }
            if (String[].class == type) {
                return new ArrayCellEditor(parent);
            }
        }
        return editor;
    }
}

