/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.properties.tabbed.sections;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.xwt.XWTMaps;
import org.eclipse.xwt.converters.StringToColor;
import org.eclipse.xwt.tools.ui.designer.dialogs.ColorChooser;
import org.eclipse.xwt.tools.ui.designer.properties.tabbed.sections.AbstractAttributeSection;
import org.eclipse.xwt.utils.NamedColorsUtil;

public abstract class ColorSection
extends AbstractAttributeSection {
    private Button colorSelector;
    private CCombo swtColorsCombo;
    private CCombo namedColorsCombo;
    private Point fExtent;
    private Image fImage;
    private String colorStr = this.defaultColor();
    private Color fColor;

    protected Control createSection(Composite parent) {
        Composite control = this.getWidgetFactory().createComposite(parent);
        control.setLayout((Layout)new GridLayout(3, false));
        this.swtColorsCombo = this.getWidgetFactory().createCCombo(control, 8);
        GridData gridData = new GridData(768);
        gridData.widthHint = 100;
        this.swtColorsCombo.setLayoutData((Object)gridData);
        this.swtColorsCombo.setItems(XWTMaps.getColorKeys().toArray(new String[0]));
        this.swtColorsCombo.addListener(13, (Listener)this);
        this.namedColorsCombo = this.getWidgetFactory().createCCombo(control, 8);
        gridData = new GridData(768);
        gridData.widthHint = 100;
        this.namedColorsCombo.setLayoutData((Object)gridData);
        this.namedColorsCombo.setItems(NamedColorsUtil.getColorNames());
        this.namedColorsCombo.addListener(13, (Listener)this);
        this.colorSelector = this.getWidgetFactory().createButton(control, "", 0);
        this.fExtent = this.computeImageSize((Control)parent);
        this.fImage = new Image((Device)parent.getDisplay(), this.fExtent.x, this.fExtent.y);
        GC gc = new GC((Drawable)this.fImage);
        gc.setBackground(this.colorSelector.getBackground());
        gc.fillRectangle(0, 0, this.fExtent.x, this.fExtent.y);
        gc.dispose();
        this.colorSelector.setImage(this.fImage);
        this.colorSelector.addListener(13, (Listener)this);
        this.colorSelector.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                if (ColorSection.this.fImage != null) {
                    ColorSection.this.fImage.dispose();
                }
            }
        });
        return control;
    }

    protected void updateColorImage() {
        if (this.colorSelector == null || this.colorSelector.isDisposed()) {
            return;
        }
        Display display = this.colorSelector.getDisplay();
        if (this.fImage != null) {
            this.fImage.dispose();
        }
        this.fImage = new Image((Device)display, this.fExtent.x, this.fExtent.y);
        GC gc = new GC((Drawable)this.fImage);
        gc.setForeground(display.getSystemColor(2));
        gc.drawRectangle(0, 2, this.fExtent.x - 1, this.fExtent.y - 4);
        this.fColor = (Color)StringToColor.instance.convert((Object)this.colorStr);
        if (this.fColor != null && !this.fColor.isDisposed()) {
            gc.setBackground(this.fColor);
        }
        gc.fillRectangle(1, 3, this.fExtent.x - 2, this.fExtent.y - 5);
        gc.dispose();
        this.colorSelector.setImage(this.fImage);
    }

    public void doRefresh() {
        this.colorStr = this.getValue();
        if (this.colorStr == null) {
            this.colorStr = this.defaultColor();
            if (this.namedColorsCombo != null && !this.namedColorsCombo.isDisposed()) {
                this.namedColorsCombo.setText("");
            }
            if (this.swtColorsCombo != null && !this.swtColorsCombo.isDisposed()) {
                this.swtColorsCombo.setText("");
            }
        } else {
            if (this.swtColorsCombo != null && !this.swtColorsCombo.isDisposed() && this.swtColorsCombo.indexOf(this.colorStr) != -1) {
                this.swtColorsCombo.removeListener(13, (Listener)this);
                this.swtColorsCombo.select(this.swtColorsCombo.indexOf(this.colorStr));
                this.swtColorsCombo.addListener(13, (Listener)this);
                this.namedColorsCombo.setText("");
            }
            if (this.namedColorsCombo != null && !this.namedColorsCombo.isDisposed() && this.namedColorsCombo.indexOf(this.colorStr) != -1) {
                this.namedColorsCombo.removeListener(13, (Listener)this);
                this.namedColorsCombo.select(this.namedColorsCombo.indexOf(this.colorStr));
                this.namedColorsCombo.addListener(13, (Listener)this);
                this.swtColorsCombo.setText("");
            }
        }
        this.updateColorImage();
    }

    private Point computeImageSize(Control window) {
        GC gc = new GC((Drawable)window);
        Font f = JFaceResources.getFontRegistry().get("org.eclipse.jface.dialogfont");
        gc.setFont(f);
        int height = gc.getFontMetrics().getHeight();
        gc.dispose();
        Point p = new Point(height * 3 - 6, height);
        return p;
    }

    protected String getNewValue(Event event) {
        if (event.widget == this.colorSelector) {
            this.colorStr = this.chooseColor();
        } else if (event.widget == this.swtColorsCombo) {
            this.colorStr = this.swtColorsCombo.getItem(this.swtColorsCombo.getSelectionIndex());
            this.namedColorsCombo.setText("");
        } else if (event.widget == this.namedColorsCombo) {
            this.colorStr = this.namedColorsCombo.getItem(this.namedColorsCombo.getSelectionIndex());
            this.swtColorsCombo.setText("");
        }
        this.updateColorImage();
        return this.colorStr;
    }

    private String chooseColor() {
        ColorChooser chooser = new ColorChooser(new Shell(), this.colorStr);
        if (chooser.open() == 0) {
            return chooser.getColor();
        }
        return this.colorStr;
    }

    protected abstract String defaultColor();
}

