/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.providers;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.xwt.tools.ui.designer.providers.ColorLabelProvider;
import org.eclipse.xwt.tools.ui.designer.providers.FontLabelProvider;
import org.eclipse.xwt.tools.ui.designer.providers.LayoutLabelProvider;
import org.eclipse.xwt.tools.ui.designer.providers.PointLabelProvider;
import org.eclipse.xwt.tools.ui.designer.providers.RectangleLabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LabelProviderFactory {
    private static Map<Class<?>, ILabelProvider> cache = new HashMap();

    public static ILabelProvider getLabelProvider(Class<?> type) {
        ILabelProvider labelProvider = cache.get(type);
        if (labelProvider == null) {
            labelProvider = LabelProviderFactory.createLabelProvider(type);
            cache.put(type, labelProvider);
        }
        return labelProvider;
    }

    private static ILabelProvider createLabelProvider(Class<?> type) {
        if (Color.class == type) {
            return new ColorLabelProvider();
        }
        if (Font.class == type) {
            return new FontLabelProvider();
        }
        if (Rectangle.class == type) {
            return new RectangleLabelProvider();
        }
        if (Point.class == type) {
            return new PointLabelProvider();
        }
        if (Layout.class == type) {
            return new LayoutLabelProvider();
        }
        return new LabelProvider(){

            public String getText(Object element) {
                if (element.getClass().isArray()) {
                    return "[...]";
                }
                return super.getText(element);
            }
        };
    }
}

