/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.commands;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.xwt.metadata.IMetaclass;
import org.eclipse.xwt.tools.ui.designer.commands.AddNewChildCommand;
import org.eclipse.xwt.tools.ui.designer.commands.ApplyAttributeSettingCommand;
import org.eclipse.xwt.tools.ui.designer.core.util.StringUtil;
import org.eclipse.xwt.tools.ui.designer.core.util.swt.SWTTools;
import org.eclipse.xwt.tools.ui.designer.parts.ControlEditPart;
import org.eclipse.xwt.tools.ui.designer.utils.OffsetUtil;
import org.eclipse.xwt.tools.ui.designer.utils.XWTModelUtil;
import org.eclipse.xwt.tools.ui.designer.utils.XWTUtility;
import org.eclipse.xwt.tools.ui.xaml.XamlAttribute;
import org.eclipse.xwt.tools.ui.xaml.XamlFactory;
import org.eclipse.xwt.tools.ui.xaml.XamlNode;

public class ChangeConstraintCommand
extends Command {
    private EditPart editPart;
    private XamlNode model;
    private Rectangle constraint;
    private boolean transform;
    private CompoundCommand changeBoundCommand;

    public ChangeConstraintCommand(EditPart editPart, Rectangle constraint) {
        this(editPart, constraint, false);
    }

    public ChangeConstraintCommand(EditPart editPart, Rectangle constraint, boolean transform) {
        this.editPart = editPart;
        this.constraint = constraint;
        this.transform = transform;
    }

    ChangeConstraintCommand(XamlNode model, Rectangle constraint) {
        this((EditPart)null, constraint);
        this.model = model;
    }

    public boolean canExecute() {
        if (this.editPart != null) {
            this.model = (XamlNode)this.editPart.getModel();
        }
        return this.model != null;
    }

    private int getXOffset() {
        Control control;
        if (this.editPart == null) {
            return 0;
        }
        if (this.editPart instanceof ControlEditPart && (control = (Control)((ControlEditPart)this.editPart).getWidget()) != null) {
            Composite parent = control.getParent();
            if (parent instanceof Group) {
                return 0;
            }
            return SWTTools.getOffset((Scrollable)parent).x;
        }
        return OffsetUtil.getXOffset(this.editPart.getParent());
    }

    private int getYOffset() {
        Control control;
        if (this.editPart == null) {
            return 0;
        }
        if (this.editPart instanceof ControlEditPart && (control = (Control)((ControlEditPart)this.editPart).getWidget()) != null) {
            Composite parent = control.getParent();
            if (parent instanceof Group) {
                return 0;
            }
            return SWTTools.getOffset((Scrollable)parent).y;
        }
        return OffsetUtil.getYOffset(this.editPart.getParent());
    }

    public void execute() {
        IMetaclass metaclass = XWTUtility.getMetaclass(this.model);
        if (metaclass == null) {
            return;
        }
        this.changeBoundCommand = new CompoundCommand("Change Bounds");
        XamlAttribute bounds = XWTModelUtil.getChildAttribute(this.model, "bounds", "http://www.eclipse.org/xwt/presentation");
        XamlAttribute location = XWTModelUtil.getChildAttribute(this.model, "location", "http://www.eclipse.org/xwt/presentation");
        XamlAttribute size = XWTModelUtil.getChildAttribute(this.model, "size", "http://www.eclipse.org/xwt/presentation");
        XamlNode boundsParent = null;
        XamlNode locationParent = null;
        XamlNode sizeParent = null;
        Class type = metaclass.getType();
        if (Viewer.class.isAssignableFrom(type)) {
            XamlNode controlNode = null;
            if (bounds != null) {
                controlNode = boundsParent = (XamlNode)bounds.eContainer();
            }
            if (size != null) {
                controlNode = sizeParent = (XamlNode)size.eContainer();
            }
            if (location != null) {
                controlNode = locationParent = (XamlNode)location.eContainer();
            }
            if (controlNode == null) {
                controlNode = XamlFactory.eINSTANCE.createAttribute("control", "http://www.eclipse.org/xwt/presentation");
                this.changeBoundCommand.add((Command)new AddNewChildCommand(this.model, controlNode));
            }
            if (boundsParent == null) {
                boundsParent = controlNode;
            }
            if (sizeParent == null) {
                sizeParent = controlNode;
            }
            if (locationParent == null) {
                locationParent = controlNode;
            }
        } else {
            locationParent = sizeParent = this.model;
            boundsParent = sizeParent;
        }
        Rectangle r = this.constraint;
        if (this.transform) {
            r.x -= this.getXOffset();
            r.y -= this.getYOffset();
        }
        String boundsValue = StringUtil.format((Rectangle)r);
        String locationValue = StringUtil.format((Point)r.getLocation());
        String sizeValue = StringUtil.format((Dimension)r.getSize());
        Command createBounds = ApplyAttributeSettingCommand.createCommand(boundsParent, "bounds", "http://www.eclipse.org/xwt/presentation", boundsValue);
        Command createLocation = ApplyAttributeSettingCommand.createCommand(locationParent, "location", "http://www.eclipse.org/xwt/presentation", locationValue);
        Command createSize = ApplyAttributeSettingCommand.createCommand(sizeParent, "size", "http://www.eclipse.org/xwt/presentation", sizeValue);
        if (bounds == null) {
            if (location == null && size == null) {
                this.changeBoundCommand.add(createBounds);
            } else {
                this.changeBoundCommand.add(createSize);
                this.changeBoundCommand.add(createLocation);
            }
        } else {
            this.changeBoundCommand.add(createBounds);
            if (location != null) {
                this.changeBoundCommand.add(createLocation);
            }
            if (size != null) {
                this.changeBoundCommand.add(createSize);
            }
        }
        if (this.changeBoundCommand.canExecute()) {
            this.changeBoundCommand.execute();
        }
    }

    public void undo() {
        this.changeBoundCommand.undo();
    }

    public boolean canUndo() {
        return this.changeBoundCommand != null && this.changeBoundCommand.canUndo();
    }
}

