/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.properties.tabbed.sections;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.xwt.tools.ui.designer.core.util.DisplayUtil;
import org.eclipse.xwt.tools.ui.designer.editor.XWTDesigner;
import org.eclipse.xwt.tools.ui.designer.properties.tabbed.sections.AbstractAttributeSection;
import org.eclipse.xwt.tools.ui.designer.wizards.ExternalizeStringsWizard;
import org.eclipse.xwt.tools.ui.designer.wizards.models.TextValueEntry;
import org.eclipse.xwt.tools.ui.designer.wizards.models.TextValueModel;

public class TextSection
extends AbstractAttributeSection {
    protected TabbedPropertySheetPage tabbedPropertySheetPage;
    private Text textWidget;
    private Runnable delayRunnable;
    private long lastEvent = -1L;
    private boolean delayed = false;

    @Override
    protected void _createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super._createControls(parent, aTabbedPropertySheetPage);
        this.tabbedPropertySheetPage = aTabbedPropertySheetPage;
    }

    @Override
    protected Control createSection(Composite parent) {
        Composite control = this.getWidgetFactory().createComposite(parent);
        control.setLayout((Layout)new GridLayout(2, false));
        this.textWidget = this.getWidgetFactory().createText(control, "", 2048);
        this.textWidget.setLayoutData((Object)new GridData(768));
        this.textWidget.addListener(24, (Listener)this);
        return control;
    }

    private void externalizeText() {
        if (this.getValue() != null) {
            XWTDesigner designer = (XWTDesigner)this.getPart();
            TextValueModel textValueEntrys = new TextValueModel();
            textValueEntrys.add(new TextValueEntry(this.textWidget.getText(), "0"));
            ExternalizeStringsWizard wizard = new ExternalizeStringsWizard(textValueEntrys, designer);
            wizard.init(PlatformUI.getWorkbench(), null);
            WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
            dialog.open();
        } else {
            String dialogMessage = "No Strings to externalize found.";
            String[] dialogButtonLabels = new String[]{"Ok"};
            MessageDialog messageDialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Externalize Strings", null, dialogMessage, 2, dialogButtonLabels, 0);
            messageDialog.open();
        }
    }

    @Override
    public void doRefresh() {
        if (this.textWidget == null || this.textWidget.isDisposed() || this.textWidget.isFocusControl() || this.getAttribute() == null) {
            return;
        }
        this.textWidget.removeListener(24, (Listener)this);
        this.setTextValue(this.textWidget);
        this.textWidget.addListener(24, (Listener)this);
        this.refreshTitleBar();
    }

    @Override
    protected String getNewValue(Event event) {
        if (this.textWidget == null || this.textWidget.isDisposed()) {
            return null;
        }
        return this.textWidget.getText();
    }

    @Override
    protected String getAttributeName() {
        return "text";
    }

    private void refreshTitleBar() {
        DisplayUtil.asyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                if (TextSection.this.tabbedPropertySheetPage != null) {
                    TextSection.this.tabbedPropertySheetPage.labelProviderChanged(null);
                }
            }
        });
    }

    @Override
    public void handleEvent(final Event event) {
        if (!this.delayed) {
            if (this.delayRunnable == null) {
                this.delayRunnable = new Runnable(){

                    @Override
                    public void run() {
                        long current = System.currentTimeMillis();
                        if (current - TextSection.this.lastEvent < 300L) {
                            TextSection.this.lastEvent = current;
                            DisplayUtil.timerExec((Display)TextSection.this.display, (int)300, (Runnable)TextSection.this.delayRunnable);
                            return;
                        }
                        TextSection.super.handleEvent(event);
                        TextSection.this.refreshTitleBar();
                        TextSection.this.delayed = false;
                        TextSection.this.lastEvent = -1L;
                    }
                };
            }
            DisplayUtil.timerExec((Display)this.display, (int)300, (Runnable)this.delayRunnable);
            this.delayed = true;
        }
        this.lastEvent = System.currentTimeMillis();
    }
}

