/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.policies.feedback;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public class CrossFeedback
extends Figure {
    private static final int WIDTH = 50;
    private static final int HEIGHT = 50;
    private Point center;
    private Label tooltip = new Label();

    public CrossFeedback(Point center) {
        this.tooltip.setForegroundColor(ColorConstants.blue);
        this.setCenter(center);
        this.setLayoutManager((LayoutManager)new XYLayout());
        this.add((IFigure)this.tooltip);
    }

    public void setCenter(Point center) {
        this.center = center;
        Point l = center.getTranslated(-25, -25);
        this.setBounds(new Rectangle(l.x, l.y, 50, 50));
        this.tooltip.setBounds(new Rectangle(l.x, l.y, 50, 25));
        this.repaint();
    }

    public Point getCenter() {
        return this.center;
    }

    public void setTooltipText(String text) {
        if (text == null) {
            text = "";
        }
        this.tooltip.setText(text);
    }

    protected void paintFigure(Graphics graphics) {
        graphics.setLineStyle(3);
        graphics.setForegroundColor(ColorConstants.blue);
        int x = this.center.x;
        int y = this.center.y;
        Point p1 = new Point(x - 25, y);
        Point p2 = new Point(x + 25, this.center.y);
        graphics.drawLine(p1, p2);
        Point p3 = new Point(x, y - 25);
        Point p4 = new Point(x, y + 25);
        graphics.drawLine(p3, p4);
    }
}

