/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.editor.problems;

import java.util.List;
import org.eclipse.xwt.metadata.IMetaclass;
import org.eclipse.xwt.tools.ui.designer.core.problems.Problem;
import org.eclipse.xwt.tools.ui.designer.core.util.DomHelper;
import org.eclipse.xwt.tools.ui.designer.editor.problems.XWTAbstractNodeChecker;
import org.eclipse.xwt.tools.ui.designer.utils.XWTUtility;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XWTElementChecker
extends XWTAbstractNodeChecker {
    @Override
    protected void checkNode(Node node, List<Problem> problems) {
        IMetaclass metaclass;
        if (3 == node.getNodeType()) {
            return;
        }
        NodeList childNodes = node.getChildNodes();
        if (childNodes != null) {
            int i = 0;
            while (i < childNodes.getLength()) {
                this.checkNode(childNodes.item(i), problems);
                ++i;
            }
        }
        String nodeName = node.getNodeName();
        String prefix = node.getPrefix();
        String ns = DomHelper.lookupNamespaceURI((Node)node, (String)prefix);
        if (nodeName.indexOf(":") != -1) {
            nodeName = nodeName.substring(nodeName.indexOf(":") + 1);
        }
        if (nodeName.indexOf(".") != -1 || "Array".equals(nodeName)) {
            return;
        }
        if (node instanceof Element && (metaclass = XWTUtility.getMetaclass(nodeName, ns)) == null) {
            problems.add(this.createProblem(node, "\"" + nodeName + "\" can not be resolved to a Type.", 3));
        }
    }
}

