/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.ui.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMText;
import org.eclipse.wst.xml.ui.internal.XMLUIPlugin;
import org.eclipse.wst.xml.ui.internal.contentassist.AbstractContentAssistProcessor;
import org.eclipse.wst.xml.ui.internal.contentassist.ContentAssistRequest;
import org.eclipse.wst.xml.ui.internal.preferences.XMLUIPreferenceNames;
import org.eclipse.wst.xml.ui.internal.templates.TemplateContextTypeIdsXML;
import org.eclipse.xwt.XWT;
import org.eclipse.xwt.XWTMaps;
import org.eclipse.xwt.metadata.IEvent;
import org.eclipse.xwt.metadata.IMetaclass;
import org.eclipse.xwt.metadata.IProperty;
import org.eclipse.xwt.ui.utils.ImageManager;
import org.eclipse.xwt.utils.NamedColorsUtil;
import org.eclipse.xwt.utils.ResourceManager;
import org.eclipse.xwt.vex.contentassist.SelectionCompletionProposal;
import org.eclipse.xwt.vex.contentassist.VEXTemplateCompletionProcessor;
import org.eclipse.xwt.vex.dom.DomHelper;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XWTContentAssistProcessor
extends AbstractContentAssistProcessor
implements IPropertyChangeListener {
    static final String HANDLER_PREFIX = "on";
    static SelectionCompletionProposal[] booleanProposals;
    static SelectionCompletionProposal[] colorsProposals;
    static SelectionCompletionProposal[] stylesProposals;
    static SelectionCompletionProposal[] acceleratorsProposals;
    protected IPreferenceStore fPreferenceStore = null;
    protected IResource fResource = null;
    private VEXTemplateCompletionProcessor fTemplateProcessor = null;
    private List<String> fTemplateContexts = new ArrayList<String>();
    protected Comparator<ICompletionProposal> comparator = new Comparator<ICompletionProposal>(){

        @Override
        public int compare(ICompletionProposal o1, ICompletionProposal o2) {
            return o1.getDisplayString().compareTo(o2.getDisplayString());
        }
    };

    static SelectionCompletionProposal[] getBooleanProposals() {
        if (booleanProposals == null) {
            String[] values = new String[]{"True", "False"};
            Image image = ImageManager.get((String)"icons/full/obj16/attribute_obj.gif");
            booleanProposals = new SelectionCompletionProposal[values.length];
            int j = 0;
            while (j < values.length) {
                String pattern = "\"" + values[j] + "\"";
                XWTContentAssistProcessor.booleanProposals[j] = new SelectionCompletionProposal(pattern, 0, 0, 1, values[j].length(), image, values[j], null, null);
                ++j;
            }
        }
        return booleanProposals;
    }

    static SelectionCompletionProposal[] getColorsProposals() {
        if (colorsProposals == null) {
            Collection names = XWTMaps.getColorKeys();
            String[] colorNames = NamedColorsUtil.getColorNames();
            colorsProposals = new SelectionCompletionProposal[names.size() + colorNames.length];
            int i = 0;
            for (String colorStr : names) {
                Color color = ResourceManager.resources.getColor(colorStr);
                SelectionCompletionProposal p = XWTContentAssistProcessor.createColorProposal(color, colorStr);
                if (p == null) continue;
                XWTContentAssistProcessor.colorsProposals[i++] = p;
            }
            String[] stringArray = colorNames;
            int n = colorNames.length;
            int n2 = 0;
            while (n2 < n) {
                String colorName = stringArray[n2];
                Color color = ResourceManager.resources.getColor(colorName);
                SelectionCompletionProposal p = XWTContentAssistProcessor.createColorProposal(color, colorName);
                if (p != null) {
                    XWTContentAssistProcessor.colorsProposals[i++] = p;
                }
                ++n2;
            }
        }
        return colorsProposals;
    }

    static SelectionCompletionProposal createColorProposal(Color color, String colorName) {
        if (color != null) {
            String pattern = "\"" + colorName + "\"";
            Image image = new Image(null, 16, 16);
            GC gc = new GC((Drawable)image);
            gc.setBackground(color);
            gc.fillRectangle(0, 0, 16, 16);
            gc.dispose();
            return new SelectionCompletionProposal(pattern, 0, 0, 1, colorName.length(), image, colorName, null, null);
        }
        return null;
    }

    static SelectionCompletionProposal[] getStylesProposals() {
        if (stylesProposals == null) {
            Collection names = XWTMaps.getStyleKeys();
            stylesProposals = new SelectionCompletionProposal[names.size()];
            int i = 0;
            for (String string : names) {
                String pattern = "\"" + string + "\"";
                XWTContentAssistProcessor.stylesProposals[i++] = new SelectionCompletionProposal(pattern, 0, 0, 1, string.length(), null, string, null, null);
            }
        }
        return stylesProposals;
    }

    static SelectionCompletionProposal[] getAcceleratorsProposals() {
        if (acceleratorsProposals == null) {
            Collection names = XWTMaps.getAcceleratorKeys();
            acceleratorsProposals = new SelectionCompletionProposal[names.size()];
            int i = 0;
            for (String string : names) {
                String pattern = "\"" + string + "\"";
                XWTContentAssistProcessor.acceleratorsProposals[i++] = new SelectionCompletionProposal(pattern, 0, 0, 1, string.length(), null, string, null, null);
            }
        }
        return acceleratorsProposals;
    }

    protected void addAttributeNameProposals(ContentAssistRequest contentAssistRequest) {
        this.addXAMLPropertyNameProposals(contentAssistRequest);
        this.addTemplates(contentAssistRequest, TemplateContextTypeIdsXML.ATTRIBUTE);
        super.addAttributeNameProposals(contentAssistRequest);
    }

    /*
     * WARNING - void declaration
     */
    private void addXAMLPropertyNameProposals(ContentAssistRequest contentAssistRequest) {
        ArrayList<SelectionCompletionProposal> proposalCollector = new ArrayList<SelectionCompletionProposal>();
        ArrayList<SelectionCompletionProposal> macrosCollector = new ArrayList<SelectionCompletionProposal>();
        Node node = contentAssistRequest.getNode();
        String name = this.getNodeName(node);
        HashSet<String> existing = new HashSet<String>();
        NamedNodeMap namedNodeMap = node.getAttributes();
        int i = 0;
        while (i < namedNodeMap.getLength()) {
            Node attributeNode = namedNodeMap.item(i);
            String attributeName = attributeNode.getNodeName();
            existing.add(attributeName);
            ++i;
        }
        boolean useProposalList = !contentAssistRequest.shouldSeparate();
        int offset = contentAssistRequest.getReplacementBeginPosition();
        int replacementLength = contentAssistRequest.getReplacementLength();
        IDocument document = this.fTextViewer.getDocument();
        String prefixed = null;
        try {
            prefixed = document.get(offset, replacementLength).toLowerCase();
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        IMetaclass metaclass = XWT.getMetaclass((String)name, (String)DomHelper.lookupNamespaceURI((Node)node));
        if (metaclass != null) {
            IEvent[] events;
            void var16_23;
            IProperty[] properties;
            IProperty[] iPropertyArray = properties = metaclass.getProperties();
            int n = properties.length;
            boolean n2 = false;
            while (var16_23 < n) {
                IProperty property = iPropertyArray[var16_23];
                Class propertyType = property.getType();
                if (propertyType == null || !Control.class.isAssignableFrom(propertyType)) {
                    String propertyName = property.getName();
                    if ((prefixed == null || propertyName.toLowerCase().startsWith(prefixed)) && !existing.contains(propertyName)) {
                        String defaultValueString = "";
                        if (propertyName.equalsIgnoreCase("style")) {
                            propertyName = "x:style";
                            defaultValueString = "SWT.NONE";
                        }
                        String replacementString = String.valueOf(propertyName) + "=\"" + defaultValueString + "\" ";
                        Image image = JavaPluginImages.get((String)"org.eclipse.jdt.ui.field_public_obj.gif");
                        SelectionCompletionProposal proposal = new SelectionCompletionProposal(replacementString, offset, replacementLength, propertyName.length() + 2, defaultValueString.length(), image, propertyName, null, "Property: " + propertyName);
                        if (useProposalList) {
                            proposalCollector.add(proposal);
                        } else {
                            macrosCollector.add(proposal);
                        }
                    }
                }
                ++var16_23;
            }
            IEvent[] iEventArray = events = metaclass.getEvents();
            int n3 = events.length;
            n = 0;
            while (n < n3) {
                IEvent iEvent = iEventArray[n];
                String eventName = iEvent.getName();
                if (prefixed == null || eventName.toLowerCase().startsWith(prefixed)) {
                    eventName = String.valueOf(Character.toUpperCase(eventName.charAt(0))) + eventName.substring(1) + "Event";
                    if (iEvent.getName() != null && (iEvent.getName().equals("Loaded") || iEvent.getName().equals("LoadedEvent"))) {
                        eventName = "LoadedEvent";
                    }
                    if (!existing.contains(eventName)) {
                        String replacementString = String.valueOf(eventName) + "=\"" + HANDLER_PREFIX + eventName + "\" ";
                        Image image = ImageManager.get((String)ImageManager.IMG_EVENT);
                        SelectionCompletionProposal proposal = new SelectionCompletionProposal(replacementString, offset, replacementLength, eventName.length() + 2, eventName.length() + HANDLER_PREFIX.length(), image, eventName, null, "Event: " + eventName);
                        if (useProposalList) {
                            proposalCollector.add(proposal);
                        } else {
                            macrosCollector.add(proposal);
                        }
                    }
                }
                ++n;
            }
        }
        Node parentNode = node.getParentNode();
        String parentName = this.getNodeName(parentNode);
        try {
            IMetaclass iMetaclass = XWT.getMetaclass((String)parentName, (String)DomHelper.lookupNamespaceURI((Node)parentNode));
        }
        catch (Exception exception) {
            // empty catch block
        }
        Collections.sort(proposalCollector, this.comparator);
        Collections.sort(macrosCollector, this.comparator);
        for (ICompletionProposal iCompletionProposal : proposalCollector) {
            contentAssistRequest.addProposal(iCompletionProposal);
        }
        for (ICompletionProposal iCompletionProposal : macrosCollector) {
            contentAssistRequest.addMacro(iCompletionProposal);
        }
    }

    protected void addAttributeValueProposals(ContentAssistRequest contentAssistRequest) {
        this.addXAMLPropertyValueProposals(contentAssistRequest);
        this.addTemplates(contentAssistRequest, TemplateContextTypeIdsXML.ATTRIBUTE_VALUE);
        super.addAttributeValueProposals(contentAssistRequest);
    }

    /*
     * WARNING - void declaration
     */
    private void addXAMLPropertyValueProposals(ContentAssistRequest contentAssistRequest) {
        ArrayList<SelectionCompletionProposal> proposalCollector = new ArrayList<SelectionCompletionProposal>();
        ArrayList<SelectionCompletionProposal> macrosCollector = new ArrayList<SelectionCompletionProposal>();
        IDOMNode node = (IDOMNode)contentAssistRequest.getNode();
        String name = this.getNodeName((Node)node);
        IMetaclass metaclass = XWT.getMetaclass((String)name, (String)DomHelper.lookupNamespaceURI((Node)node));
        StyledText textWidget = this.fTextViewer.getTextWidget();
        if (metaclass != null) {
            IStructuredDocumentRegion iStructuredDocumentRegion = node.getFirstStructuredDocumentRegion();
            ITextRegionList openRegions = iStructuredDocumentRegion.getRegions();
            int m = openRegions.indexOf(contentAssistRequest.getRegion());
            if (m < 0) {
                return;
            }
            ITextRegion nameRegion = null;
            while (m >= 0) {
                if ((nameRegion = openRegions.get(m--)).getType() == "XML_TAG_ATTRIBUTE_NAME") break;
            }
            if (nameRegion != null) {
                CMElementDeclaration elementDecl = this.getCMElementDeclaration((Node)node);
                String attributeName = iStructuredDocumentRegion.getText(nameRegion);
                IProperty property = metaclass.findProperty(attributeName);
                if (attributeName.equalsIgnoreCase("x:style") || property != null) {
                    int offset = contentAssistRequest.getReplacementBeginPosition();
                    int replacementLength = contentAssistRequest.getReplacementLength();
                    boolean useProposalList = !contentAssistRequest.shouldSeparate();
                    String prefixed = null;
                    String prefixedQuote = "";
                    boolean fullValue = true;
                    try {
                        int caretIndex = textWidget.getCaretOffset();
                        IDocument iDocument = this.fTextViewer.getDocument();
                        prefixed = iDocument.get(offset, caretIndex - offset).toLowerCase();
                        if (prefixed.equals("\"\"")) {
                            prefixed = null;
                        }
                    }
                    catch (BadLocationException caretIndex) {
                        // empty catch block
                    }
                    if (prefixed != null) {
                        prefixedQuote = String.valueOf(prefixed) + "\"";
                        fullValue = false;
                    }
                    if (attributeName.equalsIgnoreCase("accelerator")) {
                        void var22_36;
                        SelectionCompletionProposal[] proposals = XWTContentAssistProcessor.getAcceleratorsProposals();
                        boolean bl = false;
                        while (var22_36 < proposals.length) {
                            Iterator pattern = proposals[var22_36].getReplacementString();
                            if (prefixed == null || (((String)((Object)pattern)).toLowerCase().startsWith(prefixed) || fullValue) && !prefixedQuote.equalsIgnoreCase((String)((Object)pattern))) {
                                proposals[var22_36].setReplacementOffset(offset);
                                proposals[var22_36].setReplacementLength(replacementLength);
                                if (useProposalList) {
                                    proposalCollector.add(proposals[var22_36]);
                                } else {
                                    macrosCollector.add(proposals[var22_36]);
                                }
                            }
                            ++var22_36;
                        }
                        Collections.sort(proposalCollector, this.comparator);
                        Collections.sort(macrosCollector, this.comparator);
                        for (ICompletionProposal iCompletionProposal : proposalCollector) {
                            contentAssistRequest.addProposal(iCompletionProposal);
                        }
                        for (ICompletionProposal iCompletionProposal : macrosCollector) {
                            contentAssistRequest.addMacro(iCompletionProposal);
                        }
                        return;
                    }
                    if (attributeName.equalsIgnoreCase("x:style")) {
                        void var22_40;
                        SelectionCompletionProposal[] proposals = XWTContentAssistProcessor.getStylesProposals();
                        boolean bl = false;
                        while (var22_40 < proposals.length) {
                            Iterator pattern = proposals[var22_40].getReplacementString();
                            if (prefixed == null || (((String)((Object)pattern)).toLowerCase().startsWith(prefixed) || fullValue) && !prefixedQuote.equalsIgnoreCase((String)((Object)pattern))) {
                                proposals[var22_40].setReplacementOffset(offset);
                                proposals[var22_40].setReplacementLength(replacementLength);
                                if (useProposalList) {
                                    proposalCollector.add(proposals[var22_40]);
                                } else {
                                    macrosCollector.add(proposals[var22_40]);
                                }
                            }
                            ++var22_40;
                        }
                        Collections.sort(proposalCollector, this.comparator);
                        Collections.sort(macrosCollector, this.comparator);
                        for (ICompletionProposal iCompletionProposal : proposalCollector) {
                            contentAssistRequest.addProposal(iCompletionProposal);
                        }
                        for (ICompletionProposal iCompletionProposal : macrosCollector) {
                            contentAssistRequest.addMacro(iCompletionProposal);
                        }
                        return;
                    }
                    Class javaType = property.getType();
                    if (javaType == Boolean.class || javaType == Boolean.TYPE) {
                        SelectionCompletionProposal[] selectionCompletionProposalArray = XWTContentAssistProcessor.getBooleanProposals();
                        int j = 0;
                        while (j < selectionCompletionProposalArray.length) {
                            String pattern = selectionCompletionProposalArray[j].getReplacementString();
                            if (prefixed == null || (pattern.toLowerCase().startsWith(prefixed) || fullValue) && !prefixedQuote.equalsIgnoreCase(pattern)) {
                                selectionCompletionProposalArray[j].setReplacementOffset(offset);
                                selectionCompletionProposalArray[j].setReplacementLength(replacementLength);
                                if (useProposalList) {
                                    proposalCollector.add(selectionCompletionProposalArray[j]);
                                } else {
                                    macrosCollector.add(selectionCompletionProposalArray[j]);
                                }
                            }
                            ++j;
                        }
                    } else if (javaType != null && javaType.isEnum()) {
                        T[] TArray = javaType.getEnumConstants();
                        IConverter converter = XWT.findConvertor((Class)javaType, String.class);
                        int j = 0;
                        while (j < TArray.length) {
                            String valueString = "";
                            if (converter != null) {
                                Object stringValue = converter.convert(TArray[j]);
                                if (stringValue != null) {
                                    valueString = stringValue.toString();
                                }
                            } else {
                                valueString = TArray[j].toString();
                            }
                            pattern = "\"" + valueString + "\"";
                            if (prefixed == null || (((String)pattern).toLowerCase().startsWith(prefixed) || fullValue) && !prefixedQuote.equalsIgnoreCase((String)pattern)) {
                                Image image = ImageManager.get((String)"icons/full/obj16/enum.gif");
                                proposal = new SelectionCompletionProposal((String)pattern, offset, replacementLength, 1, valueString.length(), image, valueString, null, null);
                                if (useProposalList) {
                                    proposalCollector.add(proposal);
                                } else {
                                    macrosCollector.add(proposal);
                                }
                            }
                            ++j;
                        }
                    } else if (javaType.isAssignableFrom(Color.class)) {
                        SelectionCompletionProposal[] selectionCompletionProposalArray = XWTContentAssistProcessor.getColorsProposals();
                        pattern = selectionCompletionProposalArray;
                        int valueString = selectionCompletionProposalArray.length;
                        int j = 0;
                        while (j < valueString) {
                            SelectionCompletionProposal proposal = pattern[j];
                            pattern = proposal.getReplacementString();
                            if (prefixed == null || (pattern.toLowerCase().startsWith(prefixed) || fullValue) && !prefixedQuote.equalsIgnoreCase(pattern)) {
                                proposal.setReplacementOffset(offset);
                                proposal.setReplacementLength(replacementLength);
                                if (useProposalList) {
                                    proposalCollector.add(proposal);
                                } else {
                                    macrosCollector.add(proposal);
                                }
                            }
                            ++j;
                        }
                    }
                } else {
                    IEvent[] allEvents = metaclass.getEvents();
                    JavaProject javaProject = (JavaProject)textWidget.getData("javaProject");
                    String className = (String)textWidget.getData("className");
                    List<String> javaMethods = this.getJavaMethods(javaProject, className);
                    int offset = contentAssistRequest.getReplacementBeginPosition();
                    int caretIndex = textWidget.getCaretOffset();
                    IDocument document = this.fTextViewer.getDocument();
                    Object var22_46 = null;
                    try {
                        String string = document.get(offset + 1, caretIndex - offset - 1);
                    }
                    catch (BadLocationException e) {
                        e.printStackTrace();
                    }
                    int replacementLength = contentAssistRequest.getReplacementLength();
                    boolean useProposalList = !contentAssistRequest.shouldSeparate();
                    for (String valueString : javaMethods) {
                        void var22_48;
                        if (valueString.equals(var22_48)) continue;
                        pattern = "\"" + valueString + "\"";
                        proposal = new SelectionCompletionProposal(pattern, offset, replacementLength, 1, valueString.length(), null, valueString, null, null);
                        if (useProposalList) {
                            proposalCollector.add(proposal);
                            continue;
                        }
                        macrosCollector.add(proposal);
                    }
                }
            }
        }
        Collections.sort(proposalCollector, this.comparator);
        Collections.sort(macrosCollector, this.comparator);
        for (ICompletionProposal iCompletionProposal : proposalCollector) {
            contentAssistRequest.addProposal(iCompletionProposal);
        }
        for (ICompletionProposal iCompletionProposal : macrosCollector) {
            contentAssistRequest.addMacro(iCompletionProposal);
        }
    }

    protected void addEmptyDocumentProposals(ContentAssistRequest contentAssistRequest) {
        this.addTemplates(contentAssistRequest, TemplateContextTypeIdsXML.NEW);
        super.addEmptyDocumentProposals(contentAssistRequest);
    }

    protected void addTagInsertionProposals(ContentAssistRequest contentAssistRequest, int childPosition) {
        this.addXAMLElementProposals(contentAssistRequest);
        this.addTemplates(contentAssistRequest, TemplateContextTypeIdsXML.TAG);
        super.addTagInsertionProposals(contentAssistRequest, childPosition);
    }

    private void addXAMLElementProposals(ContentAssistRequest contentAssistRequest) {
        SelectionCompletionProposal proposal4;
        SelectionCompletionProposal layoutProposal;
        String layout;
        ArrayList<SelectionCompletionProposal> proposalCollector = new ArrayList<SelectionCompletionProposal>();
        ArrayList<SelectionCompletionProposal> macrosCollector = new ArrayList<SelectionCompletionProposal>();
        ArrayList<String> addedTags = new ArrayList<String>();
        boolean useProposalList = !contentAssistRequest.shouldSeparate();
        int offset = contentAssistRequest.getReplacementBeginPosition();
        int replacementLength = contentAssistRequest.getReplacementLength();
        String prefixed = null;
        try {
            IDocument document = this.fTextViewer.getDocument();
            prefixed = document.get(offset, replacementLength).toLowerCase();
        }
        catch (BadLocationException document) {
            // empty catch block
        }
        Node node = contentAssistRequest.getNode();
        if (node == null) {
            return;
        }
        if (node instanceof IDOMText) {
            IDOMText text = (IDOMText)node;
            offset = text.getStartOffset();
            replacementLength = text.getLength();
            try {
                IDocument document = this.fTextViewer.getDocument();
                prefixed = document.get(offset, replacementLength).trim().toLowerCase();
            }
            catch (BadLocationException document) {}
        } else if (node instanceof IDOMNode) {
            IDOMNode domNode = (IDOMNode)node;
            NodeList children = domNode.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                Node node2 = children.item(i);
                if (node2 instanceof IDOMText) {
                    IDOMText text = (IDOMText)node2;
                    offset = text.getStartOffset();
                    replacementLength = text.getLength();
                    try {
                        IDocument document = this.fTextViewer.getDocument();
                        prefixed = document.get(offset, replacementLength).trim().toLowerCase();
                    }
                    catch (BadLocationException document) {}
                    break;
                }
                ++i;
            }
        }
        while (node.getNodeType() != 1) {
            if ((node = node.getParentNode()) != null) continue;
            return;
        }
        boolean containControls = false;
        String name = this.getNodeName(node);
        if (name.indexOf(".") != -1) {
            if (name.toLowerCase().endsWith(".control")) {
                name = "Control";
                containControls = true;
            } else {
                List<SelectionCompletionProposal> proposals = this.createPropertyNodeProposals(name, offset, replacementLength);
                if (useProposalList) {
                    proposalCollector.addAll(proposals);
                } else {
                    macrosCollector.addAll(proposals);
                }
                Collections.sort(proposalCollector, this.comparator);
                Collections.sort(macrosCollector, this.comparator);
                for (ICompletionProposal iCompletionProposal : proposalCollector) {
                    contentAssistRequest.addProposal(iCompletionProposal);
                }
                for (ICompletionProposal iCompletionProposal : macrosCollector) {
                    contentAssistRequest.addMacro(iCompletionProposal);
                }
                return;
            }
        }
        IMetaclass metaclass = XWT.getMetaclass((String)name, (String)DomHelper.lookupNamespaceURI((Node)node));
        String string = String.valueOf(name) + ".Resources";
        if (!addedTags.contains(string) && (prefixed == null || string.toLowerCase().startsWith(prefixed))) {
            addedTags.add(string);
            String pattern = "<" + string + "></" + string + ">";
            Image image = ImageManager.get((String)ImageManager.IMG_RESOURCES);
            SelectionCompletionProposal proposal = new SelectionCompletionProposal(pattern, offset, replacementLength, string.length() + 2, 0, image, string, null, "Element resources");
            if (useProposalList) {
                proposalCollector.add(proposal);
            } else {
                macrosCollector.add(proposal);
            }
        }
        if (!addedTags.contains(layout = String.valueOf(name) + ".layout") && (prefixed == null || layout.startsWith(prefixed)) && (layoutProposal = this.createLayoutProposal(metaclass, layout, offset, replacementLength)) != null) {
            if (useProposalList) {
                proposalCollector.add(layoutProposal);
            } else {
                macrosCollector.add(layoutProposal);
            }
        }
        String layoutData = String.valueOf(name) + ".layoutData";
        if (!addedTags.contains(layout) && (prefixed == null || layout.startsWith(prefixed)) && (proposal4 = this.createLayoutDataProposal(metaclass, layoutData, offset, replacementLength)) != null) {
            if (useProposalList) {
                proposalCollector.add(proposal4);
            } else {
                macrosCollector.add(proposal4);
            }
        }
        if (metaclass != null && (containControls || Composite.class.isAssignableFrom(metaclass.getType()))) {
            IMetaclass[] metaclasses;
            IMetaclass[] iMetaclassArray = metaclasses = XWT.getAllMetaclasses();
            int n = metaclasses.length;
            int n2 = 0;
            while (n2 < n) {
                IMetaclass type = iMetaclassArray[n2];
                if (Control.class.isAssignableFrom(type.getType()) && !type.isAbstract()) {
                    String typeName = type.getName();
                    if ((prefixed == null || typeName.toLowerCase().startsWith(prefixed)) && !addedTags.contains(typeName)) {
                        addedTags.add(typeName);
                        String pattern = "<" + typeName + "></" + typeName + ">";
                        Image image = ImageManager.get((String)ImageManager.IMG_ELEMENT);
                        SelectionCompletionProposal proposal3 = new SelectionCompletionProposal(pattern, offset, replacementLength, typeName.length() + 2, 0, image, typeName, null, null);
                        if (useProposalList) {
                            proposalCollector.add(proposal3);
                        } else {
                            macrosCollector.add(proposal3);
                        }
                    }
                }
                ++n2;
            }
        }
        Collections.sort(proposalCollector, this.comparator);
        Collections.sort(macrosCollector, this.comparator);
        for (SelectionCompletionProposal proposal : proposalCollector) {
            contentAssistRequest.addProposal((ICompletionProposal)proposal);
        }
        for (SelectionCompletionProposal proposal : macrosCollector) {
            contentAssistRequest.addMacro((ICompletionProposal)proposal);
        }
    }

    private List<SelectionCompletionProposal> createPropertyNodeProposals(String tagName, int offset, int replacementLength) {
        ArrayList<SelectionCompletionProposal> proposals;
        block4: {
            String property;
            block3: {
                int index = tagName.indexOf(".");
                if (index == -1) {
                    return Collections.emptyList();
                }
                proposals = new ArrayList<SelectionCompletionProposal>();
                property = tagName.substring(index + 1);
                if (!"layout".equalsIgnoreCase(property)) break block3;
                String[] layouts = new String[]{"GridLayout", "FillLayout", "RowLayout", "StackLayout", "FormLayout"};
                int i = 0;
                while (i < layouts.length) {
                    String pattern = "<" + layouts[i] + "/>";
                    Image image = ImageManager.get((String)ImageManager.IMG_ELEMENT);
                    SelectionCompletionProposal p = new SelectionCompletionProposal(pattern, offset, replacementLength, layouts[i].length() + 2, 0, image, layouts[i], null, "Container Layout.");
                    proposals.add(p);
                    ++i;
                }
                break block4;
            }
            if (!"layoutData".equalsIgnoreCase(property)) break block4;
            String[] layoutDatas = new String[]{"GridData", "StackData", "FormData", "RowData"};
            int i = 0;
            while (i < layoutDatas.length) {
                String pattern = "<" + layoutDatas[i] + "></" + layoutDatas[i] + ">";
                Image image = ImageManager.get((String)ImageManager.IMG_ELEMENT);
                SelectionCompletionProposal p = new SelectionCompletionProposal(pattern, offset, replacementLength, layoutDatas[i].length() + 2, 0, image, layoutDatas[i], null, "Container LayoutData.");
                proposals.add(p);
                ++i;
            }
        }
        return proposals;
    }

    private SelectionCompletionProposal createLayoutDataProposal(IMetaclass metaclass, String layoutData, int offset, int replacementLength) {
        if (!Control.class.isAssignableFrom(metaclass.getType())) {
            return null;
        }
        String pattern = "<" + layoutData + "></" + layoutData + ">";
        Image image = JavaPluginImages.get((String)"org.eclipse.jdt.ui.field_public_obj.gif");
        return new SelectionCompletionProposal(pattern, offset, replacementLength, layoutData.length() + 2, 0, image, layoutData, null, "Control LayoutData.");
    }

    private SelectionCompletionProposal createLayoutProposal(IMetaclass metaclass, String tagName, int offset, int replacementLength) {
        if (!Composite.class.isAssignableFrom(metaclass.getType())) {
            return null;
        }
        String pattern = "<" + tagName + "></" + tagName + ">";
        Image image = JavaPluginImages.get((String)"org.eclipse.jdt.ui.field_public_obj.gif");
        return new SelectionCompletionProposal(pattern, offset, replacementLength, tagName.length() + 2, 0, image, tagName, null, "Container Layout.");
    }

    private String getNodeName(Node node) {
        String name = node.getNodeName();
        int index = name.indexOf(":");
        if (index != -1) {
            name = name.substring(index + 1);
        }
        return name;
    }

    private void addTemplates(ContentAssistRequest contentAssistRequest, String context) {
        this.addTemplates(contentAssistRequest, context, contentAssistRequest.getReplacementBeginPosition());
    }

    private void addTemplates(ContentAssistRequest contentAssistRequest, String context, int startOffset) {
        if (contentAssistRequest == null) {
            return;
        }
        if (!this.fTemplateContexts.contains(context)) {
            boolean useProposalList;
            this.fTemplateContexts.add(context);
            boolean bl = useProposalList = !contentAssistRequest.shouldSeparate();
            if (this.getTemplateCompletionProcessor() != null) {
                this.getTemplateCompletionProcessor().setContextType(context);
                ICompletionProposal[] proposals = this.getTemplateCompletionProcessor().computeCompletionProposals(this.fTextViewer, startOffset);
                int i = 0;
                while (i < proposals.length) {
                    if (useProposalList) {
                        contentAssistRequest.addProposal(proposals[i]);
                    } else {
                        contentAssistRequest.addMacro(proposals[i]);
                    }
                    ++i;
                }
            }
        }
    }

    protected ContentAssistRequest computeCompletionProposals(int documentPosition, String matchString, ITextRegion completionRegion, IDOMNode treeNode, IDOMNode xmlnode) {
        ContentAssistRequest request = super.computeCompletionProposals(documentPosition, matchString, completionRegion, treeNode, xmlnode);
        this.addTemplates(request, TemplateContextTypeIdsXML.ALL, documentPosition);
        return request;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer textViewer, int documentPosition) {
        this.fTemplateContexts.clear();
        return super.computeCompletionProposals(textViewer, documentPosition);
    }

    protected IPreferenceStore getPreferenceStore() {
        if (this.fPreferenceStore == null) {
            this.fPreferenceStore = XMLUIPlugin.getDefault().getPreferenceStore();
        }
        return this.fPreferenceStore;
    }

    protected VEXTemplateCompletionProcessor getTemplateCompletionProcessor() {
        if (this.fTemplateProcessor == null) {
            this.fTemplateProcessor = new VEXTemplateCompletionProcessor();
        }
        return this.fTemplateProcessor;
    }

    protected void init() {
        this.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.reinit();
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (property.compareTo(XMLUIPreferenceNames.AUTO_PROPOSE) == 0 || property.compareTo(XMLUIPreferenceNames.AUTO_PROPOSE_CODE) == 0) {
            this.reinit();
        }
    }

    protected void reinit() {
        String key = XMLUIPreferenceNames.AUTO_PROPOSE;
        boolean doAuto = this.getPreferenceStore().getBoolean(key);
        if (doAuto) {
            key = XMLUIPreferenceNames.AUTO_PROPOSE_CODE;
            this.completionProposalAutoActivationCharacters = this.getPreferenceStore().getString(key).toCharArray();
        } else {
            this.completionProposalAutoActivationCharacters = null;
        }
    }

    public void release() {
        super.release();
        this.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    private List<String> getJavaMethods(JavaProject javaProject, String className) {
        ArrayList<String> javaMethods = new ArrayList<String>();
        try {
            IType type = javaProject.findType(className);
            IMethod[] methods = type.getMethods();
            int i = 0;
            while (i < methods.length) {
                IMethod method = methods[i];
                String methodName = method.getElementName();
                javaMethods.add(methodName);
                ++i;
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return javaMethods;
    }
}

