/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.contentassist;

import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

public class ContextInformationValidator
implements IContextInformationValidator {
    private int fDocumentPosition = -1;
    private IStructuredDocument fDocument = null;
    private IndexedRegion fRegion;

    public void install(IContextInformation info, ITextViewer viewer, int documentPosition) {
        this.fDocumentPosition = documentPosition;
        this.fDocument = (IStructuredDocument)viewer.getDocument();
    }

    public boolean isContextInformationValid(int documentPosition) {
        boolean result = false;
        this.calculateInstalledIndexedRegion();
        if (this.fRegion != null) {
            int start = this.fRegion.getStartOffset();
            int end = this.fRegion.getEndOffset();
            result = documentPosition < end && documentPosition > start + 1;
        }
        return result;
    }

    private void calculateInstalledIndexedRegion() {
        if (this.fRegion == null) {
            IStructuredModel model = null;
            try {
                model = StructuredModelManager.getModelManager().getModelForRead(this.fDocument);
                if (model != null) {
                    this.fRegion = model.getIndexedRegion(this.fDocumentPosition);
                }
            }
            finally {
                if (model != null) {
                    model.releaseFromRead();
                }
            }
        }
    }
}

