/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.commands;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.xwt.tools.ui.designer.commands.InsertCreateCommand;
import org.eclipse.xwt.tools.ui.designer.commands.LayoutCommandsFactory;
import org.eclipse.xwt.tools.ui.designer.commands.ResizeCommand;
import org.eclipse.xwt.tools.ui.xaml.XamlAttribute;
import org.eclipse.xwt.tools.ui.xaml.XamlElement;
import org.eclipse.xwt.tools.ui.xaml.XamlFactory;

public class RowLayoutCommandsFactory
extends LayoutCommandsFactory {
    public RowLayoutCommandsFactory(EditPart host) {
        super(host);
    }

    public Command getResizeChildCommand(Object newSize) {
        return new ResizeCommand(this.getHost(), (Dimension)newSize);
    }

    public Command getCreateCommand(CreateRequest createRequest, EditPart after) {
        return new InsertCreateCommand(this.getHost(), after, createRequest);
    }

    class ResizeChildCommand
    extends Command {
        private Object newSize;

        public ResizeChildCommand(Object newSize) {
            this.newSize = newSize;
        }

        public void execute() {
            EList attributes = RowLayoutCommandsFactory.this.getModel().getAttributes();
            XamlAttribute layoutDataAttr = RowLayoutCommandsFactory.this.getModel().getAttribute("layoutData");
            if (layoutDataAttr == null) {
                layoutDataAttr = XamlFactory.eINSTANCE.createAttribute("layoutData", "http://www.eclipse.org/xwt/presentation");
            }
            if (this.newSize instanceof Dimension) {
                XamlAttribute width;
                Dimension dimension = (Dimension)this.newSize;
                XamlElement attrElement = layoutDataAttr.getChild("RowData");
                if (attrElement == null) {
                    attrElement = XamlFactory.eINSTANCE.createElement("RowData", "http://www.eclipse.org/xwt/presentation");
                    layoutDataAttr.getChildNodes().add((Object)attrElement);
                }
                if ((width = attrElement.getAttribute("width")) == null) {
                    width = XamlFactory.eINSTANCE.createAttribute("width", "http://www.eclipse.org/xwt/presentation");
                    newvalue = this.getSize().width + dimension.width;
                    width.setValue("" + newvalue);
                    attrElement.getAttributes().add((Object)width);
                } else if (!Integer.toString(dimension.width).equals(width.getValue())) {
                    newvalue = Integer.parseInt(width.getValue()) + dimension.width;
                    width.setValue("" + newvalue);
                }
                XamlAttribute height = attrElement.getAttribute("height");
                if (height == null) {
                    height = XamlFactory.eINSTANCE.createAttribute("height", "http://www.eclipse.org/xwt/presentation");
                    int newvalue = this.getSize().height + dimension.height;
                    height.setValue("" + newvalue);
                    attrElement.getAttributes().add((Object)height);
                } else if (!Integer.toString(dimension.height).equals(height.getValue())) {
                    int newvalue = Integer.parseInt(height.getValue()) + dimension.height;
                    height.setValue("" + newvalue);
                }
            }
            if (!attributes.contains((Object)layoutDataAttr)) {
                attributes.add((Object)layoutDataAttr);
            }
        }

        public boolean canExecute() {
            return RowLayoutCommandsFactory.this.getModel() != null;
        }

        private Dimension getSize() {
            IFigure contentPane = ((GraphicalEditPart)RowLayoutCommandsFactory.this.getHost()).getContentPane();
            return contentPane.getSize();
        }
    }
}

