/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.dialogs;

import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.xwt.XWT;
import org.eclipse.xwt.metadata.IProperty;
import org.eclipse.xwt.tools.ui.designer.preference.Preferences;

public class PropertyValueDialog
extends TitleAreaDialog {
    private IProperty property;
    private String result;
    private String initialize;

    public PropertyValueDialog(Shell parentShell, IProperty property, String initializeValue) {
        super(parentShell);
        this.property = property;
        this.initialize = initializeValue;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("New Value Dialog");
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite control = new Composite(composite, 0);
        control.setLayoutData((Object)new GridData(1808));
        control.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(control, 0);
        if (this.property != null) {
            label.setText(this.property.getName() + ": ");
        } else {
            label.setText("New Value: ");
        }
        final Text text = new Text(control, 2048);
        if (this.initialize != null) {
            text.setText(this.initialize);
        }
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PropertyValueDialog.this.verify(text);
            }
        });
        this.verify(text);
        text.setLayoutData((Object)new GridData(768));
        this.setTitle("Input a New Value.");
        if (this.property != null) {
            this.setMessage("Give a new value for \"" + this.property.getName() + "\" property");
        }
        new Label(control, 0);
        new Label(control, 0);
        new Label(control, 0);
        final Button checkbutton = new Button(control, 32);
        checkbutton.setText("Do not ask again? You can change this from preference page.");
        checkbutton.setSelection(false);
        GridData griddata = new GridData(768);
        checkbutton.setLayoutData((Object)griddata);
        checkbutton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Preferences.getPreferenceStore().setValue("Prompt for widget name during creation.", !checkbutton.getSelection());
            }
        });
        return composite;
    }

    private void verify(Text text) {
        this.result = text.getText();
        boolean validate = true;
        if (this.result == null || this.result.equals("")) {
            this.setErrorMessage("Result is empty.");
            validate = false;
        } else if (this.property != null) {
            Class type = this.property.getType();
            if (type.isAssignableFrom(Integer.TYPE) && !this.isInt(this.result).booleanValue()) {
                this.setErrorMessage("Result is not a validate value,please input a interger.");
                validate = false;
            }
            if (!type.isAssignableFrom(this.result.getClass())) {
                IConverter c = XWT.findConvertor(String.class, (Class)type);
                if (c == null) {
                    this.setErrorMessage("This resilt is not applicable for the arguments (" + type.getSimpleName() + ")");
                    validate = false;
                } else {
                    Object newValue = c.convert((Object)this.result);
                    if (newValue == null) {
                        this.setErrorMessage("This resilt is not applicable for the arguments (" + type.getSimpleName() + ")");
                        validate = false;
                    }
                }
            }
        }
        if (validate) {
            this.setErrorMessage(null);
            this.setFinished(true);
        } else {
            this.setFinished(false);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.setFinished(this.initialize != null);
    }

    public String getResult() {
        return this.result;
    }

    public void setFinished(boolean flag) {
        Button okButton = this.getButton(0);
        if (okButton != null) {
            okButton.setEnabled(flag);
        }
    }

    public Boolean isInt(String s) {
        return s.matches("^[0-9]+$");
    }
}

