/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.wizards.contents;

import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.xwt.tools.ui.designer.wizards.models.TextValueEntry;
import org.eclipse.xwt.tools.ui.designer.wizards.models.TextValueModel;

public class SourceContents {
    private StringBuffer contents = new StringBuffer();
    private TextValueModel checkedItems;
    private String path;
    private String name;
    private String porpertyFileName;
    private String propertyFilePath;
    private StringBuffer historyContent;
    private String header = "/*******************************************************************************\r* Copyright (c) 2006, 2020 Soyatec (http://www.soyatec.com) and others.\r* All rights reserved. This program and the accompanying materials\r* are made available under the terms of the Eclipse Public License 2.0\r* which accompanies this distribution, and is available at\r* https://www.eclipse.org/legal/epl-2.0/\r* \r* SPDX-License-Identifier: EPL-2.0\r* \r* Contributors:\r*     Soyatec - initial API and implementation\r*******************************************************************************/";
    private String sourceKey;

    public SourceContents(TextValueModel checkedItems, String path, String propertyFilePath, String name, String porpertyFileName, StringBuffer historyContent, IPackageFragmentRoot root) {
        this.checkedItems = checkedItems;
        this.path = path;
        this.propertyFilePath = propertyFilePath;
        this.porpertyFileName = porpertyFileName;
        this.historyContent = historyContent;
        this.sourceKey = root.getResource().toString();
        if (name != null) {
            this.name = name.substring(0, name.length() - 5);
        }
    }

    public String getSourceContents() {
        if (this.historyContent == null) {
            String packagePath = this.getPackagePath(this.path);
            String porpertypackagePath = this.getPackagePath(this.propertyFilePath);
            this.contents.append(this.header);
            this.appendStr("");
            if (!"".equals(packagePath)) {
                this.appendStr("package " + packagePath + ";");
            }
            this.appendStr("");
            this.appendStr("import org.eclipse.osgi.util.NLS;");
            this.appendStr("");
            this.appendStr("public class " + this.name + " extends NLS {");
            if (!"".equals(packagePath)) {
                this.appendStr("\tprivate static final String BUNDLE_NAME = \"" + porpertypackagePath + "." + this.porpertyFileName + "\";");
            } else {
                this.appendStr("\tprivate static final String BUNDLE_NAME = \"" + this.porpertyFileName + "\";");
            }
            this.appendStr("");
        } else {
            this.contents.append(this.historyContent);
        }
        this.appendkeys();
        this.appendStr("\tstatic {");
        this.appendStr("\t\tNLS.initializeMessages(BUNDLE_NAME, " + this.name + ".class);");
        this.appendStr("\t}");
        this.appendStr("}");
        return this.contents.toString();
    }

    private String getPackagePath(String filePath) {
        String soureKey = this.sourceKey.substring(this.sourceKey.lastIndexOf("/") + 1);
        int index = filePath.indexOf("/" + soureKey + "/");
        String packagePath = "";
        if (index != -1) {
            packagePath = filePath.substring(index + soureKey.length() + 2).replace("/", ".");
        }
        return packagePath;
    }

    private void appendStr(String str) {
        this.contents.append(str + "\r");
    }

    private void appendkeys() {
        int itemsLen = this.checkedItems.elements().length;
        int i = 0;
        while (i < itemsLen) {
            if (this.checkedItems.elements()[i] instanceof TextValueEntry) {
                String key = ((TextValueEntry)this.checkedItems.elements()[i]).getKey();
                this.appendStr("\tpublic static String " + key + ";");
                this.appendStr("");
            }
            ++i;
        }
    }
}

