; FDSHIELD virus shield - by Eric Auer 2004 eric@coli.uni-sb.de
; To compile: http://nasm.sf.net/ "nasm -o fdshield.com fdshield.asm"

 ; FDSHIELD is free software; you can redistribute it and/or modify
 ; it under the terms of the GNU General Public License as published
 ; by the Free Software Foundation; either version 2 of the License,
 ; or (at your option) any later version.

 ; FDSHIELD is distributed in the hope that it will be useful,
 ; but WITHOUT ANY WARRANTY; without even the implied warranty of
 ; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ; GNU General Public License for more details.

 ; You should have received a copy of the GNU General Public License
 ; along with FDSHIELD; if not, write to the Free Software Foundation,
 ; Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 ; (or try http://www.gnu.org/licenses/licenses.html at www.gnu.org).


; History:
; 10jun2004 initial release
; 04jul2004 fixed int 2f.13 trick, added Windows detection


; If it tries to config "MS" VSAFE, it is probably a virus:
;      int 13.fa / 16.fa / 21.fa - the latter is also used by other
;      tools, so check for DX=5945 magic value as well there...?
;      All return DI=4559. AL=0 is only install check.
;      AL=0 returns DI=4559 BX=hotkey if loaded. AL=1 uninstalls.
;      AL=2 configures to "enabled methods BL", where bits are:
;      7 exeprot 6 fdbootprot 5 hdbootprot 4 bootprot 3 execheck
;      2 allwrprot 1 tsrwarn 0 hdformatblock. AL=3 ???. AL=4 get
;      hotkey flag. AL=5 set hotkey flag BL. AL=6/7 get/set network
;      drive scan flag. AL=8 ???. VSAFE/VWATCH comes with PC Tools
;      8+ and bundled with MS DOS 6.x ...


	; FDSHIELD feature flag definitions:

	; 1 (hd format block, always on in FDSHIELD)
%define TSRBLOCK  2	; halt system if program going TSR
%define WRITEHARD 4	; make harddisk / ramdisk (!?) writes fail
	; 8 (exe scan)
%define WRITEFLOP 8	; make floppy write fail  * != VSAFE *
	; WRITEHARD and WRITEFLOP together trigger the extra feature
	; "simulate readonly attribute for all files / dirs"...!
	; 16 (boot scan)
%define VERBOSE  16	; show more messages      * != VSAFE *
%define BOOTHARD 32	; make harddisk boot write fail
%define BOOTFLOP 64	; make floppy boot write fail
%define WRITEEXE 128	; make exe open always use readonly mode


; If it tries to config TBAV TBDRIVER, it is probably a virus:
;     int 2f.ca (also for TBSCANX by Frans Veldman)
;     Install check is AL=0 BX=5442 returns AL=-1 BX_or_2020
;     AL=1 returns version AH (22/2x/ca) state AL (0/1 off/on)
;     CX=number_of_signatures BX=emshandle_or_0 / in 2.3+ BX =
;     swapsegment_or_0 DX=EMS_XMS_handle_or_-1 (if swap=0, XMS)
;     AL=2 set state BL (0/1 off/on), AL=3 request RAM scan,
;     AL=4 request file scan
;     Careful: int 2f.cafe.bx=0 is THELP inst check, ret: seg BX!
;     Borland THELP also supports TesSeRact TSR management API at
;     int 2f.5453, but who cares...?


; FORMAT - suppress int 13.5 depending on msb of DL (set=harddisk)

; TSR - hang if int 27 / 21.31 are used (or certain IDT slots change)

; WRPROT - suppress int 13.3 / 13.43 / 40.3 / 26 / 21.7305.SI_odd
; ... maybe do int 21.43 returned CX / int 21.4e.ds[dx+15] /
;     int 21.4f.ds[dx+15] or_1 to create impression of all files
;     being readonly at least for get_attrib and find-first/-next?
;     Avoids DOS panic about disk errors. Should depend on DL value.


; Not yet planned: Signature scanning / checksums. Scan file on:
; exec (int 21.4b),
; exit (int 21.4c / 20),
; open (int 21.3d / 21.0f / 2f.1226). Scan on create/truncate, too?

; Change open mode to readonly on open seems to be useful, though.
; Avoids having to trap file writes elsewhere ;-).
; Otherwise: trap int 21.40, 21.15, 21.22 - 2f.122x can only read
; files anyway (!), used by NLSFUNC only.

; Boot / MBR scan on read - int 13.2 / 40.2 / 13.42 / 25 ...
;     also scan when program starts? and for each warmboot?
; Int 13 handler change: int 2f.13 - caller passes ds:dx new
;     handler and es:bx "int 13 handler for reboot", function
;     returns ds:dx, 1st: io.sys int 13, es:bx, 1st: bios int 13.
;     Initial ds:dx is as es:bx unless 01/10/84 BIOS... From RBIL:

; IO.SYS hooks INT 13 and inserts one or more filters ahead of the
; original INT 13 handler.  The first is for disk change detection
; on floppy drives, the second is for tracking formatting calls and
; correcting DMA boundary errors, the third is for working around
; problems in a particular version of IBM's ROM BIOS  [Win 3.1 init
; insists on DS changing when it calls this int 2f.13 to install a
; dummy handler during init... Viruses use int 2f.13 to find int 13]

; Other idea: Warn if chklist.* or smartchk.* deletion is attempted.
; Warn if something tunnels the shield. Store file checksums and boot
; sector checksums in XMS and DOS RAM respectively. Store virus list
; (signatures) for file and boot viruses in XMS.

; Maybe have faked VSHIELD / VSAFE / TBDRIVER code as a trap for
; patching viruses?
; VSHIELD: 80 fc 4b 74 62  80 fc 4c 74 33  80 fc 00 74 15
; VSHIELD: 80 fc 0e 74 06  80 fc 4b 74 09
; TBDRIVER: cli pushf cld (pushAX) pushBX (xchgAXBX) popAX sp--
;     sp-- popBX cmpAXBX(3bc3) (popBX) jzNotTunneled
; Shields hook: Int 13, 21, 40, 2f / 20, 27 / 9, 16
;     Better avoid hotkey hookers? Better tap int 21.1, con read
;     with echo, 21.6.dl=ff (con read), 21.7 (con read),
;     21.8 (con read) for that?

; Idea: Save int 10 vector at init to be sure to be able to TTY?
; Potential problem: We save oldints right before new handlers.
; This makes un-hooking unnecessary simple. But old DOS viruses
; never heard of FDSHIELD anyway.





	org 0x100
%define DEADBEEF	0xdeadbeef	; for "dd ?" for pointers

start:
flags:			; just let the config flags overwrite this
	jmp install

; ------------------------------------

old13	dd DEADBEEF
i13:	jmp far [cs:X13ptr]
%if 0
	pushf
	cli
	call far [cs:X13ptr]	; points to extra13 initially
	sti
	retf +2
%endif
	; The i13 -> extra13 is used for int 2f.13 compatibility:
	; programs can tell "DOS" (us) to use some other handler
	; instead of extra13 temporarily. In turn, we tell those
	; programs that the "real" handler would be extra13. So
	; when they try to bypass "DOS", they will still use our
	; extra13 handler (and bypass only our i13) ;-).

	; The normal way of doing things would be telling programs
	; that old13 is the real handler and allowing them to
	; change our stored old13 pointer. But then we would allow
	; them to really bypass us.

extra13:
	; hook: fa (vsafe), 5 (format), 3 (write), 43 (lbawrite)
	; [NOT YET: 2 (read), 42 (lbaread)
	call dummy_vshield
	call dummy_vshield2
	call tbdriver_tunnelcheck
	mov word [cs:stinkcode],0x13
	call vsafe_api

	mov word [cs:stinkptr],bootfmsg
	test dl,0x80	; floppy or harddisk?
	jz i13msgf
	mov word [cs:stinkptr],boothmsg

	cmp ah,5	; formatting harddisk?
	jnz i13msgf
	test byte [cs:flags],VERBOSE
	jz i13failfmt
	mov word [cs:stinkptr],formatmsg
	call WARNING
i13failfmt:
	jmp short i13fail	; format harddisk always fails

i13msgf:
	cmp ah,3	; write?
	jz i13write
	cmp ah,0x0b	; write long?
	jz i13write
	cmp ah,0x43	; LBA write?
	jz i13writelba

i13chain:
	jmp far [cs:old13]


i13write:		; CHS write
	test dl,0x80	; floppy or harddisk?
	jz bf_flag
	test byte [cs:flags],BOOTHARD
	jmp short bh_flag
bf_flag:
	test byte [cs:flags],BOOTFLOP
bh_flag:
	jz i13noboot
	cmp cx,1
	jnz i13noboot
	cmp dh,0
	jnz i13noboot
i13boot:
	test byte [cs:flags],VERBOSE
	jz i13fail
	call WARNING
i13fail:
	mov ax,0x0300	; write protected, 0 transferred
	stc
	retf +2		; as iret but preserves CY

i13noboot:
	mov word [cs:stinkptr],wrprotmsg
	test dl,0x80	; floppy or harddisk?
	jz wf_flag
	test byte [cs:flags],WRITEHARD
	jmp short wh_flag
wf_flag:
	test byte [cs:flags],WRITEFLOP
wh_flag:
	jz i13chain
	jmp short i13boot	; was: i13fail


i13writelba:		; LBA write
	mov word [cs:stinkptr],wrprotmsg
	test dl,0x80	; floppy or harddisk?
	jz bfl_flag
	test byte [cs:flags],BOOTHARD
	jmp short bhl_flag
bfl_flag:
	test byte [cs:flags],BOOTFLOP
bhl_flag:
	jz i13nobootl
	push ax
	xor ax,ax
	or ax,[ds:si+8]		; sector number low low
	or ax,[ds:si+10]	; sector number low
	or ax,[ds:si+12]	; sector number high
	or ax,[ds:si+14]	; sector number high high
	pop ax	
	jnz i13nobootl		; LBA sector number 0: boot sector
i13bootl:
	test byte [cs:flags],VERBOSE
	jz i13faill
	call WARNING
i13faill:
	jmp i13fail

i13nobootl:
	test dl,0x80	; floppy or harddisk?
	jz wfl_flag
	test byte [cs:flags],WRITEHARD
	jmp short whl_flag
wfl_flag:
	test byte [cs:flags],WRITEFLOP
whl_flag:
	jnz i13bootl		; was: i13faill
	jmp i13chain

; ------------------------------------

old16	dd DEADBEEF
i16:	; hook: fa (vsafe), ...
	call dummy_vshield
	call dummy_vshield2
	call tbdriver_tunnelcheck
	mov word [cs:stinkcode],0x16
	call vsafe_api

	jmp far [cs:old16]

; old19	dd DEADBEEF
; i19:	; hook? [NOT YET: (warmboot)]
; old20	dd DEADBEEF
; i20:	; hook? [NOT YET: (exit)]

; ------------------------------------

old21	dd DEADBEEF
i21:	; hook: fa (vsafe), 31 (TSR), 7305 (SI odd: write),
	;       43 (get attrib), 4e/4f (findfirst/findnext attr)
	;       3d (open), 0f (FCBopen)
	;       [NOT YET: 21.4b (exec), 21.4c (exit), file
	;       create/truncate (...) / write (40, 15, 22)... ]
	call dummy_vshield
	call dummy_vshield2
	call tbdriver_tunnelcheck
	mov word [cs:stinkcode],0x21
	call vsafe_api

	cmp ah,0x31	; TSR?
	jnz i21notsr
tsrallow:
	jmp short i21tsrfirst	; FIRST call to int 21.31: no penalty

	test byte [cs:flags],TSRBLOCK
	jnz i21tsrpanic
	test byte [cs:flags],VERBOSE
	jz i21tsrquiet
	mov word [cs:stinkptr],tsrmsg
	call WARNING
i21tsrquiet:

i21chain:
	jmp far [cs:old21]

i21tsrfirst:
	mov byte [cs:tsrallow+1],0	; LATER int 21.31 do count
	jmp short i21notsr

i21tsrpanic:
	jmp tsrpanic

i21notsr:
	push ax
	mov al,[cs:flags]	; all drives protected -> "all R/O"
	and al,WRITEHARD + WRITEFLOP
	cmp al,WRITEHARD + WRITEFLOP
	pop ax
	jnz i21noattrib
	cmp ax,0x4300	; get attrib?
	jnz i21noattrib43
	pushf
	cli
	call far [cs:old21]	; call original handler
	jc i21attrbug
	or cx,1		; pretend write protection being on
	clc
i21attrbug:
	retf +2		; like IRET but preserve carry flag

i21noattrib43:
	cmp ah,0x4e	; findfirst?
	jb i21noattrib
	cmp ah,0x4f	; findnext?
	ja i21noattrib
	pushf
	cli
	call far [cs:old21]	; call original handler
	jc i21attrbug

	push es
	push bx
	mov ah,0x2f	; get DTA address
	pushf
	cli
	call far [cs:old21]	; call original handler
	; * Data written to Disk Transfer Area - PSP:80 unless
	; * modified by 21.1a to be ds:dx ... 21.2f gets current
	; * DTA pointer to  ES:BX
	or byte [es:bx+0x15],1	; pretend write protection on
	pop bx
	pop es
	clc
	jmp short i21attrbug

i21noattrib:
	cmp ah,0x0f	; FCB open?
	jnz i21noopenf
	test byte [cs:flags],WRITEEXE
	jz i21noopen
	push ax
	push bx
	mov bx,dx		; DS:DX is the unopened FCB
	cmp byte [ds:bx],0xff	; ext FCB?
	jnz normfcb
	add bx,7		; ext FCB has 7 bytes extra "header"
normfcb:
	mov ax,[ds:bx+9]	; filename extension
	and ax,0xdfdf		; upcase
	mov bl,[ds:bx+11]
	and bl,0xdf
	call ifexe		; set CY if exe/com/sys
	pop bx
	pop ax
	jnc i21noopen
	mov al,0xff		; "file not found or access denied"
	iret			; (FCB open is always for read/write)

i21noopenf:
	cmp ah,0x3d		; handle open?
	jnz i21noopen
	test byte [cs:flags],WRITEEXE
	jz i21noopen
	push ax
	push bx
	mov bx,dx		; DS:DX is the unopened FCB
scanasciiz:
	mov al,[ds:bx]		; search end of ASCIIZ filename
	or al,al
	jz asciizopen
	inc bx
	jmp short scanasciiz
asciizopen:			; *** could conceivably crash if BX<4
	mov ax,[ds:bx-3]	; first 2 chars of extension
	cmp byte [ds:bx-4],"."	; is it an extension at all?
	mov bl,"*"
	jnz fakeext
	mov bl,[ds:bx-1]	; last char of extension
fakeext:
	call ifexe		; set CY if exe/com/sys
	pop bx
	pop ax
	jnc i21noopen
	mov ah,al		; manipulate open mode for EXE!
	and al,7
	cmp al,3		; DOS internal / EXEC case sensitive
	jz openmodeok
	cmp al,0		; read only
	jz openmodeok
	and ah,0xf8		; force open mode "read only"
openmodeok:
	mov al,ah		; the corrected mode
	mov ah,0x3d		; restore normal AH value

i21noopen:
	cmp ax,0x7305		; FAT32 disk I/O?
	jz i21disk
i21okay:
	jmp i21chain

i21disk:			; int 21.7305 FAT32 disk I/O
	test si,1		; write?
	jz i21okay		; no, only read!
	cmp cx,0xffff		; CX will be -1... > 32 MB
	jnz i21dwrprot		; fail for wrong CX
	cmp dl,2		; A: or B:?
	jb i21dflop
	mov word [cs:stinkptr],boothmsg
	test byte [cs:flags],BOOTHARD
	jnz i21dboot

i21dothersector:
	mov word [cs:stinkptr],wrprotmsg
	cmp dl,2		; A: or B:?
	jb i21dothflop
	test byte [cs:flags],WRITEHARD
	jnz i21dwrprot
	jmp short i21okay

i21dothflop:
	test byte [cs:flags],WRITEFLOP
	jz i21okay
i21dwrprot:
	test byte [cs:flags],VERBOSE
	jnz i21dwrprotquiet
	call WARNING
i21dwrprotquiet:
	mov ax,0x0300		; write protection error
	stc
	retf +2			; as iret but preserves CY

i21dflop:
	mov word [cs:stinkptr],bootfmsg
	test byte [cs:flags],BOOTFLOP
	jnz i21dboot
	jmp short i21dothersector

i21dboot:
	cmp word [ds:bx+2],0	; sector number high
	jnz i21dothersector
	cmp word [ds:bx],2	; sector number low: boot sector?
	jb i21dothersector
	test byte [cs:flags],VERBOSE
	jz i21dwrprot
	call WARNING
	jmp short i21dwrprot

ifexe:	and ax,0xdfdf		; upcase
	and bl,0xdf		; upcase
	cmp ax,"EX"
	jz no_ex
	cmp bl,"E"
	jz is_exe
no_exe:	clc			; no CY: no com/exe/sys
	ret
no_ex:	cmp ax,"CO"
	jnz no_co
	cmp bl,"M"
	jz is_exe
	jmp short no_exe
no_co:	cmp ax,"SY"
	jz no_exe
	cmp bl,"S"
	jnz no_exe
is_exe:	stc			; CY set: com, exe or sys
	ret

; old25	dd DEADBEEF
; i25:	; hook? [NOT YET: (read)]

; ------------------------------------

old26	dd DEADBEEF
i26:	; hook: (boot) write protection
	cmp al,2	; A: or B:?
	jb i26flop
i26hard:		; else harddisk (or ramdisk...!)
	test byte [cs:flags],BOOTHARD
	jz i26nhardboot
	mov word [cs:stinkptr],boothmsg
	call i26ifbootsec
	jc i26fail

i26nhardboot
	mov word [cs:stinkptr],wrprotmsg
	test byte [cs:flags],WRITEHARD
	jz i26chain

i26failwarn:
	call WARNING
i26fail:
	stc
	mov ax,0x0300 	; 3 write protected / 0 write protected
	retf		; not iret! "int" 26 is more like call far.

i26flop:
	test byte [cs:flags],BOOTFLOP
	jz i26nflopboot
	mov word [cs:stinkptr],bootfmsg
	call i26ifbootsec
	jc i26failwarn

i26nflopboot:
	mov word [cs:stinkptr],wrprotmsg
	test byte [cs:flags],WRITEFLOP
	jnz i26failwarn

i26chain:
	jmp far [cs:old26]

i26ifbootsec:		; returns CY set if boot sector
	cmp cx,0xffff
	jz i26huge
	cmp dx,2	; 0 highest 1 boot!?
	jb i26isboot
i26isnormal:
	clc
	ret

i26isboot:
	test byte [cs:flags],VERBOSE
	jz i26quietboot
	mov word [cs:stinkcode],0x26
	call WARNING
i26quietboot:
	stc
	ret

i26huge:
	cmp word [ds:bx+2],0	; sector number high
	jnz i26isnormal
	cmp word [ds:bx],2	; sector number low
	jb i26isboot
	jmp short i26isnormal

; ------------------------------------

old27	dd DEADBEEF
i27:	; hook: TSR protection (CS=PSPseg DX=sizebytes)
	mov word [cs:stinkcode],0x2700
	test byte [cs:flags],TSRBLOCK
	jnz tsrpanic
	test byte [cs:flags],VERBOSE
	jz tsrquiet
	mov word [cs:stinkptr],tsrmsg
	call WARNING
tsrquiet:
	jmp far [cs:old27]

tsrpanic:
	mov word [cs:stinkptr],tsrmsg
	jmp BIG_STINK

; ------------------------------------

old2f	dd DEADBEEF
i2f:	; hook: ca0x (tbav), 13 (int13 rehook)
	;       [NOT YET: 1226 (FCBopen for NLSFUNC)]
	cmp ah,0x13	; int 13 rehook??
	jz i2fi13rehook
	cmp ax,0xcafe	; THELP?
	jz i2fokay
	cmp ah,0xca	; TBSCANX / ...?
	jnz i2fokay
	mov word [cs:stinkcode],0x2f	; TBAV-API call detected
	cmp al,0	; install check?
	jnz i2ftbother
	cmp bx,0x5442	; magic?
	jnz i2fokay
	dec al		; return "TBSCANX installed"
	or bx,0x2020	; same
	test byte [cs:flags],VERBOSE
	jz i2ftbinst
	mov word [cs:stinkptr],tbavtmsg
	call WARNING
i2ftbinst:
	iret		; reply as if we were TBSCANX

i2ftbother:
	cmp al,2	; set enable status?
	jnz i2fokay
	test bl,1	; enable?
	jnz i2fokay
	mov word [cs:stinkptr],tbavmsg
	jmp BIG_STINK
	
i2fokay:
	jmp far [cs:old2f]

i2fi13rehook:		; replace i13-called-by-dos / reboot-i13 by
			; dsdx / esbx respectively, and return
			; previous dsdx / esbx values
	push word [cs:X13ptr]	; save previous values to be able
	pop word [cs:X13old]	; to return them below ...
	push word [cs:X13ptr+2]
	pop word [cs:X13old+2]
	push word [cs:R13ptr]
	pop word [cs:R13old]
	push word [cs:R13ptr+2]
	pop word [cs:R13old+2]

	mov [cs:X13ptr],dx	; store user handler as our "BIOS"
	mov [cs:X13ptr+2],ds	; handler which WE internally use...
	mov [cs:R13ptr],bx	; store user reboot handler
	mov [cs:R13ptr+2],es	; (only used by this int 2f.13 itself)

	test byte [cs:flags],VERBOSE
	jz i2fi13quiet
	push cx			; display ES by copying it to CX
	mov word [cs:stinkcode],ds
	mov cx,es		; ... and DS by using it as warning ID
	mov word [cs:stinkptr],i13rehookmsg
	call WARNING		; show message and AX, BX, CX and DX
	pop cx
i2fi13quiet:

			; To keep control, initial pointers will:
	lds dx,[cs:X13old]	; 1. tell caller about OUR extra handler
			; as "handler which DOS internally uses" ... and
	les bx,[cs:R13old]	; 2. claim that i13 handler for reboot
			; would be at f000:fff0 (or ffff:0) ... if somebody
			; tries to use it, he will trigger a reboot!
	iret

; ------------------------------------

R13old	dd DEADBEEF		; temp var
X13old	dd DEADBEEF		; temp var
R13ptr	dd 0xf000fff0		; "int 13 to be used by DOS at reboot"
X13ptr	dd DEADBEEF		; "int 13 to be used by DOS internally"
	; NORMAL values would be R: BIOS and X: BIOS or iosys-kludge.

; ------------------------------------

old40	dd DEADBEEF
i40:	; hook: 3 (write)
	cmp ah,3
	jz i40write
i40chain:
	jmp far [cs:old40]

i40write:
	mov word [cs:stinkcode],0x40
	mov word [cs:stinkptr],bootfmsg
	test byte [cs:flags],BOOTFLOP
	jz i40noboot
	cmp cx,1
	jnz i40noboot
	cmp dh,0
	jnz i40noboot
i40boot:
	test byte [cs:flags],VERBOSE
	jz i40fail
	call WARNING
i40fail:
	mov ax,0x0300	; write protected, 0 transferred
	stc
	retf +2		; as iret but preserves CY

i40noboot:
	mov word [cs:stinkptr],wrprotmsg
	test byte [cs:flags],WRITEFLOP
	jz i40chain
	jmp short i40boot	; was: i40fail

; ------------------------------------

vsafe_api:		; int (13/16/21).fa.5945 API of VSAFE
	pushf
	cmp ah,0xfa	; VSAFE / VWATCH?
	jnz notvsafe
	cmp dx,0x5945	; magic?
	jz isvsafe
notvsafe:
	popf
	ret

isvsafe:
	mov di,0x4559	; magic (returned by all functions!)
	cmp al,0	; install check?
	jnz vsafeother
	mov bx,0xffff	; no hotkey
	test byte [cs:flags],VERBOSE
	jz vsafeiquiet
	; stinkcode already set to current int number elsewhere
	mov word [cs:stinkptr],vsafetmsg
	call WARNING
vsafeiquiet:
	popf
	inc sp
	inc sp		; caller IP (instead of RET)
	clc
	retf +2		; not IRET (to original caller)

vsafefake2:
	mov ax,2
	jmp short vsafeiquiet

vsafeother:
	mov word [cs:stinkptr],vsafemsg
	cmp al,2	; get/set options?
	ja vsafeother2
vsafestink:
	jmp BIG_STINK	; 1 uninstall attempt / 2 get+set options

vsafeother2:
	cmp al,4
	ja vsafeother3
	jb vsafefake2
	mov bl,1	; "hotkey disabled"
	jmp short vsafeiquiet

vsafeother3:
	cmp al,6
	jb vsafeiquiet	; "set hotkey disable flag" is ignored
	ja vsafeother4
	mov bl,0xff	; "we check network drives" (VSAFE 2 default)
	jmp short vsafeiquiet	; (some CL can be returned, too)

vsafenetset:
	cmp bl,0	; trying to disable net check?
	jz vsafestink
	jmp short vsafeiquiet

vsafeother4:
	cmp al,8
	jb vsafenetset
	ja notvsafe
	mov ax,2
	mov bx,0x200	; return "version 2.00"
	jmp short vsafeiquiet

; ------------------------------------

dummy_vshield:
	pushf
	push ax
	mov ah,42
	db 0x80, 0xfc, 0x4b, 0x74, 0x62
	db 0x80, 0xfc, 0x4c, 0x74, 0x33
	db 0x80, 0xfc, 0x00, 0x74, 0x15
dummy_vshield_end:
	push si
	push cx
	mov si,dummy_vshield
	mov cx,dummy_vshield_end-dummy_vshield
	call checksum
	xor ax,[cs:dummy_vshield_sum]
	jz vs_not_patched

	mov word [cs:stinkptr],patchvmsg
	mov word [cs:stinkcode],1
	jmp BIG_STINK

vs_not_patched:
	pop cx
	pop si
	pop ax
	popf
	ret

; ------------------------------------

dummy_vshield2:
	pushf
	push ax
	mov ah,42
	db 0x80, 0xfc, 0x0e, 0x74, 0x06
	db 0x80, 0xfc, 0x4b, 0x74, 0x09
dummy_vshield2_end:
	push si
	push cx
	mov si,dummy_vshield2
	mov cx,dummy_vshield2_end-dummy_vshield2
	call checksum
	xor ax,[cs:dummy_vshield2_sum]
	jz vs2_not_patched

	mov word [cs:stinkptr],patchvmsg
	mov word [cs:stinkcode],2
	jmp BIG_STINK

vs2_not_patched:
	pop cx
	pop si
	pop ax
	popf
	ret

; ------------------------------------

tbdriver_tunnelcheck:	; mostly the same code as in tbdriver, but
	pushf		; we also do a checksum on this code ;-)
	push bx		; save BX

	cli		; (just cloning TBDRIVER here)
	pushf		; (not really needed)
	cld		; (not really needed)

		; ( TBDISK does "test by cs:[16],1 / jnz +1d" now )

			; <<< start of exactly TBDRIVER equivalent code
	push ax		; save AX
	push bx		; push BX
	xchg ax,bx	; (not needed either!?)
	pop ax		; pop BX first time, as AX
	dec sp
	dec sp
	pop bx		; pop same value BX a second time!
	cmp ax,bx	; (tbdriver uses 0x3b 0xc3 here)
	pop bx		; restore (was AX, so we need the XCHG below)
			; <<< end of TBDRIVER equivalent code

	jz tb_not_tunneled	; 74 0e in TBDISK case
tbdriver_tunnelcheck_end:

	mov word [cs:stinkptr],tunnelmsg
	mov word [cs:stinkcode],0
	jmp BIG_STINK

tb_not_tunneled:
	xchg ax,bx	; back with the real AX
	popf		; restore (matches the extra pushf above)
	pop bx		; restore bx

	push ax
	push si
	push cx
	mov si,tbdriver_tunnelcheck
	mov cx,tbdriver_tunnelcheck_end-tbdriver_tunnelcheck
	call checksum
	xor ax,[cs:tbdriver_tunnelcheck_sum]
	jz tb_not_patched

	mov word [cs:stinkptr],patchtmsg
	mov word [cs:stinkcode],ax
	jmp BIG_STINK

tb_not_patched:
	pop cx
	pop si
	pop ax

	popf		; restore flags
	ret

; ------------------------------------

checksum:		; create checksum for cs:si len cx in ax
	dec cx		; destroys SI and CX
	xor ax,ax
checksum_loop:
	xor ax,[cs:si]
	add ax,0xcafe
	inc si
	loop checksum_loop
	ret

dummy_vshield_sum		dw 0xf001	; anything
dummy_vshield2_sum		dw 0xc001	; anything
tbdriver_tunnelcheck_sum	dw 0xbeef	; anything

; ------------------------------------
; ------------------------------------

BIG_STINK:	; display message and register dump and halt system

	push ax
	mov ax,3	; 80x25 text mode
	int 0x10	; *** better use stored int 0x10 pointer!
	mov ax,0x0500	; select first page
	int 0x10	; same... (for all int 0x10 calls)
	pop ax

	mov si,stinkmsg
	call strtty
	push ax
	mov ax,[cs:stinkcode]
	call hexdump
	mov al,' '
	call tty
	pop ax
	mov si,[cs:stinkptr]
	call strtty

	call regdump

	test byte [cs:flags],VERBOSE
	jnz delay_reboot

dead_end:
	cli			; give viruses less chances
	hlt			; only NMI can leave this
	jmp short dead_end	; only RESET can leave this

delay_reboot:
	mov si,rebootmsg
	call strtty
	mov ax,0x40
	mov ds,ax
	mov cx,18*20
waitcount:
	mov ax,[ds:0x6c]
	sti		; could help viruses!
waitloop:
	hlt
	cmp [ds:0x6c],ax
	jz waitloop
	loop waitcount

	mov al,0xfe	; do a very hard keyboard controller reboot
	out 0x64,al	; bye bye virus
	db 0xea, 0, 0, 0xff, 0xff	; JMP far 0xffff:0 (reboot)
	; mov sp,0xffff	; enjoy the GPF
	; pop ax	; go for it :-P

; ------------------------------------

WARNING:	; display message for suspicious activity, but 
		; only in verbose mode as viruses might see it!
	pushf
	push si
	mov si,infomsg
	call strtty
	pop si
	push ax
	mov ax,[cs:stinkcode]
	call hexdump
	mov al,' '
	call tty
	pop ax
	push si
	mov si,[cs:stinkptr]
	call strtty
	pop si
	call regdump
	popf
	ret

; ------------------------------------

stinkptr	dw foomsg	; near pointer to reason string
stinkcode	dw 0x4711	; hex reason code

regmsg		db 13,10,"Registers AX BX CX DX:",7,0
		; AX BX CX DX (caller CS or PSP?)
		; (DS, ES, SI, DI, BP? SP?)

infomsg		db 13,10,"FDSHIELD:",7,0
stinkmsg	db 13,10,"System halted by FDSHIELD!",13,10
		db "Reason:",0
rebootmsg	db 13,10,"System will reboot after 20 seconds",13,10,0

tunnelmsg	db "Tunnelling attempt",0
patchvmsg	db "VSHIELD sabotage attempt",0
patchtmsg	db "TBDRIVER sabotage attempt",0
vsafemsg	db "Attempt to disable VSAFE / VWATCH",0
tbavmsg		db "Attempt to disable TBAV / TBDRIVER",0
tsrmsg		db "Program stayed in RAM",0
foomsg		db "???",0

		; Following are only for verbose mode:
vsafetmsg	db "VSAFE / VWATCH install check",0
tbavtmsg	db "TBAV / TBDRIVER install check",0
formatmsg	db "Harddisk format attempt",0
; tsrmsg - see above
boothmsg	db "Harddisk boot sector write attempt",0
bootfmsg	db "Floppy boot sector write attempt",0
wrprotmsg	db "Disk write attempt",0
i13rehookmsg	db "Tracking rehook of disk API",0

; ------------------------------------

strtty:		; display string at CS:SI
	push ax
strtty_loop:
	mov al,[cs:si]
	or al,al
	jz strtty_done
	call tty
	inc si
	jmp short strtty_loop
strtty_done:
	pop ax
	ret

; ------------------------------------

tty:		; display char AL - destroys AX
	push bx
	push bp
	mov ah,0x0e	; teletype
	mov bx,7	; page 0, color...
	int 0x10
	pop bp
	pop bx
	ret

; ------------------------------------

hexdump:	; display value in AX like printf(" %x",ax)
	push ax
	push bx
	push cx
	mov bx,ax
	mov al,' '
	call tty
	mov cl,12	; highest digit first
onedigit:
	mov ax,bx
	shr ax,cl
	and al,0x0f	; one nibble
	add al,'0'
	cmp al,'9'
	jbe decdigit
	add al,('A'-1)-'9'
decdigit:
	call tty
	sub cl,4	; next digit
	cmp cl,-4
	jnz onedigit
	pop cx
	pop bx
	pop ax
	ret

; ------------------------------------

regdump:
	push si
	mov si,regmsg
	call strtty
	pop si
	push ax
	; mov ax,ax
	call hexdump
	mov ax,bx
	call hexdump
	mov ax,cx
	call hexdump
	mov ax,dx
	call hexdump
	pop ax
	ret

; ------------------------------------
; ------------------------------------

install:

	mov si,dummy_vshield
	mov cx,dummy_vshield_end-dummy_vshield
	call checksum
	mov [dummy_vshield_sum],ax

	mov si,dummy_vshield2
	mov cx,dummy_vshield2_end-dummy_vshield2
	call checksum
	mov [dummy_vshield2_sum],ax

	mov si,tbdriver_tunnelcheck
	mov cx,tbdriver_tunnelcheck_end-tbdriver_tunnelcheck
	call checksum
	mov [tbdriver_tunnelcheck_sum],ax

	mov dx,bannermsg
	mov ah,9	; show string
	int 0x21

	mov ax,0x1683	; get current VM number (Windows 3+)
	xor bx,bx	; assume 0
	int 0x2f
	or bx,bx	; any?
	jz nowindows
	mov dx,winmsg	; Warn: Windows 3+ running (can spoil /v ...)!
	mov ah,9	; show string
	int 0x21
nowindows:

	mov byte [cs:flags],0	; all functions off by default
	mov si,0x81
parseloop:
	mov al,[si]
	inc si
	cmp al,9
	jz parseloop
	cmp al,'/'
	jz parseloop
	cmp al,' '
	jz parseloop
	cmp al,13
	jz parsedone
	cmp al,'?'
	jnz nohelp

helpme:	mov dx,helpmsg
	mov ah,9	; show string
	int 0x21
	mov ax,0x4c01	; exit here
	int 0x21

nohelp:	cmp al,'t'
	jnz no_t
	or byte [cs:flags],TSRBLOCK
	jmp short parseloop

no_t:	cmp al,'v'
	jnz no_v
	or byte [cs:flags],VERBOSE
	jmp short parseloop

no_v:	cmp al,'b'
	jnz no_b
	or byte [cs:flags],BOOTFLOP
	jmp short parseloop

no_b:	cmp al,'B'
	jnz no_b2
	or byte [cs:flags],BOOTHARD
	jmp short parseloop
	
no_b2:	cmp al,'w'
	jnz no_w
	or byte [cs:flags],WRITEFLOP
	jmp short parseloop
	
no_w:	cmp al,'W'
	jnz no_w2
	or byte [cs:flags],WRITEHARD
	jmp short parseloop
	
no_w2:	cmp al,'x'
	jnz no_x
	or byte [cs:flags],WRITEEXE
	jmp short parseloop

no_x:	jmp short helpme

; ------------------------------------

parsedone:	; now hook all those interrupt handlers

	mov [X13ptr+2],cs		; extra redirection layer
	mov word [X13ptr],extra13	; for int 2f.13 rehook trick

	mov si,intlist
	xor ax,ax
	push es
	mov es,ax
	cld
hookloop:
	lodsw
	or ax,ax
	jz hookdone
	mov di,ax	; int vector number
	add di,di
	add di,di	; offset into IDT
	lodsw		; handler offset
	mov bx,ax
	cli
	mov ax,[es:di]		; old handler offset
	mov [bx-4],ax		; store
	mov ax,[es:di+2]	; old handler segment
	mov [bx-2],ax		; store
	mov [es:di],bx		; new handler offset
	mov [es:di+2],cs	; new handler segment
	jmp short hookloop

hookdone:
	sti
	pop es
	mov dx,instmsg
	mov ah,9	; show string
	int 0x21

	push es
	mov es,[cs:0x2c]	; PSP[2c] -> environment segment
	mov ah,0x49	; free memory
	int 0x21
	pop es		; (errors ignored)

	mov dx,install	; stay resident but throw away installer
	add dx,15
	mov cl,4
	shr dx,cl	; converted to paragraphs now
	mov ax,0x3100	; terminate and stay resident
	int 0x21
selftsr:		; will be "return" CS:IP on stack...

intlist:
	dw 0x13, i13,   0x16, i16,   0x21, i21,   0x26, i26
	dw 0x27, i27,   0x2f, i2f,   0x40, i40,   0, 0

; ------------------------------------

bannermsg:
	db "FreeDOS FDSHIELD virus shield (c) by Eric Auer Jun-Jul/2004.",13,10
	db "Email: <eric*coli.uni-sb.de>. This is free open source",13,10
	db "software under GNU Public License (v2, see www.gnu.org).",13,10
	db "$"
winmsg	db "Warning: Windows is active!",13,10,"$"
instmsg	db "FDSHIELD installed now until the next reboot.",13,10,"$"

helpmsg	db 13,10
	db "Syntax:",13,10
	db "FDSHIELD [/?] [/v] [/t] [/b] [/B] [/w] [/W] [/x]",13,10
	db "v: verbose  t: TSR block  x: try exe/sys/com write protect",13,10
	db "b: floppy boot protect    B: harddisk boot protect",13,10
	db "w: floppy write protect   W: harddisk write protect ",13,10
	db "WARNING: TSR block halts the system if a new TSR loads!",13,10
	db "         Flush write caches before using write protection!",13,10
	db "The sabotage check and harddisk format block are always on.",13,10
	db "Combining /w and /W simulates read only attribute everythere.",13,10
%if 0
	db 13,10
	db "Not yet available: int hook check, network drive",13,10
	db "protection, signature and checksum test on open",13,10
	db "and exec and exit, checksum sabotage check, boot",13,10
	db "sector signature and checksum test on access and",13,10
	db "FDSHIELD start, executable write warn, hotkey...",13,10
	db 13,10
%endif
	db "$"
	; *** TODO: flush caches before enabling write protection! ***

	; *** Attrib will all be set to "readonly" in /w /W mode, but if
	; *** FindFirst/FindNext/Attrib43 could check drive letter then
	; *** we could process /w and /W attrib simulation separately...
