////////////////////////////////////////////////////////////////////////////
//                           **** WAVPACK ****                            //
//                  Hybrid Lossless Wavefile Compressor                   //
//              Copyright (c) 1998 - 2002 Conifer Software.               //
//                          All Rights Reserved.                          //
//      Distributed under the BSD Software License (see license.txt)      //
////////////////////////////////////////////////////////////////////////////

// words2.c

// This module provides the entropy word decoding function for files generated
// by WavPack versions 1 and 2.  Since these files are no longer created, this
// legacy module is essentially obsolete and will not be documented.

#include "wavpack.h"

#include <string.h>

void init_word2 (WavpackContext *wpc)
{
    CLEAR (wpc->w2);
}

#define inbits (&wpc->inbits)

long get_word2 (WavpackContext *wpc, int chan)
{
    int cbits, delta_dbits, dbits;
    long value, mask = 1;

    cbits = 0;

    while (getbit (inbits))
	if ((cbits += 2) == 50)
	    return WORD_EOF;

    if (getbit (inbits))
	cbits++;

    if (cbits == 0)
	delta_dbits = 0;
    else if (cbits & 1) {
	delta_dbits = (cbits + 1) / 2;

	if (wpc->w2.last_delta_sign [chan] > 0)
	    delta_dbits *= -1;

	wpc->w2.last_delta_sign [chan] = delta_dbits;
    }
    else {
	delta_dbits = cbits / 2;

	if (wpc->w2.last_delta_sign [chan] <= 0)
	    delta_dbits *= -1;
    }

    dbits = (wpc->w2.last_dbits [chan] += delta_dbits);

    if (dbits < 0 || dbits > 20)
	return WORD_EOF;

    if (!dbits)
	return 0L;

    if (wpc->wphdr->bits) {
	for (value = 1L << (dbits - 1); --dbits; mask <<= 1)
	    if (dbits < wpc->wphdr->bits && getbit (inbits))
		value |= mask;
    }
    else
	for (value = 1L << (dbits - 1); --dbits; mask <<= 1)
	    if (getbit (inbits))
		value |= mask;

    return getbit (inbits) ? -value : value;
}
