// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license
//-----------------------------------------------------------------------------
// Array test 11: negative strides.
//-----------------------------------------------------------------------------

// Include files

#include "Pooma/Pooma.h"
#include "Utilities/Tester.h"
#include "Domain/Loc.h"
#include "Domain/Interval.h"
#include "Domain/Range.h"
#include "Layout/UniformGridLayout.h"
#include "Engine/BrickEngine.h"
#include "Engine/MultiPatchEngine.h"
#include "Array/Array.h"

int main(int argc, char *argv[])
{
  Pooma::initialize(argc, argv);
  Pooma::Tester tester(argc, argv);

  Array<1, int> a(10), b(10);
  Array<2, int> c(10, 10);
  Loc<2> blocks(5,5);
  UniformGridLayout<2> layout(Interval<2>(10,10), blocks,ReplicatedTag());
  Array<2, int, MultiPatch<UniformTag,Brick> > u(layout);
  int i0, i1;

  // Block since we're starting scalar code.
    
  Pooma::blockAndEvaluate();
  
  for (i0 = 0; i0 < 9; i0++)
    a(i0) = b(i0) = i0;
  for (i1 = 0; i1 < 9; i1++)
    for (i0 = 0; i0 < 9; i0++)
      u(i0, i1) = c(i0,i1) = i1+10*i0;
    
  // Make some ranges with negative stride and use them.
  
  Range<1> R(7,3,-2), RR(2,0,-1);
  Range<1> Q(3,7,2);
  
  tester.check(all(a(R)(RR) == b(Q)));
  tester.check(all(c(1, R)(RR) == b(Q) + 10));
  tester.check(all(u(2, R)(RR) == b(Q) + 20));

  int ret = tester.results("array_test11");
  Pooma::finalize();
  return ret;
}

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: array_test11.cpp,v $   $Author: luchini $
// $Revision: 1.12 $   $Date: 2000/05/31 21:49:10 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
